/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.ui;

import com.sap.dbmtk.demo.ui.SortIcon;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class MultiSortTableCellHeaderRenderer
extends DefaultTableCellRenderer {
    protected SortIcon sortIcon = new SortIcon(8);

    public MultiSortTableCellHeaderRenderer() {
        this.setHorizontalAlignment(0);
        this.setHorizontalTextPosition(10);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader tableHeader = table.getTableHeader();
        Color fg = null;
        Color bg = null;
        Border border = null;
        Icon icon = null;
        if (hasFocus) {
            fg = UIManager.getColor("TableHeader.focusCellForeground");
            bg = UIManager.getColor("TableHeader.focusCellBackground");
            border = UIManager.getBorder("TableHeader.focusCellBorder");
        }
        if (fg == null) {
            fg = tableHeader.getForeground();
        }
        if (bg == null) {
            bg = tableHeader.getBackground();
        }
        if (border == null) {
            border = UIManager.getBorder("TableHeader.cellBorder");
        }
        if (!tableHeader.isPaintingForPrint() && table.getRowSorter() != null) {
            icon = this.getSortIcon(table, table.convertColumnIndexToModel(column));
        }
        this.setFont(tableHeader.getFont());
        this.setText(value != null && value != "" ? value.toString() : " ");
        this.setBorder(border);
        this.setIcon(icon);
        return this;
    }

    protected Icon getSortIcon(JTable table, int column) {
        List<RowSorter.SortKey> sortKeys = table.getRowSorter().getSortKeys();
        if (sortKeys == null || sortKeys.size() == 0) {
            return null;
        }
        int priority = 0;
        for (RowSorter.SortKey sortKey : sortKeys) {
            if (sortKey.getSortOrder() == SortOrder.UNSORTED) continue;
            if (sortKey.getColumn() == column) {
                this.sortIcon.setPriority(priority);
                this.sortIcon.setSortOrder(sortKey.getSortOrder());
                return this.sortIcon;
            }
            ++priority;
        }
        return null;
    }
}

