/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.ui;

import com.sap.dbmtk.demo.ui.ModelMissmatchException;
import com.sap.dbmtk.demo.ui.SqlProgressDialog;
import com.sap.dbmtk.demo.utils.Configuration;
import com.sap.dbmtk.demo.utils.StringUtil;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class ResultSetTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static Logger _logger = Logger.getLogger(ResultSetTableModel.class);
    public static final String PROPKEY_BINERY_PREFIX = "ResultSetTableModel.binary.prefix";
    public static final String DEFAULT_BINERY_PREFIX = "0x";
    public static final String PROPKEY_BINARY_TOUPPER = "ResultSetTableModel.binary.toUpper";
    public static final boolean DEFAULT_BINARY_TOUPPER = false;
    public static final String PROPKEY_PrintResultSetInfoLong = "ResultSetTableModel.print.rs.info.long";
    public static final boolean DEFAULT_PrintResultSetInfoLong = false;
    public static final String PROPKEY_NULL_REPLACE = "ResultSetTableModel.replace.null.with";
    public static final String DEFAULT_NULL_REPLACE = "(NULL)";
    public static final String PROPKEY_StringTrim = "ResultSetTableModel.string.trim";
    public static final boolean DEFAULT_StringTrim = true;
    public static final String PROPKEY_ShowRowNumber = "ResultSetTableModel.show.rowNumber";
    public static final boolean DEFAULT_ShowRowNumber = false;
    private static final String BINARY_PREFIX = Configuration.getCombinedConfiguration().getProperty("ResultSetTableModel.binary.prefix", "0x");
    private static final boolean BINARY_TOUPPER = Configuration.getCombinedConfiguration().getBooleanProperty("ResultSetTableModel.binary.toUpper", false);
    private static final String NULL_REPLACE = Configuration.getCombinedConfiguration().getProperty("ResultSetTableModel.replace.null.with", "(NULL)");
    public static final String ROW_NUMBER_COLNAME = "row#";
    private int _numcols;
    private ArrayList<String> _rsmdColumnName = new ArrayList();
    private ArrayList<String> _rsmdColumnLabel = new ArrayList();
    private ArrayList<Integer> _rsmdColumnType = new ArrayList();
    private ArrayList<String> _rsmdColumnTypeStr = new ArrayList();
    private ArrayList<String> _rsmdColumnTypeName = new ArrayList();
    private ArrayList<String> _rsmdColumnTypeNameStr = new ArrayList();
    private ArrayList<String> _rsmdColumnClassName = new ArrayList();
    private ArrayList<Integer> _displaySize = new ArrayList();
    private Class[] _classType = null;
    private ArrayList<ArrayList<Object>> _rows = new ArrayList();
    private int _readCount = 0;
    private SQLWarning _sqlWarning = null;
    private boolean _allowEdit = true;
    private String _name = null;
    private boolean _cancelled = false;
    private int _abortedAfterXRows = -1;
    private boolean _stringTrim = Configuration.getCombinedConfiguration().getBooleanProperty("ResultSetTableModel.string.trim", true);
    private boolean _showRowNumber = Configuration.getCombinedConfiguration().getBooleanProperty("ResultSetTableModel.show.rowNumber", false);
    private int _readResultSetTime = -1;

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public int getResultSetReadTime() {
        return this._readResultSetTime;
    }

    public ResultSetTableModel(ResultSet rs, String name) throws SQLException {
        this(rs, true, name, null);
    }

    public ResultSetTableModel(ResultSet rs, boolean editable, String name, SqlProgressDialog progress) throws SQLException {
        this(rs, editable, name, -1, false, progress);
    }

    public ResultSetTableModel(ResultSet rs, boolean editable, String name, int stopAfterXrows, boolean noData, SqlProgressDialog progress) throws SQLException {
        long startTime = System.currentTimeMillis();
        this._allowEdit = editable;
        this.setName(name);
        if (this.getName() != null) {
            this.setName(this.getName().replace('\n', ' '));
        }
        int maxDisplaySize = 32768;
        try {
            maxDisplaySize = Integer.parseInt(System.getProperty("ResultSetTableModel.maxDisplaySize", Integer.toString(maxDisplaySize)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        this._numcols = rsmd.getColumnCount() + 1;
        this._classType = new Class[this._numcols + (this._showRowNumber ? 1 : 0)];
        if (this._showRowNumber) {
            this._rsmdColumnLabel.add(ROW_NUMBER_COLNAME);
            this._rsmdColumnName.add(ROW_NUMBER_COLNAME);
            this._rsmdColumnType.add(new Integer(4));
            this._rsmdColumnTypeStr.add("--sqlw-generated-rowid--");
            this._rsmdColumnClassName.add("java.lang.Integer");
            this._rsmdColumnTypeName.add("int");
            this._rsmdColumnTypeNameStr.add("int");
            this._displaySize.add(new Integer(10));
            this._classType[0] = Integer.class;
        }
        for (int c = 1; c < this._numcols; ++c) {
            String columnLabel = rsmd.getColumnLabel(c);
            String columnName = rsmd.getColumnName(c);
            String columnClassName = rsmd.getColumnClassName(c);
            String columnTypeNameGen = ResultSetTableModel.getColumnTypeName(rsmd, c);
            String columnTypeNameRaw = "-unknown-";
            try {
                columnTypeNameRaw = rsmd.getColumnTypeName(c);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            int columnType = rsmd.getColumnType(c);
            int columnDisplaySize = Math.max(rsmd.getColumnDisplaySize(c), rsmd.getColumnLabel(c).length());
            if (columnDisplaySize > maxDisplaySize) {
                if (this._numcols == 2 && (columnType == -1 || columnType == 2005 || columnType == -4 || columnType == 2004)) {
                    columnDisplaySize = 80;
                } else {
                    _logger.info((Object)("For column '" + columnLabel + "', columnDisplaySize is '" + columnDisplaySize + "', which is above max value of '" + maxDisplaySize + "', using max value. The max value can be changed with java parameter '-DResultSetTableModel.maxDisplaySize=sizeInBytes'. ResultSetTableModel.name='" + this.getName() + "'"));
                    columnDisplaySize = maxDisplaySize;
                }
            }
            this._rsmdColumnLabel.add(columnLabel);
            this._rsmdColumnName.add(columnName);
            this._rsmdColumnType.add(new Integer(columnType));
            this._rsmdColumnTypeStr.add(ResultSetTableModel.getColumnJavaSqlTypeName(columnType));
            this._rsmdColumnClassName.add(columnClassName);
            this._rsmdColumnTypeName.add(columnTypeNameRaw);
            this._rsmdColumnTypeNameStr.add(columnTypeNameGen);
            this._displaySize.add(new Integer(columnDisplaySize));
        }
        String originProgressState = null;
        if (progress != null) {
            originProgressState = progress.getState();
        }
        this._readCount = 0;
        int rowCount = 0;
        while (rs.next()) {
            if (progress != null && progress.isCancelled()) {
                this._cancelled = true;
                break;
            }
            if (stopAfterXrows > 0 && this._readCount >= stopAfterXrows) {
                this._abortedAfterXRows = this._readCount;
                break;
            }
            ++this._readCount;
            if (progress != null && this._readCount % 100 == 0) {
                progress.setState(originProgressState + " row " + this._readCount);
            }
            this._sqlWarning = rs.getWarnings();
            rs.clearWarnings();
            if (noData) continue;
            ArrayList<Object> row = new ArrayList<Object>();
            if (this._showRowNumber) {
                row.add(new Integer(this._readCount));
            }
            for (int c = 1; c < this._numcols; ++c) {
                int c2;
                int type = this._rsmdColumnType.get(this._showRowNumber ? c : c - 1);
                Object o = this.getDataValue(rs, c, type);
                if (o != null && this._classType[c2 = c + (this._showRowNumber ? 1 : 0)] == null) {
                    this._classType[c2] = o.getClass();
                }
                if (o instanceof String && this._stringTrim) {
                    o = ((String)o).trim();
                }
                row.add(o);
            }
            if (!this.addRow(this._rsmdColumnLabel, row)) continue;
            this._rows.add(row);
            ++rowCount;
        }
        for (int c = 0; c < this._numcols - 1; ++c) {
            int type = this._rsmdColumnType.get(this._showRowNumber ? c + 1 : c);
            switch (type) {
                case -4: 
                case -3: 
                case -2: {
                    int size = this._displaySize.get(this._showRowNumber ? c + 1 : c);
                    this._displaySize.set(this._showRowNumber ? c + 1 : c, new Integer(size + BINARY_PREFIX.length()));
                }
            }
        }
        if (progress != null) {
            progress.setState(originProgressState + " Read done, rows " + this._readCount);
        }
        this._readResultSetTime = (int)(System.currentTimeMillis() - startTime);
    }

    private Object getDataValue(ResultSet rs, int col, int jdbcSqlType) throws SQLException {
        switch (jdbcSqlType) {
            case -7: {
                return rs.getBoolean(col);
            }
            case -6: {
                return rs.getObject(col);
            }
            case 5: {
                return rs.getObject(col);
            }
            case 4: {
                return rs.getObject(col);
            }
            case -5: {
                return rs.getObject(col);
            }
            case 6: {
                return rs.getObject(col);
            }
            case 7: {
                return rs.getObject(col);
            }
            case 8: {
                return rs.getObject(col);
            }
            case 2: {
                return rs.getObject(col);
            }
            case 3: {
                return rs.getObject(col);
            }
            case 1: {
                return rs.getString(col);
            }
            case 12: {
                return rs.getString(col);
            }
            case -1: {
                return rs.getString(col);
            }
            case 91: {
                return rs.getDate(col);
            }
            case 92: {
                return rs.getTime(col);
            }
            case 93: {
                return rs.getTimestamp(col);
            }
            case -2: {
                return StringUtil.bytesToHex(BINARY_PREFIX, rs.getBytes(col), BINARY_TOUPPER);
            }
            case -3: {
                return StringUtil.bytesToHex(BINARY_PREFIX, rs.getBytes(col), BINARY_TOUPPER);
            }
            case -4: {
                return StringUtil.bytesToHex(BINARY_PREFIX, rs.getBytes(col), BINARY_TOUPPER);
            }
            case 0: {
                return rs.getObject(col);
            }
            case 1111: {
                return rs.getObject(col);
            }
            case 2000: {
                return rs.getObject(col);
            }
            case 2001: {
                return rs.getObject(col);
            }
            case 2002: {
                return rs.getObject(col);
            }
            case 2003: {
                return rs.getObject(col);
            }
            case 2004: {
                return StringUtil.bytesToHex(BINARY_PREFIX, rs.getBytes(col), BINARY_TOUPPER);
            }
            case 2005: {
                return rs.getString(col);
            }
            case 2006: {
                return rs.getObject(col);
            }
            case 70: {
                return rs.getObject(col);
            }
            case 16: {
                return rs.getBoolean(col);
            }
            case -8: {
                return rs.getObject(col);
            }
            case -15: {
                return rs.getString(col);
            }
            case -9: {
                return rs.getString(col);
            }
            case -16: {
                return rs.getString(col);
            }
            case 2011: {
                return rs.getString(col);
            }
            case 2009: {
                return rs.getString(col);
            }
        }
        return rs.getString(col);
    }

    public int getReadCount() {
        return this._readCount;
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public boolean wasAbortedAfterXRows() {
        return this._abortedAfterXRows >= 0;
    }

    public int getAbortedAfterXRows() {
        return this._abortedAfterXRows;
    }

    public void setModelData(ResultSetTableModel rstm, boolean merge) throws ModelMissmatchException {
        int i;
        if (this.getColumnCount() != rstm.getColumnCount()) {
            throw new ModelMissmatchException("Column COUNT missmatch. current count=" + this.getColumnCount() + ", passed count=" + rstm.getColumnCount());
        }
        for (i = 0; i < this.getColumnCount(); ++i) {
            if (this._rsmdColumnLabel.get(i).equals(rstm._rsmdColumnLabel.get(i))) continue;
            throw new ModelMissmatchException("Column NAME missmatch. current columns=" + this._rsmdColumnLabel + ", passed columns=" + rstm._rsmdColumnLabel);
        }
        for (i = 0; i < this.getColumnCount(); ++i) {
            if (this._rsmdColumnTypeStr.get(i).equals(rstm._rsmdColumnTypeStr.get(i))) continue;
            throw new ModelMissmatchException("Column DATATYPE missmatch. current jdbcDataTypes=" + this._rsmdColumnTypeStr + ", passed jdbcDataTypes=" + rstm._rsmdColumnTypeStr);
        }
        if (!merge) {
            this._rows = rstm._rows;
            this.fireTableDataChanged();
        } else {
            this._rows.addAll(rstm._rows);
            this.fireTableDataChanged();
        }
    }

    private boolean addRow(ArrayList<String> cols, ArrayList<Object> row) {
        return true;
    }

    public static String getColumnTypeName(ResultSetMetaData rsmd, int col) {
        String columnTypeName;
        try {
            columnTypeName = rsmd.getColumnTypeName(col);
            try {
                int columnType = rsmd.getColumnType(col);
                if (columnType == 2 || columnType == 3) {
                    int precision = rsmd.getPrecision(col);
                    int scale = rsmd.getScale(col);
                    columnTypeName = columnTypeName + "(" + precision + "," + scale + ")";
                }
                if (columnType == 1 || columnType == 12 || columnType == -15 || columnType == -9 || columnType == -2 || columnType == -3) {
                    int columnDisplaySize = rsmd.getColumnDisplaySize(col);
                    columnTypeName = columnTypeName + "(" + columnDisplaySize + ")";
                }
            }
            catch (SQLException columnType) {}
        }
        catch (SQLException e) {
            columnTypeName = "unhandled-jdbc-datatype";
            try {
                int columnType = rsmd.getColumnType(col);
                int columnDisplaySize = rsmd.getColumnDisplaySize(col);
                int precision = 0;
                int scale = 0;
                if (columnType == 2 || columnType == 3) {
                    precision = rsmd.getPrecision(col);
                    scale = rsmd.getScale(col);
                }
                switch (columnType) {
                    case -7: {
                        return "bit";
                    }
                    case -6: {
                        return "tinyint";
                    }
                    case 5: {
                        return "smallint";
                    }
                    case 4: {
                        return "int";
                    }
                    case -5: {
                        return "bigint";
                    }
                    case 6: {
                        return "float";
                    }
                    case 7: {
                        return "real";
                    }
                    case 8: {
                        return "double";
                    }
                    case 2: {
                        return "numeric(" + precision + "," + scale + ")";
                    }
                    case 3: {
                        return "decimal(" + precision + "," + scale + ")";
                    }
                    case 1: {
                        return "char(" + columnDisplaySize + ")";
                    }
                    case 12: {
                        return "varchar(" + columnDisplaySize + ")";
                    }
                    case -1: {
                        return "text";
                    }
                    case 91: {
                        return "date";
                    }
                    case 92: {
                        return "time";
                    }
                    case 93: {
                        return "datetime";
                    }
                    case -2: {
                        return "binary(" + columnDisplaySize + ")";
                    }
                    case -3: {
                        return "varbinary(" + columnDisplaySize + ")";
                    }
                    case -4: {
                        return "image";
                    }
                    case 0: {
                        return "-null-";
                    }
                    case 1111: {
                        return "-other-";
                    }
                    case 2000: {
                        return "-java_object";
                    }
                    case 2004: {
                        return "image";
                    }
                    case 2005: {
                        return "text";
                    }
                    case 16: {
                        return "bit";
                    }
                }
                columnTypeName = "unknown-jdbc-datatype(" + columnType + ")";
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return columnTypeName;
    }

    public static String getColumnJavaSqlTypeName(int columnType) {
        switch (columnType) {
            case -7: {
                return "java.sql.Types.BIT";
            }
            case -6: {
                return "java.sql.Types.TINYINT";
            }
            case 5: {
                return "java.sql.Types.SMALLINT";
            }
            case 4: {
                return "java.sql.Types.INTEGER";
            }
            case -5: {
                return "java.sql.Types.BIGINT";
            }
            case 6: {
                return "java.sql.Types.FLOAT";
            }
            case 7: {
                return "java.sql.Types.REAL";
            }
            case 8: {
                return "java.sql.Types.DOUBLE";
            }
            case 2: {
                return "java.sql.Types.NUMERIC";
            }
            case 3: {
                return "java.sql.Types.DECIMAL";
            }
            case 1: {
                return "java.sql.Types.CHAR";
            }
            case 12: {
                return "java.sql.Types.VARCHAR";
            }
            case -1: {
                return "java.sql.Types.LONGVARCHAR";
            }
            case 91: {
                return "java.sql.Types.DATE";
            }
            case 92: {
                return "java.sql.Types.TIME";
            }
            case 93: {
                return "java.sql.Types.TIMESTAMP";
            }
            case -2: {
                return "java.sql.Types.BINARY";
            }
            case -3: {
                return "java.sql.Types.VARBINARY";
            }
            case -4: {
                return "java.sql.Types.LONGVARBINARY";
            }
            case 0: {
                return "java.sql.Types.NULL";
            }
            case 1111: {
                return "java.sql.Types.OTHER";
            }
            case 2000: {
                return "java.sql.Types.JAVA_OBJECT";
            }
            case 2001: {
                return "java.sql.Types.DISTINCT";
            }
            case 2002: {
                return "java.sql.Types.STRUCT";
            }
            case 2003: {
                return "java.sql.Types.ARRAY";
            }
            case 2004: {
                return "java.sql.Types.BLOB";
            }
            case 2005: {
                return "java.sql.Types.CLOB";
            }
            case 2006: {
                return "java.sql.Types.REF";
            }
            case 70: {
                return "java.sql.Types.DATALINK";
            }
            case 16: {
                return "java.sql.Types.BOOLEAN";
            }
            case -8: {
                return "java.sql.Types.ROWID";
            }
            case -15: {
                return "java.sql.Types.NCHAR";
            }
            case -9: {
                return "java.sql.Types.NVARCHAR";
            }
            case -16: {
                return "java.sql.Types.LONGNVARCHAR";
            }
            case 2011: {
                return "java.sql.Types.NCLOB";
            }
            case 2009: {
                return "java.sql.Types.SQLXML";
            }
            case -10: {
                return "oracle.jdbc.OracleTypes.CURSOR";
            }
        }
        return "unknown-jdbc-datatype(" + columnType + ")";
    }

    public SQLWarning getSQLWarning() {
        return this._sqlWarning;
    }

    @Override
    public int getColumnCount() {
        return this._rsmdColumnLabel.size();
    }

    @Override
    public int getRowCount() {
        return this._rows.size();
    }

    @Override
    public String getColumnName(int column) {
        return this._rsmdColumnLabel.get(column);
    }

    @Override
    public Class<?> getColumnClass(int colid) {
        if (this.getRowCount() == 0) {
            return Object.class;
        }
        Class<Object> clazz = this._classType[colid + 1];
        if (clazz == null) {
            clazz = Object.class;
        }
        return clazz;
    }

    @Override
    public Object getValueAt(int r, int c) {
        ArrayList<Object> row = this._rows.get(r);
        Object o = row.get(c);
        return o != null ? o : NULL_REPLACE;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this._allowEdit;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
    }

    public String getToolTipTextForTableHeader(int index) {
        if (this._showRowNumber && index == 0) {
            return "<html>Column '<b><code>row#</code></b>' is not part of the actual Result Set, it has been added when reading the data.</html>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<HTML>");
        sb.append("Below is information about the Column based on the JDBC ResultSetMetaData object.<br>");
        sb.append("<TABLE ALIGN=\"left\" BORDER=1 CELLSPACING=1 CELLPADDING=1 WIDTH=\"100%\">");
        sb.append("<TR ALIGN=\"left\" VALIGN=\"middle\"> <TH>Description               </TH> <TH>From Java Method                     </TH> <TH>Value</TH> </TR>");
        sb.append("<TR ALIGN=\"left\" VALIGN=\"middle\"> <TD>Label                     </TD> <TD>rsmd.getColumnLabel()                </TD> <TD>").append(this._rsmdColumnLabel.get(index)).append("</TD> </TR>");
        sb.append("<TR ALIGN=\"left\" VALIGN=\"middle\"> <TD>Name                      </TD> <TD>rsmd.getColumnName()                 </TD> <TD>").append(this._rsmdColumnName.get(index)).append("</TD> </TR>");
        sb.append("<TR ALIGN=\"left\" VALIGN=\"middle\"> <TD>JDBC Type Name            </TD> <TD>rsmd.getColumnType()<b>->String</b>  </TD> <TD>").append(this._rsmdColumnTypeStr.get(index)).append("</TD> </TR>");
        sb.append("<TR ALIGN=\"left\" VALIGN=\"middle\"> <TD>JDBC Type Number          </TD> <TD>rsmd.getColumnType()                 </TD> <TD>").append(this._rsmdColumnType.get(index)).append("</TD> </TR>");
        sb.append("<TR ALIGN=\"left\" VALIGN=\"middle\"> <TD>Java Class Name           </TD> <TD>rsmd.getColumnClassName()            </TD> <TD>").append(this._rsmdColumnClassName.get(index)).append("</TD> </TR>");
        sb.append("<TR ALIGN=\"left\" VALIGN=\"middle\"> <TD>Raw DBMS Datatype         </TD> <TD>rsmd.getColumnTypeName()             </TD> <TD>").append(this._rsmdColumnTypeName.get(index)).append("</TD> </TR>");
        sb.append("<TR ALIGN=\"left\" VALIGN=\"middle\"> <TD>Guessed DBMS Type         </TD> <TD>rsmd.getColumnTypeName()<b>+size</b> </TD> <TD>").append(this._rsmdColumnTypeNameStr.get(index)).append("</TD> </TR>");
        sb.append("<TR ALIGN=\"left\" VALIGN=\"middle\"> <TD>TableModel Class Name     </TD> <TD>TableModel.getColumnClass()          </TD> <TD>").append(this.getColumnClass(index)).append("</TD> </TR>");
        sb.append("</TABLE>");
        sb.append("</HTML>");
        return sb.toString();
    }

    public String getResultSetInfo() {
        int c;
        int c2;
        StringBuilder sb = new StringBuilder();
        boolean ld = Configuration.getCombinedConfiguration().getBooleanProperty(PROPKEY_PrintResultSetInfoLong, false);
        ArrayList<String> header1 = new ArrayList<String>();
        ArrayList<String> header2 = new ArrayList<String>();
        header1.add("Col#");
        header2.add(" ");
        header1.add("Label");
        header2.add("rsmd.getColumnLabel()");
        if (ld) {
            header1.add("Name");
            header2.add("rsmd.getColumnName()");
        }
        header1.add("JDBC Type Name");
        header2.add("rsmd.getColumnType()->String");
        if (ld) {
            header1.add("JDBC Type Number");
            header2.add("rsmd.getColumnType()");
        }
        if (ld) {
            header1.add("JDBC Class Name");
            header2.add("rsmd.getColumnClassName()");
        }
        if (ld) {
            header1.add("Raw DBMS Datatype");
            header2.add("rsmd.getColumnTypeName()");
        }
        header1.add("Guessed DBMS type");
        header2.add("rsmd.getColumnTypeName()+size");
        if (ld) {
            header1.add("TableModel Class Name");
            header2.add("TableModel.getColumnClass()");
        }
        int headCols = header1.size();
        int numColsInRs = this._numcols - 1;
        int startAt = 0;
        if (this._showRowNumber) {
            startAt = 1;
            ++numColsInRs;
        }
        ArrayList rows = new ArrayList();
        for (int c3 = startAt; c3 < numColsInRs; ++c3) {
            ArrayList<String> row = new ArrayList<String>();
            rows.add(row);
            row.add("" + (this._showRowNumber ? c3 : c3 + 1));
            row.add("" + this._rsmdColumnLabel.get(c3));
            if (ld) {
                row.add("" + this._rsmdColumnName.get(c3));
            }
            row.add("" + this._rsmdColumnTypeStr.get(c3));
            if (ld) {
                row.add("" + this._rsmdColumnType.get(c3));
            }
            if (ld) {
                row.add("" + this._rsmdColumnClassName.get(c3));
            }
            if (ld) {
                row.add("" + this._rsmdColumnTypeName.get(c3));
            }
            row.add("" + this._rsmdColumnTypeNameStr.get(c3));
            if (!ld) continue;
            row.add("" + this.getColumnClass(c3));
        }
        int[] maxLen = new int[header1.size()];
        for (int c22 = 0; c22 < headCols; ++c22) {
            maxLen[c22] = Math.max(maxLen[c22], ((String)header1.get(c22)).length());
        }
        if (ld) {
            for (c2 = 0; c2 < headCols; ++c2) {
                maxLen[c2] = Math.max(maxLen[c2], ((String)header2.get(c2)).length());
            }
        }
        for (c2 = 0; c2 < headCols; ++c2) {
            for (ArrayList arrayList : rows) {
                maxLen[c2] = Math.max(maxLen[c2], ((String)arrayList.get(c2)).length());
            }
        }
        String prefix = "RS>";
        sb.append(prefix);
        for (c = 0; c < headCols; ++c) {
            sb.append(" ").append(StringUtil.left((String)header1.get(c), maxLen[c]));
        }
        sb.append("\n");
        if (ld) {
            sb.append(prefix);
            for (c = 0; c < headCols; ++c) {
                sb.append(" ").append(StringUtil.left((String)header2.get(c), maxLen[c]));
            }
            sb.append("\n");
        }
        sb.append(prefix);
        for (c = 0; c < headCols; ++c) {
            sb.append(" ").append(StringUtil.replicate("-", maxLen[c]));
        }
        sb.append("\n");
        for (ArrayList arrayList : rows) {
            sb.append(prefix);
            for (int c4 = 0; c4 < headCols; ++c4) {
                sb.append(" ").append(StringUtil.left((String)arrayList.get(c4), maxLen[c4]));
            }
            sb.append("\n");
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        return sb.toString();
    }

    public int getSqlType(int column) {
        return this._rsmdColumnType.get(column);
    }

    public int getColumnDisplaySize(int column) {
        return this._displaySize.get(column);
    }

    public String getColumnNameFullSize(int column) {
        int fullSize = this.getColumnDisplaySize(column);
        return StringUtil.left(this.getColumnName(column), fullSize);
    }

    public String getColumnLineFullSize(int column) {
        int fullSize = this.getColumnDisplaySize(column);
        return StringUtil.replicate("-", fullSize);
    }

    public String getValueAtFullSize(int r, int c) {
        ArrayList<Object> row = this._rows.get(r);
        Object o = row.get(c);
        String str = o == null ? "NULL" : o.toString();
        int fullSize = this.getColumnDisplaySize(c);
        if (o instanceof Number) {
            return StringUtil.right(str, fullSize);
        }
        return StringUtil.left(str, fullSize);
    }

    public String toTableString() {
        return this.toTableString(" ");
    }

    public String toTableString(String colSep) {
        int c;
        StringBuilder sb = new StringBuilder(1024);
        int cols = this.getColumnCount();
        int rows = this.getRowCount();
        for (c = 0; c < cols; ++c) {
            sb.append(colSep).append(this.getColumnNameFullSize(c));
        }
        sb.append("\n");
        for (c = 0; c < cols; ++c) {
            sb.append(colSep).append(this.getColumnLineFullSize(c));
        }
        sb.append("\n");
        for (int r = 0; r < rows; ++r) {
            for (int c2 = 0; c2 < cols; ++c2) {
                sb.append(colSep).append(this.getValueAtFullSize(r, c2));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toHtmlTableString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<table border=1>\n");
        int cols = this.getColumnCount();
        int rows = this.getRowCount();
        sb.append("<tr>");
        for (int c = 0; c < cols; ++c) {
            sb.append("<td nowrap>").append(this.getColumnName(c)).append("</td>");
        }
        sb.append("</tr>\n");
        sb.append("<tr>");
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                sb.append("<td nowrap>").append(this.getValueAtFullSize(r, c)).append("</td>");
            }
            sb.append("\n");
        }
        sb.append("</tr>\n");
        sb.append("</table>\n");
        return sb.toString();
    }

    public String toHtmlTableString(int mrow, boolean borders) {
        StringBuilder sb = new StringBuilder(1024);
        int cols = this.getColumnCount();
        String border = borders ? " border=1" : " border=0";
        sb.append("<table").append(border).append(">\n");
        for (int c = 0; c < cols; ++c) {
            sb.append("<tr>");
            sb.append("<td nowrap><b>").append(this.getColumnName(c)).append("</b></td>");
            sb.append("<td nowrap>").append(this.getValueAt(mrow, c)).append("</td>");
            sb.append("</tr>\n");
        }
        sb.append("</table>\n");
        return sb.toString();
    }

    public String getValueAsString(int mrow, String colName) {
        return this.getValueAsString(mrow, colName, true);
    }

    public String getValueAsString(int mrow, String colName, boolean caseSensitive) {
        Object o = this.getValueAsObject(mrow, colName, caseSensitive);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public Short getValueAsShort(int mrow, String colName) {
        return this.getValueAsShort(mrow, colName, true);
    }

    public Short getValueAsShort(int mrow, String colName, boolean caseSensitive) {
        Object o = this.getValueAsObject(mrow, colName, caseSensitive);
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        try {
            return Short.parseShort(o.toString());
        }
        catch (NumberFormatException e) {
            _logger.warn((Object)("Problem reading Short value for mrow=" + mrow + ", column='" + colName + "', TableModelNamed='" + this.getName() + "', returning null. Caught: " + e));
            return null;
        }
    }

    public Integer getValueAsInteger(int mrow, String colName) {
        return this.getValueAsInteger(mrow, colName, true);
    }

    public Integer getValueAsInteger(int mrow, String colName, boolean caseSensitive) {
        Object o = this.getValueAsObject(mrow, colName, caseSensitive);
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        try {
            return Integer.parseInt(o.toString());
        }
        catch (NumberFormatException e) {
            _logger.warn((Object)("Problem reading Integer value for mrow=" + mrow + ", column='" + colName + "', TableModelNamed='" + this.getName() + "', returning null. Caught: " + e));
            return null;
        }
    }

    public Long getValueAsLong(int mrow, String colName) {
        return this.getValueAsLong(mrow, colName, true);
    }

    public Long getValueAsLong(int mrow, String colName, boolean caseSensitive) {
        Object o = this.getValueAsObject(mrow, colName, caseSensitive);
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        try {
            return Long.parseLong(o.toString());
        }
        catch (NumberFormatException e) {
            _logger.warn((Object)("Problem reading Long value for mrow=" + mrow + ", column='" + colName + "', TableModelNamed='" + this.getName() + "', returning null. Caught: " + e));
            return null;
        }
    }

    public Timestamp getValueAsTimestamp(int mrow, String colName) {
        return this.getValueAsTimestamp(mrow, colName, true);
    }

    public Timestamp getValueAsTimestamp(int mrow, String colName, boolean caseSensitive) {
        Object o = this.getValueAsObject(mrow, colName, caseSensitive);
        if (o == null) {
            return null;
        }
        if (o instanceof Timestamp) {
            return (Timestamp)o;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat();
            Date date = sdf.parse(o.toString());
            return new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            _logger.warn((Object)("Problem reading Timestamp value for mrow=" + mrow + ", column='" + colName + "', TableModelNamed='" + this.getName() + "', returning null. Caught: " + e));
            return null;
        }
    }

    public BigDecimal getValueAsBigDecimal(int mrow, String colName) {
        return this.getValueAsBigDecimal(mrow, colName, true);
    }

    public BigDecimal getValueAsBigDecimal(int mrow, String colName, boolean caseSensitive) {
        Object o = this.getValueAsObject(mrow, colName, caseSensitive);
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        try {
            return new BigDecimal(o.toString());
        }
        catch (NumberFormatException e) {
            _logger.warn((Object)("Problem reading BigDecimal value for mrow=" + mrow + ", column='" + colName + "', TableModelNamed='" + this.getName() + "', returning null. Caught: " + e));
            return null;
        }
    }

    public Object getValueAsObject(int mrow, String colName) {
        return this.getValueAsObject(mrow, colName, true);
    }

    public Object getValueAsObject(int mrow, String colName, boolean caseSensitive) {
        ResultSetTableModel tm = this;
        int mcol = -1;
        for (int c = 0; c < tm.getColumnCount(); ++c) {
            if (!(caseSensitive ? colName.equals(tm.getColumnName(c)) : colName.equalsIgnoreCase(tm.getColumnName(c)))) continue;
            mcol = c;
            break;
        }
        if (mcol < 0) {
            throw new RuntimeException("Can't find column '" + colName + "' in TableModel named '" + this.getName() + "'.");
        }
        Object o = tm.getValueAt(mrow, mcol);
        if (tm instanceof ResultSetTableModel && o != null && o instanceof String && DEFAULT_NULL_REPLACE.equals(o)) {
            return null;
        }
        return o;
    }
}

