/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.ui;

import com.sap.dbmtk.demo.ui.GLabel;
import com.sap.dbmtk.demo.utils.AseConnectionUtils;
import com.sap.dbmtk.demo.utils.Configuration;
import com.sap.dbmtk.demo.utils.DbUtils;
import com.sap.dbmtk.demo.utils.StringUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;

public class StatusBar
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static String NOT_CONNECTED = "Not Connected";
    private JLabel _msgline = new JLabel("");
    private JTextArea _currentFilename = new JTextArea("");
    private GLabel _currentFilenameEncoding = new GLabel();
    private JLabel _currentFilenameIsDirty = new JLabel("*");
    private JLabel _userName = new JLabel("");
    private JLabel _serverName = new JLabel(NOT_CONNECTED);
    private GLabel _productStringShort = new GLabel("");
    private String _productStringLong = null;
    private String _productVersion = null;
    private String _productServerName = null;
    private GLabel _aseConnStateInfo = new GLabel("");
    private JLabel _editorAtLineCol = new JLabel("1,1");
    private ServerInfo _serverInfo = null;
    private static final String FILENAME_TOOLTIP_BASE = "<html>Name of the current file.<br><br><b>File Encoding</b>: CHARSET-NAME<br><br>What encoding is the file using.<br>Or actually: The encoding we have <b>guessed</b> that it's using.<br><br>The guess is based on: <br>The library <b>juniversalchardet</b> which is a Java port of 'universalchardet', that is the encoding detector library of Mozilla.<br>More information can be found at <br><ul>   <li><A HREF=\"http://code.google.com/p/juniversalchardet\">http://code.google.com/p/juniversalchardet</A> </li>   <li><A HREF=\"http://www-archive.mozilla.org/projects/intl/UniversalCharsetDetection.html\">http://www-archive.mozilla.org/projects/intl/UniversalCharsetDetection.html</A> </li></ul></html>";
    private static final String ASE_STATE_INFO_TOOLTIP_BASE = "<html>Various status for the current connection. Are we in a transaction or not.<br><br><code>@@trancount</code> / TranCount Explanation:<ul>  <li>Simply a counter on <code>begin transaction</code> nesting level<br>      Try to issue <code>begin/commit/rollback tran</code> multiple times and see how @@trancount increases/decreases (rollback always resets it to 0)</li></ul><code>@@transtate</code> / TranState Explanation:<ul>  <li><b>TRAN_IN_PROGRESS:</b> Transaction in progress. A transaction is in effect; The previous statement executed successfully</li>  <li><b>TRAN_SUCCEED:    </b> Last Transaction succeeded. The transaction completed and committed its changes.</li>  <li><b>STMT_ABORT:      </b> Last Statement aborted. The previous statement was aborted; No effect on the transaction.</li>  <li><b>TRAN_ABORT:      </b> Last Transaction aborted. The transaction aborted and rolled back any changes.<br>                               To get rid of status 'TRAN_ABORT' simply issue <code>begin tran commit tran</code> to induce a dummy transaction that succeeds...<br>      </li></ul><br><code>@@tranchained</code> / TranChained Explanation:<ul>  <li><b>0</b>: autocommit=true  (<code>set chained off</code>): The default mode, called <b>unchained</b> mode or Transact-SQL mode, requires explicit <b>begin transaction</b> statements paired with <b>commit transaction</b> or <b>rollback transaction</b> statements to complete the transaction.</li>  <li><b>1</b>: autocommit=false (<code>set chained on</code>):  <b>chained</b> mode implicitly begins a transaction before any data-retrieval or modification statement: <b>delete</b>, <b>insert</b>, <b>open</b>, <b>fetch</b>, <b>select</b>, and <b>update</b>. You must still explicitly end the transaction with <b>commit transaction</b> or <b>rollback transaction</b></li></ul></html>";
    private static final String ASE_STATE_INFO_TOOLTIP_BASE_NO_TRANSTATE = "<html>Various status for the current connection. Are we in a transaction or not.<br><br><code>@@trancount</code> / TranCount Explanation:<br><ul>  <li>Simply a counter on <code>begin transaction</code> nesting level<br>      Try to issue <code>begin/commit/rollback tran</code> multiple times and see how @@trancount increases/decreases (rollback always resets it to 0)</li></ul></html>";
    private static final String JDBC_STATE_INFO_TOOLTIP_BASE = "<html>Various status for the current connection. Are we in a transaction or not.<br></html>";
    private static final String MSG_LINE_TOOLTIP_BASE = "Various status information from the tool.";
    public static final String NO_FILE = "no-file";

    public StatusBar() {
        this.init();
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("insets 2 5 2 5"));
        this._msgline.setToolTipText(MSG_LINE_TOOLTIP_BASE);
        this._aseConnStateInfo.setToolTipText(ASE_STATE_INFO_TOOLTIP_BASE);
        this._currentFilenameIsDirty.setVisible(false);
        this._currentFilenameIsDirty.setToolTipText("The file has been changed.");
        this._currentFilename.setToolTipText(FILENAME_TOOLTIP_BASE);
        this._currentFilename.setEditable(false);
        this._currentFilename.setBackground(this._currentFilenameIsDirty.getBackground());
        this._currentFilename.setFont(this._currentFilenameIsDirty.getFont());
        this._currentFilenameEncoding.setToolTipText("<html>What encoding is the file using.<br>Or actually: The encoding we have <b>guessed</b> that it's using.<br><br>The guess is based on: <br>The library <b>juniversalchardet</b> which is a Java port of 'universalchardet', that is the encoding detector library of Mozilla.<br>More information can be found at <br><ul>   <li><A HREF=\"http://code.google.com/p/juniversalchardet\">http://code.google.com/p/juniversalchardet</A> </li>   <li><A HREF=\"http://www-archive.mozilla.org/projects/intl/UniversalCharsetDetection.html\">http://www-archive.mozilla.org/projects/intl/UniversalCharsetDetection.html</A> </li></ul></html>");
        this._userName.setToolTipText("What users did we connect as");
        this._serverName.setToolTipText("What Server Name are we connected to");
        this._productStringShort.setToolTipText("");
        this._editorAtLineCol.setToolTipText("Carets position 'Line:Col'");
        this.add((Component)this._msgline, "width 200:200:null:push");
        this.add((Component)new JSeparator(1), "grow");
        this.add((Component)new JLabel(), "pushx, growx");
        this.add((Component)this._aseConnStateInfo, "split, growx, hidemode 2");
        this.add((Component)new JSeparator(1), "grow");
        this.add((Component)this._userName, "growx");
        this.add((Component)new JSeparator(1), "grow");
        this.add((Component)this._serverName, "growx");
        this.add((Component)new JSeparator(1), "grow");
        this.add((Component)this._productStringShort, "growx");
        this.add((Component)new JSeparator(1), "grow");
        this.add((Component)this._editorAtLineCol, "growx, hidemode 3");
    }

    public void setMsg(String text) {
        this._msgline.setText(text);
        this._msgline.setToolTipText("<html>Various status information from the tool.<br><hr><b>" + text + "</b></html>");
    }

    public void setEditorPos(int line, int col) {
        this._editorAtLineCol.setText(line + 1 + ":" + (col + 1));
    }

    public void setVisibleAtLineCol(boolean visible) {
        this._editorAtLineCol.setVisible(visible);
    }

    public String getFilename() {
        return this._currentFilename.getText();
    }

    public void setFilename(String filename, String encoding) {
        File f = new File(filename);
        if (!f.exists()) {
            this._currentFilename.setText(NO_FILE);
            this._currentFilenameEncoding.setText("");
            return;
        }
        this._currentFilename.setText(filename);
        this._currentFilenameEncoding.setText(encoding == null ? "" : encoding);
        this._currentFilename.setToolTipText(FILENAME_TOOLTIP_BASE.replace("CHARSET-NAME", encoding == null ? "UNKNOWN" : encoding));
    }

    public void setFilenameDirty(boolean dirty) {
        this._currentFilenameIsDirty.setVisible(dirty);
    }

    public void setNotConnected() {
        this.setServerInfo(null);
        this.setAseConnectionStateInfo(null);
    }

    public void setServerInfo(ServerInfo si) {
        this._serverInfo = si;
        if (si == null) {
            this._productStringShort.setToolTipText(NOT_CONNECTED);
            this._productStringShort.setText("");
            this._productStringLong = "";
            this._productVersion = "";
            this._productServerName = "";
            this._serverName.setText("");
            this._userName.setText("");
            return;
        }
        this._productStringShort.setText(si.getProductNameShort());
        this._productStringLong = si.getProductName();
        this._productVersion = si.getProductVersion();
        this._productServerName = si.getServerName();
        this._serverName.setText(si.getServerName());
        this._userName.setText(si.getUsername());
        if ("".equals(si.getProductNameShort())) {
            this._productStringShort.setToolTipText(NOT_CONNECTED);
        } else {
            String listeners = "";
            if (!StringUtil.isNullOrBlank(si.getSysListeners())) {
                listeners = "    <li>ASE Listens on: <b>" + si.getSysListeners() + "</b></li>";
            }
            this._productStringShort.setToolTipText("<html>Connected to:<br><ul>" + (StringUtil.isNullOrBlank(si.getServerName()) ? "" : "<li>Server Name: <b>" + si.getServerName() + "</b></li>") + "    <li>Product Name:    <b>" + si.getProductName() + "</b></li>    <li>Product Version: <b>" + si.getProductVersion() + "</b></li>" + listeners + (StringUtil.isNullOrBlank(si.getCharset()) ? "" : "<li>Server Charset:      <b>" + si.getCharset() + "</b></li>") + (StringUtil.isNullOrBlank(si.getSortorder()) ? "" : "<li>Server SortOrder:    <b>" + si.getSortorder() + "</b></li>") + (StringUtil.isNullOrBlank(si.getClientCharsetId()) ? "" : "<li>Client Charset ID:   <b>" + si.getClientCharsetId() + "</b></li>") + (StringUtil.isNullOrBlank(si.getClientCharsetName()) ? "" : "<li>Client Charset Name: <b>" + si.getClientCharsetName() + "</b></li>") + (StringUtil.isNullOrBlank(si.getClientCharsetDesc()) ? "" : "<li>Client Charset Desc: <b>" + si.getClientCharsetDesc() + "</b></li>") + "</ul></html>");
        }
    }

    public String getServerName() {
        return this._serverName.getText();
    }

    public void setAseConnectionStateInfo(AseConnectionUtils.ConnectionStateInfo csi) {
        String basicText;
        if (csi == null) {
            this._aseConnStateInfo.setVisible(false);
            return;
        }
        boolean showExtendedErrorInfo = Configuration.getCombinedConfiguration().getBooleanProperty("DemoClient.view.show.extended.error.info", true);
        String redFontStart = "<font color=\"red\">";
        String redFontEnd = "</font>";
        if (!showExtendedErrorInfo) {
            redFontStart = "";
            redFontEnd = "";
        }
        String dbname = "db=" + csi._dbname;
        String spid = "spid=" + csi._spid;
        String username = "user=" + csi._username;
        String susername = "login=" + csi._susername;
        String tranState = "TranState=" + csi.getTranStateStr();
        String tranCount = "TranCount=" + csi._tranCount;
        String tranChained = "TranChained=" + csi._tranChained;
        String lockCount = "LockCount=" + csi._lockCount;
        if (csi._tranCount > 0) {
            tranCount = "TranCount=<b>" + redFontStart + csi._tranCount + redFontEnd + "</b>";
        }
        if (csi.isNonNormalTranState()) {
            tranState = "TranState=<b>" + redFontStart + csi.getTranStateStr() + redFontEnd + "</b>";
        }
        if (csi._tranCount > 0) {
            tranChained = "TranChained=<b>" + redFontStart + csi._tranChained + redFontEnd + "</b>";
        }
        if (csi._lockCount > 0) {
            lockCount = "LockCount=<b>" + redFontStart + csi._lockCount + redFontEnd + "</b>";
        }
        String text = basicText = dbname + ", " + spid + ", " + username + ", " + susername;
        if (csi._tranCount > 0 || csi.isNonNormalTranState()) {
            text = "<html>" + (csi._tranChained == 0 ? "" : "<font color=\"#B45F04\">CHAINED mode</font>, ") + dbname + ", " + spid + ", " + username + ", " + susername + ", ";
            if (showExtendedErrorInfo) {
                text = text + (csi.isTranStateUsed() ? tranState + ", " : "") + tranCount + ", " + tranChained + ", ";
            }
            text = text + lockCount + "</html>";
        }
        if (csi._tranChained == 1 && csi._lockCount == 0) {
            text = "<html><font color=\"#B45F04\">CHAINED mode</font>, " + basicText + "</html>";
        }
        this._aseConnStateInfo.setVisible(true);
        this._aseConnStateInfo.setText(text);
        String lockText = "<hr>";
        if (csi._lockCount > 0) {
            lockText = "<hr>Locks held by this SPID:" + csi.getLockListTableAsHtmlTable() + "<hr>";
        }
        String tooltip = "<html><table border=0 cellspacing=0 cellpadding=1><tr> <td>Current DB:    </td> <td><b>" + csi._dbname + "</b> </td> </tr><tr> <td>SPID:          </td> <td><b>" + csi._spid + "</b> </td> </tr><tr> <td>Current User:  </td> <td><b>" + csi._username + "</b> </td> </tr><tr> <td>Current Login: </td> <td><b>" + csi._susername + "</b> </td> </tr>" + (csi.isTranStateUsed() ? "<tr> <td>Tran State:    </td> <td><b>" + csi.getTranStateStr() + "</b> </td> </tr>" : "") + "<tr> <td>Tran Count:    </td> <td><b>" + csi._tranCount + "</b> </td> </tr><tr> <td>Tran Chained:  </td> <td><b>" + csi._tranChained + "</b> </td> </tr><tr> <td>Lock Count:    </td> <td><b>" + csi._lockCount + "</b> </td> </tr></table>" + lockText + (csi.isTranStateUsed() ? ASE_STATE_INFO_TOOLTIP_BASE : ASE_STATE_INFO_TOOLTIP_BASE_NO_TRANSTATE).replace("<html>", "");
        this._aseConnStateInfo.setToolTipText(tooltip);
    }

    public void setJdbcConnectionStateInfo(DbUtils.JdbcConnectionStateInfo csi) {
        if (csi == null) {
            this._aseConnStateInfo.setVisible(false);
            return;
        }
        boolean showExtendedErrorInfo = Configuration.getCombinedConfiguration().getBooleanProperty("DemoClient.view.show.extended.error.info", true);
        String redFontStart = "<font color=\"red\">";
        String redFontEnd = "</font>";
        if (!showExtendedErrorInfo) {
            redFontStart = "";
            redFontEnd = "";
        }
        String catalog = "cat=" + csi._catalog;
        String isolation = "Isolation=" + csi.getIsolationLevelStr();
        String autocommit = "AutoCommit=" + csi.getAutoCommit();
        if (!csi.getAutoCommit()) {
            autocommit = "AutoCommit=<b>" + redFontStart + csi.getAutoCommit() + redFontEnd + "</b>";
        }
        String text = "ac=" + csi.getAutoCommit();
        if (!csi.getAutoCommit()) {
            text = "<html>" + autocommit + ", " + catalog + ", " + isolation + "</html>";
        }
        this._aseConnStateInfo.setVisible(true);
        this._aseConnStateInfo.setText(text);
        String tooltip = "<html><table border=0 cellspacing=0 cellpadding=1><tr> <td>Current Catalog: </td> <td><b>" + csi.getCatalog() + "</b> </td> </tr><tr> <td>AutoCommit:      </td> <td><b>" + csi.getAutoCommit() + "</b> </td> </tr><tr> <td>Isolation Level: </td> <td><b>" + csi.getIsolationLevelStr() + "</b> </td> </tr></table><hr>" + JDBC_STATE_INFO_TOOLTIP_BASE.replace("<html>", "");
        this._aseConnStateInfo.setToolTipText(tooltip);
    }

    public static class ServerInfo {
        public String _srvName;
        public String _productName;
        public String _productVersion;
        public String _serverName;
        public String _username;
        public String _withUrl;
        public String _sysListeners;
        public String _charset;
        public String _sortorder;
        public String _clientCharsetId;
        public String _clientCharsetName;
        public String _clientCharsetDesc;

        public ServerInfo(String srvName, String productName, String productVersion, String serverName, String username, String withUrl, String sysListeners, String srvCharset, String srvSortorder, String clientCharsetId, String clientCharsetName, String clientCharsetDesc) {
            this._srvName = srvName;
            this._productName = productName;
            this._productVersion = productVersion;
            this._serverName = serverName;
            this._username = username;
            this._withUrl = withUrl;
            this._sysListeners = sysListeners;
            this._charset = srvCharset;
            this._sortorder = srvSortorder;
            this._clientCharsetId = clientCharsetId;
            this._clientCharsetName = clientCharsetName;
            this._clientCharsetDesc = clientCharsetDesc;
        }

        public String getSrvName() {
            return this._srvName != null ? this._srvName : NOT_CONNECTED;
        }

        public String getProductName() {
            return this._productName != null ? this._productName : "";
        }

        public String getProductVersion() {
            return this._productVersion != null ? this._productVersion : "";
        }

        public String getServerName() {
            return this._serverName != null ? this._serverName : "";
        }

        public String getUsername() {
            return this._username != null ? this._username : "";
        }

        public String getWithUrl() {
            return this._withUrl != null ? this._withUrl : "";
        }

        public String getSysListeners() {
            return this._sysListeners != null ? this._sysListeners : "";
        }

        public String getCharset() {
            return this._charset != null ? this._charset : "";
        }

        public String getSortorder() {
            return this._sortorder != null ? this._sortorder : "";
        }

        public String getClientCharsetId() {
            return this._clientCharsetId != null ? this._clientCharsetId : "";
        }

        public String getClientCharsetName() {
            return this._clientCharsetName != null ? this._clientCharsetName : "";
        }

        public String getClientCharsetDesc() {
            return this._clientCharsetDesc != null ? this._clientCharsetDesc : "";
        }

        public String getProductNameShort() {
            String productName = this.getProductName();
            String productNameShort = "";
            productNameShort = productName.equals("") ? "" : (DbUtils.isProductName(productName, "Adaptive Server Enterprise") ? "ASE" : (DbUtils.isProductName(productName, "SQL Anywhere") ? "ASA" : (DbUtils.isProductName(productName, "Sybase IQ") ? "IQ" : (DbUtils.isProductName(productName, "Replication Server") ? "RS" : (DbUtils.isProductName(productName, "HDB") ? "HANA" : (DbUtils.isProductName(productName, "SAP DB") ? "MaxDB" : (DbUtils.isProductName(productName, "H2") ? "H2" : (DbUtils.isProductName(productName, "Oracle") ? "ORA" : (DbUtils.isProductName(productName, "Microsoft SQL Server") ? "MS-SQL" : (DbUtils.isProductName(productName, "DB2/Linux") ? "DB2" : (DbUtils.isProductName(productName, "DB2") ? "DB2-MF" : (DbUtils.isProductName(productName, "MySQL") ? "MySQL" : (DbUtils.isProductName(productName, "Apache Derby") ? "DERBY" : "UNKNOWN")))))))))))));
            return productNameShort;
        }

        public void setSrvName(String srvName) {
            this._srvName = srvName;
        }

        public void setProductName(String productName) {
            this._productName = productName;
        }

        public void setProductVersion(String productVersion) {
            this._productVersion = productVersion;
        }

        public void setServerName(String serverName) {
            this._serverName = serverName;
        }

        public void setUsername(String username) {
            this._username = username;
        }

        public void setWithUrl(String withUrl) {
            this._withUrl = withUrl;
        }

        public void setSysListeners(String sysListeners) {
            this._sysListeners = sysListeners;
        }

        public void setCharset(String charset) {
            this._charset = charset;
        }

        public void setSortorder(String sortorder) {
            this._sortorder = sortorder;
        }

        public void setClientCharsetId(String clientCharsetId) {
            this._clientCharsetId = clientCharsetId;
        }

        public void setClientCharsetName(String clientCharsetName) {
            this._clientCharsetName = clientCharsetName;
        }

        public void setClientCharsetDesc(String clientCharsetDesc) {
            this._clientCharsetDesc = clientCharsetDesc;
        }
    }
}

