/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.ui;

import com.sybase.jdbcx.SybConnection;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;

public class WaitForExecDialog
extends JDialog
implements PropertyChangeListener,
ActionListener {
    private static Logger _logger = Logger.getLogger(WaitForExecDialog.class);
    private static final long serialVersionUID = 1L;
    private BgExecutor _execClass = null;
    private boolean _normalExit = false;
    private JLabel _label = new JLabel("Waiting...", 0);
    private JLabel _state_lbl = new JLabel();
    private JButton _cancel_but = new JButton("Cancel");
    private boolean _cancelWasPressed = false;
    private Connection _conn = null;

    public WaitForExecDialog(Window owner, Connection conn, String waitForLabel) {
        this(owner, null, waitForLabel, null);
    }

    public WaitForExecDialog(Window owner, String waitForLabel) {
        this(owner, null, waitForLabel, null);
    }

    public WaitForExecDialog(Window owner, String waitForLabel, String extraString) {
        this(owner, null, waitForLabel, null);
    }

    public WaitForExecDialog(Window owner, Connection conn, String waitForLabel, String extraString) {
        super((Frame)null, "Waiting...", true);
        this.setLayout((LayoutManager)new MigLayout());
        if (waitForLabel != null) {
            this._label.setText(waitForLabel);
        }
        this._label.setFont(new Font("Dialog", 1, 16));
        this._cancel_but.setToolTipText("CANCEL current operation.");
        this._conn = conn;
        this.add((Component)this._label, "push, grow, wrap");
        this.add((Component)this._state_lbl, "wrap");
        this.add((Component)this._cancel_but, "center, hidemode 3");
        this._cancel_but.addActionListener(this);
        this.pack();
        this.setSize(this.getSize().width + 50, this.getSize().height + 35);
        this.setLocationRelativeTo(owner);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (WaitForExecDialog.this._execClass != null) {
                    WaitForExecDialog.this._execClass.windowClosing(WaitForExecDialog.this._normalExit, e);
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this._cancel_but.equals(source)) {
            this._cancelWasPressed = true;
            if (this._execClass != null) {
                this._execClass.cancel_private();
            }
        }
    }

    public void markExtraText(String str) {
    }

    public boolean wasCanceled() {
        return this._cancelWasPressed || !this._normalExit;
    }

    public boolean wasCancelPressed() {
        return this._cancelWasPressed;
    }

    public boolean isNormalExit() {
        return this._normalExit;
    }

    public String getState() {
        return this._state_lbl.getText();
    }

    public void setState(String string) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("WaitForExecDialog.setState('" + string + "');"));
        }
        this._state_lbl.setText(string);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("WaitForExecDialog.propertyChange(): propName=" + event.getPropertyName() + ", newVal=" + event.getNewValue() + ", oldVal=" + event.getOldValue() + ", PropagationId=" + event.getPropagationId() + ", getSource=" + event.getSource()));
        }
        if ("state".equals(event.getPropertyName()) && SwingWorker.StateValue.DONE == event.getNewValue()) {
            this._normalExit = true;
            this.setVisible(false);
            this.dispose();
        }
    }

    public Object execAndWait(BgExecutor execClass) {
        return this.execAndWait(execClass, 0);
    }

    public Object execAndWait(BgExecutor execClass, int graceTime) {
        this._execClass = execClass;
        SwingWorker<Object, Object> doBgThread = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                try {
                    WaitForExecDialog.this._execClass.setBgThread(Thread.currentThread());
                    Object retObject = WaitForExecDialog.this._execClass.doWork();
                    if (WaitForExecDialog.this._execClass.hasException()) {
                        _logger.info((Object)"WaitForExecDialog:(at try block) has problems when doing it's work.", WaitForExecDialog.this._execClass.getException());
                    }
                    return retObject;
                }
                catch (Throwable t) {
                    _logger.info((Object)"WaitForExecDialog:(at catch block) has problems when doing it's work.", t);
                    return null;
                }
            }
        };
        doBgThread.addPropertyChangeListener(this);
        doBgThread.execute();
        boolean canDoCancel = this._execClass.canDoCancel();
        if (this._conn != null && this._conn instanceof SybConnection) {
            canDoCancel = true;
        }
        this._cancel_but.setVisible(canDoCancel);
        if (graceTime > 0) {
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < (long)graceTime && !doBgThread.isDone()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                    break;
                }
            }
        }
        if (!doBgThread.isDone()) {
            this.setVisible(true);
        }
        try {
            return doBgThread.get();
        }
        catch (InterruptedException e) {
            _logger.warn((Object)("execAndWait Caught: " + e), (Throwable)e);
            return null;
        }
        catch (ExecutionException e) {
            _logger.warn((Object)("execAndWait Caught: " + e), (Throwable)e);
            return null;
        }
    }

    public static abstract class BgExecutor {
        private Thread _bgThread = null;
        private WaitForExecDialog _waitDialog = null;
        private Throwable _throwable = null;

        public BgExecutor(WaitForExecDialog waitDialog) {
            this._waitDialog = waitDialog;
            if (this._waitDialog == null) {
                throw new RuntimeException("The waitDialog can't be null");
            }
        }

        public abstract Object doWork();

        public WaitForExecDialog getWaitDialog() {
            return this._waitDialog;
        }

        public boolean hasException() {
            return this._throwable != null;
        }

        public Throwable getException() {
            return this._throwable;
        }

        public void setException(Throwable t) {
            this._throwable = t;
        }

        public boolean canDoCancel() {
            return false;
        }

        public void setBgThread(Thread thread) {
            this._bgThread = thread;
        }

        public Thread getBgThread() {
            return this._bgThread;
        }

        private void cancel_private() {
            this.cancel();
            Connection conn = this.getWaitDialog()._conn;
            if (conn != null && conn instanceof SybConnection) {
                try {
                    ((SybConnection)conn).cancel();
                }
                catch (SQLException e) {
                    _logger.warn((Object)"cancel_private(): Problems doing cancel on SybConnection", (Throwable)e);
                }
            }
            if (this.getBgThread() != null) {
                this.getBgThread().interrupt();
            }
        }

        public void cancel() {
        }

        public void windowClosing(boolean normalExit, WindowEvent e) {
            if (!normalExit) {
                this.cancel_private();
            }
        }
    }
}

