/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.ui.focusabletip;

import com.sap.dbmtk.demo.ui.focusabletip.FocusableTip;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class FocusableTipExtention
implements MouseListener,
FocusListener {
    private static Logger _logger = Logger.getLogger(FocusableTipExtention.class);
    private JComponent _owner;
    private String _tooltip;
    private FocusableTip _focusableTip = null;
    private MouseEvent _mouseEnterEvent = null;
    private int _initialDelay = ToolTipManager.sharedInstance().getInitialDelay() - 50;
    private Timer _openTimer = new Timer(this._initialDelay, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            _logger.debug((Object)"OpenTimer::::ACTION");
            FocusableTipExtention.this._openTimer.stop();
            String text = FocusableTipExtention.this._owner.getToolTipText(FocusableTipExtention.this._mouseEnterEvent);
            if (text != null) {
                FocusableTipExtention.this._tooltip = text;
                FocusableTipExtention.this._owner.setToolTipText(null);
            }
            if ((text = FocusableTipExtention.this._tooltip) != null) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("OpenTimer::::ACTION.toolTipRequested(): owner=" + FocusableTipExtention.this._owner));
                }
                FocusableTipExtention.this._focusableTip.toolTipRequested(FocusableTipExtention.this._mouseEnterEvent, text);
            } else {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("OpenTimer::::ACTION.possiblyDisposeOfTipWindow(): owner=" + FocusableTipExtention.this._owner));
                }
                FocusableTipExtention.this._focusableTip.possiblyDisposeOfTipWindow();
            }
        }
    });

    public static void install(JComponent comp) {
        new FocusableTipExtention(comp);
    }

    public FocusableTipExtention(JComponent owner) {
        this._owner = owner;
        this._focusableTip = new FocusableTip(owner);
        this._tooltip = owner.getToolTipText();
        owner.setToolTipText(null);
        if (owner instanceof JComboBox) {
            for (int i = 0; i < owner.getComponentCount(); ++i) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("addMouseListener() to[" + i + "]: " + owner.getComponent(i)));
                }
                owner.getComponent(i).addMouseListener(this);
            }
        } else {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("addMouseListener(): " + owner));
            }
            owner.addMouseListener(this);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("mouseEntered() e=" + e));
        }
        this._openTimer.start();
        this._mouseEnterEvent = e;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("mouseExited() e=" + e));
        }
        this._openTimer.stop();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("mousePressed() e=" + e));
        }
        this._openTimer.stop();
        this._focusableTip.possiblyDisposeOfTipWindow();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("mouseReleased() e=" + e));
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("focusLost() e=" + e));
        }
        this._openTimer.stop();
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("focusGained() e=" + e));
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JFrame demo = new JFrame();
        demo.setDefaultCloseOperation(3);
        JPanel panel = new JPanel();
        JButton b1 = new JButton("I'm normal Tooltip");
        b1.setToolTipText("This button has a normal toolTip");
        panel.add(b1);
        JButton b2 = new JButton("I'm special Tooltip");
        b2.setToolTipText("Button 2 tooltip");
        FocusableTipExtention.install(b2);
        panel.add(b2);
        String[] cont = new String[]{"entry 1", "entry 2", "entry 3"};
        JComboBox<String> cbx1 = new JComboBox<String>(cont);
        cbx1.setToolTipText("Combobox 1 tooltip");
        panel.add(cbx1);
        FocusableTipExtention.install(cbx1);
        JComboBox<String> cbx2 = new JComboBox<String>(cont);
        cbx2.addItem("String 1");
        cbx2.addItem("String 2");
        cbx2.addItem("String 3");
        cbx2.addItem("String 4");
        cbx2.setEditable(true);
        cbx2.setToolTipText("Combobox 2 tooltip");
        panel.add(cbx2);
        FocusableTipExtention.install(cbx2);
        demo.add(panel);
        demo.pack();
        demo.setVisible(true);
    }
}

