/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.ui.focusabletip;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;

class TipUtil {
    private TipUtil() {
    }

    public static Rectangle getScreenBoundsForPoint(int x, int y) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = env.getScreenDevices();
        for (int i = 0; i < devices.length; ++i) {
            GraphicsConfiguration[] configs = devices[i].getConfigurations();
            for (int j = 0; j < configs.length; ++j) {
                Rectangle gcBounds = configs[j].getBounds();
                if (!gcBounds.contains(x, y)) continue;
                return gcBounds;
            }
        }
        return env.getMaximumWindowBounds();
    }

    public static Color getToolTipBackground() {
        Color c = UIManager.getColor("ToolTip.background");
        if ((c == null || UIManager.getLookAndFeel().getName().equals("Nimbus")) && (c = UIManager.getColor("info")) == null) {
            c = SystemColor.info;
        }
        if (c instanceof ColorUIResource) {
            c = new Color(c.getRGB());
        }
        return c;
    }

    public static void tweakTipEditorPane(JEditorPane textArea) {
        Document doc;
        if (UIManager.getLookAndFeel().getName().equals("Nimbus")) {
            Color selBG = textArea.getSelectionColor();
            Color selFG = textArea.getSelectedTextColor();
            textArea.setUI(new BasicEditorPaneUI());
            textArea.setSelectedTextColor(selFG);
            textArea.setSelectionColor(selBG);
        }
        textArea.setEditable(false);
        textArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        textArea.getCaret().setSelectionVisible(true);
        textArea.setBackground(TipUtil.getToolTipBackground());
        Font font = UIManager.getFont("Label.font");
        if (font == null) {
            font = new Font("SansSerif", 0, 12);
        }
        if ((doc = textArea.getDocument()) instanceof HTMLDocument) {
            HTMLDocument htmlDoc = (HTMLDocument)textArea.getDocument();
            htmlDoc.getStyleSheet().addRule("body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }");
        }
    }
}

