/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.utils;

import com.sap.dbmtk.demo.Version;
import com.sap.dbmtk.demo.utils.StringUtil;
import com.sap.dbmtk.demo.utils.SwingUtils;
import com.sap.dbmtk.demo.utils.Ver;
import com.sybase.jdbc4.jdbc.SybSQLWarning;
import com.sybase.jdbcx.EedInfo;
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybMessageHandler;
import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AseConnectionUtils {
    public static final int CONFIG_TYPE_IF_CHANGED = 1;
    public static final int CONFIG_TYPE_IF_CFG_LT = 2;
    public static final int CONFIG_TYPE_IF_CFG_GT = 3;
    public static final int CE_SYSTEM_VIEW_UNKNOWN = 0;
    public static final int CE_SYSTEM_VIEW_CLUSTER = 1;
    public static final int CE_SYSTEM_VIEW_INSTANCE = 2;
    private static Logger _logger = Logger.getLogger(AseConnectionUtils.class);
    private static String SQL_VERSION = "select @@version";
    public static final String SA_ROLE = "sa_role";
    public static final String SSO_ROLE = "sso_role";
    public static final String OPER_ROLE = "oper_role";
    public static final String SYBASE_TS_ROLE = "sybase_ts_role";
    public static final String NAVIGATOR_ROLE = "navigator_role";
    public static final String REPLICATION_ROLE = "replication_role";
    public static final String DTM_TM_ROLE = "dtm_tm_role";
    public static final String HA_ROLE = "ha_role";
    public static final String MON_ROLE = "mon_role";
    public static final String JS_ADMIN_ROLE = "js_admin_role";
    public static final String MESSAGING_ROLE = "messaging_role";
    public static final String JS_CLIENT_ROLE = "js_client_role";
    public static final String JS_USER_ROLE = "js_user_role";
    public static final String WEBSERVICES_ROLE = "webservices_role";
    public static final String KEYCUSTODIAN_ROLE = "keycustodian_role";
    private static Map<String, List<Integer>> _connHasTraceFlagEnabled = new HashMap<String, List<Integer>>();

    public static String getDbname(Connection conn) {
        return AseConnectionUtils.getCurrentDbname(conn);
    }

    public static String getCurrentDbname(Connection conn) {
        if (!AseConnectionUtils.isConnectionOk(conn, false, null)) {
            return null;
        }
        try {
            Statement stmnt = conn.createStatement();
            ResultSet rs = stmnt.executeQuery("select db_name()");
            String cwdb = "";
            while (rs.next()) {
                cwdb = rs.getString(1);
            }
            return cwdb;
        }
        catch (SQLException e) {
            _logger.warn((Object)("Problems getting current Working Database. Error Number: " + e.getErrorCode() + ", Message: " + e.getMessage()));
            return null;
        }
    }

    public static boolean useDbname(Connection conn, String dbname) {
        if (!AseConnectionUtils.isConnectionOk(conn, false, null)) {
            return false;
        }
        if (dbname == null || dbname.equals("")) {
            return false;
        }
        String dbNameBeforeChange = AseConnectionUtils.getCurrentDbname(conn);
        if (dbNameBeforeChange.equalsIgnoreCase(dbname)) {
            _logger.debug((Object)("No need to change database to '" + dbNameBeforeChange + "', you are already in it."));
            return true;
        }
        String cmd = "use " + dbname;
        Statement stmnt = null;
        try {
            stmnt = conn.createStatement();
            stmnt.executeUpdate(cmd);
            if (AseConnectionUtils.hasSqlWarnings(stmnt.getWarnings())) {
                _logger.info((Object)("Received following warnings when changing database to '" + dbname + "', continuing... " + AseConnectionUtils.sqlWarningToString(stmnt.getWarnings())));
            }
            stmnt.close();
        }
        catch (SQLException sqle) {
            for (SQLException e = sqle; e != null; e = e.getNextException()) {
                int aseError = e.getErrorCode();
                switch (aseError) {
                    case 918: 
                    case 919: 
                    case 921: 
                    case 922: 
                    case 924: 
                    case 926: 
                    case 927: 
                    case 928: 
                    case 930: 
                    case 931: 
                    case 932: 
                    case 937: 
                    case 938: 
                    case 942: 
                    case 943: 
                    case 947: 
                    case 948: 
                    case 949: 
                    case 950: 
                    case 951: 
                    case 952: 
                    case 959: 
                    case 961: 
                    case 962: 
                    case 963: 
                    case 968: 
                    case 3471: {
                        String aseMsg = e.getMessage() == null ? "-unknown-" : e.getMessage().replaceAll("\n", "");
                        String msg = "It looks like the database '" + dbname + "' is in 'load database', 'recovery mode' or 'offline', still in the database '" + dbNameBeforeChange + "', please try again later. AseMsgNumber=" + aseError + ", AseMsg=" + aseMsg;
                        _logger.warn((Object)msg);
                        return false;
                    }
                }
            }
            String msg = "Problems when executing '" + cmd + "' in '" + dbNameBeforeChange + "'.";
            _logger.error((Object)(msg + AseConnectionUtils.sqlExceptionToString(sqle)));
            return false;
        }
        String dbNameAfterChange = AseConnectionUtils.getCurrentDbname(conn);
        if (!dbname.equalsIgnoreCase(dbNameAfterChange)) {
            return false;
        }
        _logger.debug((Object)("Changed database from '" + dbNameBeforeChange + "' to '" + dbNameAfterChange + "'."));
        return true;
    }

    public static Timestamp getAseGetdate(Connection conn) {
        Timestamp aseGetdate = null;
        Statement stmnt = null;
        ResultSet rs = null;
        String sql = "select timenow=getdate()";
        if (!AseConnectionUtils.isConnectionOk(conn, false, null)) {
            return null;
        }
        try {
            stmnt = conn.createStatement();
            rs = stmnt.executeQuery(sql);
            while (rs.next()) {
                aseGetdate = rs.getTimestamp(1);
            }
            rs.close();
            stmnt.close();
        }
        catch (SQLException sqle) {
            aseGetdate = null;
            String msg = "Problems when executing '" + sql + "' in ASE Server.";
            _logger.error((Object)(msg + AseConnectionUtils.sqlExceptionToString(sqle)));
        }
        _logger.debug((Object)("getAseGetdate(): getdate()='" + aseGetdate + "'."));
        return aseGetdate;
    }

    public static Calendar getObjectCreationCalendar(Connection conn, String dbname, String objectName) {
        return AseConnectionUtils.getObjectCreationCalendar(conn, dbname, objectName, null);
    }

    public static Calendar getObjectCreationCalendar(Connection conn, String dbname, String objectName, String type) {
        Timestamp ts = AseConnectionUtils.getObjectCreationTimestamp(conn, dbname, objectName, type);
        if (ts == null) {
            return null;
        }
        GregorianCalendar crDate = new GregorianCalendar();
        crDate.setTimeInMillis(ts.getTime());
        return crDate;
    }

    public static Date getObjectCreationDate(Connection conn, String dbname, String objectName) {
        return AseConnectionUtils.getObjectCreationDate(conn, dbname, objectName, null);
    }

    public static Date getObjectCreationDate(Connection conn, String dbname, String objectName, String type) {
        Timestamp ts = AseConnectionUtils.getObjectCreationTimestamp(conn, dbname, objectName, type);
        if (ts == null) {
            return null;
        }
        return new Date(ts.getTime());
    }

    public static Timestamp getObjectCreationTimestamp(Connection conn, String dbname, String objectName) {
        return AseConnectionUtils.getObjectCreationTimestamp(conn, dbname, objectName, null);
    }

    public static Timestamp getObjectCreationTimestamp(Connection conn, String dbname, String objectName, String type) {
        Timestamp crDate = null;
        Statement stmnt = null;
        ResultSet rs = null;
        String sql = "select crdate from " + dbname + "..sysobjects where name = '" + objectName + "'";
        if (type != null) {
            sql = sql + "  and type = '" + type + "'";
        }
        if (!AseConnectionUtils.isConnectionOk(conn, false, null)) {
            return null;
        }
        try {
            stmnt = conn.createStatement();
            rs = stmnt.executeQuery(sql);
            while (rs.next()) {
                crDate = rs.getTimestamp(1);
            }
            rs.close();
            stmnt.close();
        }
        catch (SQLException sqle) {
            crDate = null;
            String msg = "Problems when executing '" + sql + "' in ASE Server.";
            _logger.error((Object)(msg + AseConnectionUtils.sqlExceptionToString(sqle)));
        }
        _logger.debug((Object)("getObjectCreationDate(): objectName='" + objectName + "', created='" + crDate + "'."));
        return crDate;
    }

    public static SQLWarning sqlExceptionToWarning(SQLException sqle) {
        if (sqle instanceof EedInfo) {
            EedInfo eed = (EedInfo)sqle;
            return new SybSQLWarning(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), eed.getState(), eed.getSeverity(), eed.getServerName(), eed.getProcedureName(), eed.getLineNumber(), eed.getEedParams(), eed.getTranState(), eed.getStatus());
        }
        return new SQLWarning(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode());
    }

    public static boolean isInLoadDbException(SQLException sqle) {
        int code = sqle.getErrorCode();
        switch (code) {
            case 918: 
            case 921: 
            case 922: 
            case 930: 
            case 937: 
            case 938: 
            case 950: 
            case 2206: 
            case 3118: 
            case 7408: 
            case 12537: 
            case 18174: {
                return true;
            }
        }
        return false;
    }

    public static String sqlExceptionToString(SQLException sqle) {
        StringBuffer sb = new StringBuffer();
        while (sqle != null) {
            if (sqle instanceof EedInfo) {
                EedInfo sybsqle = (EedInfo)sqle;
                sb.append(" (Srv=");
                sb.append(sybsqle.getServerName());
                sb.append(", Error=");
                sb.append(sqle.getErrorCode());
                sb.append(", Severity=");
                sb.append(sybsqle.getSeverity());
                sb.append(", Proc=");
                sb.append(sybsqle.getProcedureName());
                sb.append(", Line=");
                sb.append(sybsqle.getLineNumber());
                sb.append(", Text=");
                sb.append(sqle.getMessage());
                sb.append(")");
            } else {
                sb.append(" (Error=");
                sb.append(sqle.getErrorCode());
                sb.append(", Text=");
                sb.append(sqle.getMessage());
                sb.append(")");
            }
            sqle = sqle.getNextException();
        }
        return sb.toString();
    }

    public static boolean hasSqlWarnings(SQLWarning sqlw) {
        return sqlw != null;
    }

    public static String sqlWarningToString(SQLWarning sqlw) {
        StringBuffer sb = new StringBuffer();
        while (sqlw != null) {
            if (sqlw instanceof EedInfo) {
                EedInfo sybsqlw = (EedInfo)sqlw;
                sb.append(" (Srv=");
                sb.append(sybsqlw.getServerName());
                sb.append(", Error=");
                sb.append(sqlw.getErrorCode());
                sb.append(", Severity=");
                sb.append(sybsqlw.getSeverity());
                sb.append(", Proc=");
                sb.append(sybsqlw.getProcedureName());
                sb.append(", Line=");
                sb.append(sybsqlw.getLineNumber());
                sb.append(", Text=");
                sb.append(sqlw.getMessage());
                sb.append(")");
            } else {
                sb.append(" (Error=");
                sb.append(sqlw.getErrorCode());
                sb.append(", Text=");
                sb.append(sqlw.getMessage());
                sb.append(")");
            }
            sqlw = sqlw.getNextWarning();
        }
        return sb.toString();
    }

    public static void checkSqlWarningsAndThrowSqlExceptionIfSeverityIsAbove10(SQLWarning sqlw) throws SQLException {
        while (sqlw != null) {
            EedInfo eed;
            if (sqlw instanceof EedInfo && (eed = (EedInfo)sqlw).getSeverity() > 10) {
                throw sqlw;
            }
            sqlw = sqlw.getNextWarning();
        }
    }

    public static String getSqlWarningMsgs(SQLException sqe) {
        if (sqe == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (sqe != null) {
            if (sqe instanceof EedInfo) {
                EedInfo eedi = (EedInfo)sqe;
                if (eedi.getSeverity() > 10) {
                    boolean firstOnLine = true;
                    sb.append("Msg " + sqe.getErrorCode() + ", Level " + eedi.getSeverity() + ", State " + eedi.getState() + ":\n");
                    if (eedi.getServerName() != null) {
                        sb.append("Server '" + eedi.getServerName() + "'");
                        firstOnLine = false;
                    }
                    if (eedi.getProcedureName() != null) {
                        sb.append((firstOnLine ? "" : ", ") + "Procedure '" + eedi.getProcedureName() + "'");
                        firstOnLine = false;
                    }
                    sb.append((firstOnLine ? "" : ", ") + "Line " + eedi.getLineNumber() + ", Status " + eedi.getStatus() + ", TranState " + eedi.getTranState() + ":\n");
                }
                String msg = sqe.getMessage();
                sb.append(msg);
                if (msg != null && !msg.endsWith("\n")) {
                    sb.append("\n");
                }
            } else if (!sqe.getSQLState().equals("010P4")) {
                sb.append("Unexpected exception : SqlState: " + sqe.getSQLState() + " " + sqe.toString() + ", ErrorCode: " + sqe.getErrorCode() + "\n");
            }
            sqe = sqe.getNextException();
        }
        return sb.toString();
    }

    public static String getAseServername(Connection conn) {
        String UNKNOWN = "";
        if (!AseConnectionUtils.isConnectionOk(conn, true, null)) {
            return "";
        }
        try {
            String name = "";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select @@servername");
            while (rs.next()) {
                name = rs.getString(1);
                name = name == null ? "" : name.trim();
            }
            rs.close();
            stmt.close();
            return name;
        }
        catch (SQLException e) {
            _logger.debug((Object)"When getting @@servername, Caught exception.", (Throwable)e);
            return "";
        }
    }

    public static String getAseHostname(Connection conn, boolean stripDomainName) {
        String UNKNOWN = "UNKNOWN";
        if (!AseConnectionUtils.isConnectionOk(conn, true, null)) {
            return "UNKNOWN";
        }
        try {
            String hostname = "UNKNOWN";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select asehostname()");
            while (rs.next()) {
                String host = rs.getString(1).trim();
                if (stripDomainName && host.indexOf(".") > 0) {
                    hostname = host.substring(0, host.indexOf("."));
                    continue;
                }
                hostname = host;
            }
            rs.close();
            stmt.close();
            return hostname;
        }
        catch (SQLException e) {
            _logger.debug((Object)"When getting asehostname(), Caught exception.", (Throwable)e);
            return "UNKNOWN";
        }
    }

    public static int getAsePageSize(Connection conn) {
        int UNKNOWN = -1;
        if (!AseConnectionUtils.isConnectionOk(conn, true, null)) {
            return -1;
        }
        try {
            int pgsize = -1;
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select @@maxpagesize");
            while (rs.next()) {
                pgsize = rs.getInt(1);
            }
            rs.close();
            stmt.close();
            return pgsize;
        }
        catch (SQLException e) {
            _logger.debug((Object)"When getting @@maxpagesize, Caught exception.", (Throwable)e);
            return -1;
        }
    }

    public static int getAseSpid(Connection conn) {
        int UNKNOWN = -1;
        if (!AseConnectionUtils.isConnectionOk(conn, true, null)) {
            return -1;
        }
        try {
            int spid = -1;
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select @@spid");
            while (rs.next()) {
                spid = rs.getInt(1);
            }
            rs.close();
            stmt.close();
            return spid;
        }
        catch (SQLException e) {
            _logger.debug((Object)"When getting @@spid, Caught exception.", (Throwable)e);
            return -1;
        }
    }

    public static String getServerLogFileName(Connection conn) throws SQLException {
        String cmd = "select @@errorlog";
        String retStr = "";
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(cmd);
        while (rs.next()) {
            retStr = rs.getString(1);
        }
        rs.close();
        stmt.close();
        return retStr;
    }

    public static String getAseVersionStr(Connection conn) {
        String UNKNOWN = "";
        if (!AseConnectionUtils.isConnectionOk(conn, true, null)) {
            return "";
        }
        try {
            String verStr = "";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select @@version");
            while (rs.next()) {
                verStr = rs.getString(1);
            }
            rs.close();
            stmt.close();
            return verStr;
        }
        catch (SQLException e) {
            _logger.debug((Object)"When getting @@version, Caught exception.", (Throwable)e);
            return "";
        }
    }

    public static String getListeners(Connection conn, boolean addType, boolean stripDomainName, Component guiOwner) {
        if (!AseConnectionUtils.isConnectionOk(conn, true, guiOwner)) {
            return null;
        }
        try {
            String listenersStr = "";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select distinct * from master..syslisteners");
            while (rs.next()) {
                if (addType) {
                    listenersStr = listenersStr + rs.getString("net_type").trim() + ":";
                }
                String host = rs.getString("address_info").trim();
                if (stripDomainName && host != null && host.indexOf(".") > 0) {
                    String hostname = host.substring(0, host.indexOf("."));
                    String portnum = host.substring(host.lastIndexOf(" "));
                    try {
                        hostname = host.substring(0, host.indexOf(" ")).trim();
                        Integer.parseInt(hostname);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    listenersStr = listenersStr + hostname + portnum;
                } else {
                    listenersStr = listenersStr + host;
                }
                listenersStr = listenersStr + ", ";
            }
            listenersStr = StringUtil.removeLastComma(listenersStr);
            return listenersStr;
        }
        catch (SQLException e) {
            _logger.debug((Object)"When getting listeners, Caught exception.", (Throwable)e);
            if (guiOwner != null) {
                AseConnectionUtils.showSqlExceptionMessage(guiOwner, "Getting Listeners", "When getting listeners, we got an SQLException", e);
            }
            return null;
        }
    }

    public static String getAseCharset(Connection conn) {
        String UNKNOWN = "UNKNOWN";
        if (!AseConnectionUtils.isConnectionOk(conn, true, null)) {
            return "UNKNOWN";
        }
        try {
            String retStr = "UNKNOWN";
            String sql = "declare @charid tinyint \nselect @charid = value from master..syscurconfigs where config = 131 \nselect charset_name = name  from master..syscharsets   where id = @charid \n";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                retStr = rs.getString(1).trim();
            }
            rs.close();
            stmt.close();
            return retStr;
        }
        catch (SQLException e) {
            _logger.debug((Object)"When getting ASE charset, Caught exception.", (Throwable)e);
            return "UNKNOWN";
        }
    }

    public static String getAseSortorder(Connection conn) {
        String UNKNOWN = "UNKNOWN";
        if (!AseConnectionUtils.isConnectionOk(conn, true, null)) {
            return "UNKNOWN";
        }
        try {
            String retStr = "UNKNOWN";
            String sql = "declare @sortid tinyint, @charid tinyint \nselect @sortid = value from master..syscurconfigs where config = 123 \nselect @charid = value from master..syscurconfigs where config = 131 \nselect sortorder_name= name  from master..syscharsets   where id = @sortid and csid = @charid \n";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                retStr = rs.getString(1).trim();
            }
            rs.close();
            stmt.close();
            return retStr;
        }
        catch (SQLException e) {
            _logger.debug((Object)"When getting ASE sortorder, Caught exception.", (Throwable)e);
            return "UNKNOWN";
        }
    }

    public static String getClientCharsetId(Connection conn) {
        String UNKNOWN = "";
        if (!AseConnectionUtils.isConnectionOk(conn, true, null)) {
            return "";
        }
        try {
            String retStr = "";
            String sql = "select @@client_csid";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                retStr = rs.getString(1).trim();
            }
            rs.close();
            stmt.close();
            return retStr;
        }
        catch (SQLException e) {
            _logger.debug((Object)"When getting Client charset id, Caught exception.", (Throwable)e);
            return "";
        }
    }

    public static String getClientCharsetName(Connection conn) {
        String UNKNOWN = "";
        if (!AseConnectionUtils.isConnectionOk(conn, true, null)) {
            return "";
        }
        try {
            String retStr = "";
            String sql = "select name from master.dbo.syscharsets where id = @@client_csid";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                retStr = rs.getString(1).trim();
            }
            rs.close();
            stmt.close();
            return retStr;
        }
        catch (SQLException e) {
            _logger.debug((Object)"When getting Client charset id, Caught exception.", (Throwable)e);
            return "";
        }
    }

    public static String getClientCharsetDesc(Connection conn) {
        String UNKNOWN = "";
        if (!AseConnectionUtils.isConnectionOk(conn, true, null)) {
            return "";
        }
        try {
            String retStr = "";
            String sql = "select description from master.dbo.syscharsets where id = @@client_csid";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                retStr = rs.getString(1).trim();
            }
            rs.close();
            stmt.close();
            return retStr;
        }
        catch (SQLException e) {
            _logger.debug((Object)"When getting Client charset id, Caught exception.", (Throwable)e);
            return "";
        }
    }

    public static String getAsaCharset(Connection conn) {
        String UNKNOWN = "UNKNOWN";
        if (!AseConnectionUtils.isConnectionOk(conn, true, null)) {
            return "UNKNOWN";
        }
        try {
            String retStr = "UNKNOWN";
            String sql = "select * from syscollation";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                retStr = rs.getString(2).trim();
            }
            rs.close();
            stmt.close();
            return retStr;
        }
        catch (SQLException e) {
            _logger.debug((Object)"When getting ASE charset, Caught exception.", (Throwable)e);
            return "UNKNOWN";
        }
    }

    public static String getAsaSortorder(Connection conn) {
        String UNKNOWN = "UNKNOWN";
        if (!AseConnectionUtils.isConnectionOk(conn, true, null)) {
            return "UNKNOWN";
        }
        try {
            String retStr = "UNKNOWN";
            String sql = "select * from syscollation";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                retStr = rs.getString(3).trim();
            }
            rs.close();
            stmt.close();
            return retStr;
        }
        catch (SQLException e) {
            _logger.debug((Object)"When getting ASE charset, Caught exception.", (Throwable)e);
            return "UNKNOWN";
        }
    }

    public static boolean isConnectionOk(Connection conn) {
        return AseConnectionUtils.isConnectionOk(conn, false, null);
    }

    public static boolean isConnectionOk(Connection conn, boolean guiMsgOnError, Component guiOwner) {
        String msg = "";
        String title = "Checking DB Connection";
        if (conn == null) {
            msg = "The passed Connection object is null.";
            _logger.debug((Object)msg);
            if (guiOwner != null) {
                SwingUtils.showWarnMessage(guiOwner, title, msg, new Exception(msg));
            }
            return false;
        }
        try {
            if (conn.isClosed()) {
                msg = "The passed Connection object is NOT connected.";
                _logger.debug((Object)msg);
                if (guiOwner != null) {
                    SwingUtils.showWarnMessage(guiOwner, title, msg, new Exception(msg));
                }
                return false;
            }
        }
        catch (SQLException e) {
            _logger.debug((Object)"When checking the DB Connection, Caught exception.", (Throwable)e);
            if (guiOwner != null) {
                AseConnectionUtils.showSqlExceptionMessage(guiOwner, "Checking DB Connection", "When checking the DB Connection, we got an SQLException", e);
            }
            return false;
        }
        return true;
    }

    public static String showSqlExceptionMessage(Component owner, String title, String msg, SQLException sqlex) {
        String exMsg = AseConnectionUtils.getMessageFromSQLException(sqlex, true, "010HA");
        String exMsgRet = AseConnectionUtils.getMessageFromSQLException(sqlex, false, new String[0]);
        String extraInfo = "";
        if (AseConnectionUtils.containsSqlState(sqlex, "JZ00L")) {
            extraInfo = "<br><b>Are you sure about the password, SQL State 'JZ00L'</b><br>The first Exception 'JZ00L' in <b>most</b> cases means: wrong user or password<br>Before you begin searching for strange reasons, please try to login again and make sure you use the correct password.<br><br>Below is all Exceptions that happened during the login attempt.<br><HR NOSHADE>";
        }
        if (AseConnectionUtils.containsSqlState(sqlex, "JZ0IB")) {
            extraInfo = "<br><b>Try a Workaround for the problem, SQL State 'JZ0IB'</b><br><ul>  <li>In the Connection Dialog, in the field 'URL Option' specify: <font size=\"4\"><code>CHARSET=iso_1</code></font></li>  <li>Or simply choose '<font size=\"4\"><code>iso_1</code></font>' in the 'Client Charset' DropBox.</li></ul><i>This will hopefully get you going, but characters might not converted correctly</i><br><br>Below is all Exceptions that happened during the login attempt.<br><HR NOSHADE>";
        }
        String htmlStr = "<html>" + msg + "<br>" + extraInfo + exMsg + "</html>";
        SwingUtils.showErrorMessage(owner, title, htmlStr, sqlex);
        return exMsgRet;
    }

    public static String getMessageFromSQLException(SQLException sqlex, boolean htmlTags, String ... discardSqlState) {
        StringBuffer sb = new StringBuffer("");
        if (htmlTags) {
            sb.append("<UL>");
        }
        ArrayList<String> discardedMessages = null;
        boolean first = true;
        while (sqlex != null) {
            boolean discardThis = false;
            for (String sqlState : discardSqlState) {
                if (!sqlState.equals(sqlex.getSQLState())) continue;
                discardThis = true;
            }
            if (discardThis) {
                if (discardedMessages == null) {
                    discardedMessages = new ArrayList<String>();
                }
                discardedMessages.add(sqlex.getMessage());
            } else {
                if (first) {
                    first = false;
                } else {
                    sb.append("\n");
                }
                if (htmlTags) {
                    sb.append("<LI>");
                }
                sb.append(sqlex.getMessage());
                if (htmlTags) {
                    sb.append("</LI>");
                }
            }
            sqlex = sqlex.getNextException();
        }
        if (htmlTags) {
            sb.append("</UL>");
        }
        if (discardedMessages != null) {
            sb.append(htmlTags ? "<BR><BR><B>Note</B>:" : "\nNote: ");
            sb.append("The following messages was also found but, they are not as important as above messages.").append(htmlTags ? "<br>" : "\n");
            if (htmlTags) {
                sb.append("<HR NOSHADE>").append("<UL>");
            }
            for (String msg : discardedMessages) {
                if (htmlTags) {
                    sb.append("<LI>");
                }
                sb.append(msg);
                if (!htmlTags) continue;
                sb.append("</LI>");
            }
            if (htmlTags) {
                sb.append("</UL>");
            }
        }
        return sb.toString();
    }

    public static boolean containsSqlState(SQLException sqlex, String sqlstate) {
        while (sqlex != null) {
            if (sqlstate.equals(sqlex.getSQLState())) {
                return true;
            }
            sqlex = sqlex.getNextException();
        }
        return false;
    }

    public static int getAseVersionNumber(Connection conn) {
        int aseVersionNum = 0;
        try {
            String aseVersionStr = "";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(SQL_VERSION);
            while (rs.next()) {
                aseVersionStr = rs.getString(1);
            }
            rs.close();
            if (aseVersionNum == 0) {
                aseVersionNum = Ver.sybVersionStringToNumber(aseVersionStr);
            }
        }
        catch (SQLException ex) {
            _logger.error((Object)"MonTablesDictionary:getAseVersionNumber(), @@version", (Throwable)ex);
        }
        return aseVersionNum;
    }

    public static int getRsVersionNumber(Connection conn) {
        int srvVersionNum = 0;
        try {
            String aseVersionStr = "";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("admin version");
            while (rs.next()) {
                aseVersionStr = rs.getString(1);
            }
            rs.close();
            if (srvVersionNum == 0) {
                srvVersionNum = Ver.sybVersionStringToNumber(aseVersionStr);
            }
        }
        catch (SQLException ex) {
            _logger.error((Object)"AseConnectionUtils:getRsVersionNumber(), @@version", (Throwable)ex);
        }
        return srvVersionNum;
    }

    public static boolean isClusterEnabled(Connection conn) {
        String clusterMode = null;
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select @@clustermode");
            while (rs.next()) {
                clusterMode = rs.getString(1).trim();
            }
            rs.close();
        }
        catch (SQLException ex) {
            _logger.debug((Object)"MonTablesDictionary:isClusterEnabled(), @@clustermode, probably an early ASE version", (Throwable)ex);
        }
        _logger.debug((Object)("Ase @@clustermode = '" + clusterMode + "'."));
        if (clusterMode == null) {
            return false;
        }
        return clusterMode.equalsIgnoreCase("shared disk cluster");
    }

    public static void setClusterEditionSystemView(Connection conn, int type) {
        String sql = null;
        if (type == 1) {
            sql = "set system_view cluster";
        }
        if (type == 2) {
            sql = "set system_view instance";
        }
        if (sql == null) {
            String err = "The passed System View type='" + type + "', is unknown.";
            _logger.error((Object)err);
            return;
        }
        try {
            Statement stmt = conn.createStatement();
            stmt.execute(sql);
            stmt.close();
        }
        catch (SQLException ex) {
            String msg = AseConnectionUtils.showSqlExceptionMessage(null, Version.getAppName(), "Problems when setting 'system view' in ASE Server.", ex);
            _logger.error((Object)("Problems when setting 'system view' in ASE Server. " + msg));
        }
    }

    public static int getClusterEditionSystemView(Connection conn) {
        String ceSystemView = null;
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select @@system_view");
            while (rs.next()) {
                ceSystemView = rs.getString(1);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException ex) {
            String msg = AseConnectionUtils.showSqlExceptionMessage(null, Version.getAppName(), "Problems when getting 'system view' in ASE Server.", ex);
            _logger.error((Object)("Problems when getting 'system view' in ASE Server. " + msg));
        }
        if (ceSystemView == null) {
            return 0;
        }
        if ((ceSystemView = ceSystemView.trim()).equalsIgnoreCase("cluster")) {
            return 1;
        }
        if (ceSystemView.equalsIgnoreCase("instance")) {
            return 2;
        }
        return 0;
    }

    private static String checkAseConfig(Connection conn, String[] needsConfig, boolean firstTimeCheck, boolean hasSaRole) throws SQLException {
        boolean notConfigured = false;
        String errorMesage = "<HTML><h1>Sorry the ASE server is " + (firstTimeCheck ? "" : "STILL ") + "not properly configured for monitoring.</h1>";
        errorMesage = errorMesage + "<UL>";
        for (String cfgOption : needsConfig) {
            if (AseConnectionUtils.getAseConfigRunValue(conn, cfgOption) > 0) continue;
            _logger.warn((Object)("ASE Configuration option '" + cfgOption + "' is NOT enabled."));
            errorMesage = errorMesage + "<LI> ASE option '" + cfgOption + "' is NOT enabled.";
            notConfigured = true;
        }
        errorMesage = errorMesage + "</UL>";
        if (firstTimeCheck) {
            if (hasSaRole) {
                errorMesage = errorMesage + "<b>I will now open the configuration panel for you.</b><BR>";
                errorMesage = errorMesage + "<b>A new check will be done after that.</b><BR>";
                errorMesage = errorMesage + "<BR>";
                errorMesage = errorMesage + "<b>Recomendation:</b><BR>";
                errorMesage = errorMesage + "Use the 'pre defined' configuration 'drop down' at the bottom.<BR>";
            } else {
                errorMesage = errorMesage + "<b>You don't have 'sa_role'...</b><BR>";
                errorMesage = errorMesage + "<b>So there is no need to open the configuration panel.</b><BR>";
            }
        } else {
            errorMesage = errorMesage + "<b>It's STILL a problem, please FIX the configuration manually.</b><BR>";
            errorMesage = errorMesage + "<b>Then you can try to connect again.</b>";
        }
        errorMesage = errorMesage + "</HTML>";
        return notConfigured ? errorMesage : null;
    }

    public static void setBasicAseConfigForMonitoring(Connection conn) throws SQLException {
        AseConnectionUtils.checkAndSetAseConfig(conn, "enable monitoring", 1);
        AseConnectionUtils.checkAndSetAseConfig(conn, "max SQL text monitored", 2048, 2);
    }

    public static boolean checkAndSetAseConfig(Connection conn, String config, int val) {
        return AseConnectionUtils.checkAndSetAseConfig(conn, config, val, 1);
    }

    public static boolean checkAndSetAseConfig(Connection conn, String config, int val, int type) {
        try {
            int aseCfg = AseConnectionUtils.getAseConfigConfigValue(conn, config);
            boolean doConfig = false;
            if (type == 1) {
                if (aseCfg != val) {
                    doConfig = true;
                }
            } else if (type == 2) {
                if (aseCfg < val) {
                    doConfig = true;
                }
            } else if (type == 3) {
                if (aseCfg > val) {
                    doConfig = true;
                }
            } else {
                throw new RuntimeException("checkAndSetAseConfig, unknown type=" + type);
            }
            if (doConfig) {
                AseConnectionUtils.setAseConfigValue(conn, config, val);
                return true;
            }
            return false;
        }
        catch (SQLException sqle) {
            String errStr = "";
            while (sqle != null) {
                errStr = errStr + sqle.getMessage() + " ";
                sqle = sqle.getNextException();
            }
            return false;
        }
    }

    public static void setAseConfigValue(Connection conn, String config, boolean val) throws SQLException {
        AseConnectionUtils.setAseConfigValue(conn, config, val ? 1 : 0);
    }

    public static void setAseConfigValue(Connection conn, String config, int val) throws SQLException {
        AseConnectionUtils.setAseConfigValue(conn, config, Integer.toString(val));
    }

    public static void setAseConfigValue(Connection conn, String config, String val) throws SQLException {
        if (val == null) {
            return;
        }
        boolean isNumber = false;
        try {
            Integer.parseInt(val);
            isNumber = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!isNumber) {
            val = "'" + val.trim() + "'";
        }
        _logger.info((Object)("Setting ASE Configuration '" + config + "' to value '" + val + "'."));
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("sp_configure '" + config + "', " + val);
        while (rs.next()) {
        }
        rs.close();
        stmt.close();
    }

    public static int getAseConfigRunValue(Connection conn, String config) throws SQLException {
        int val = -1;
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("sp_configure '" + config + "'");
        while (rs.next()) {
            val = rs.getInt(5);
        }
        rs.close();
        stmt.close();
        return val;
    }

    public static String getAseConfigRunValueStr(Connection conn, String config) throws SQLException {
        String val = null;
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("sp_configure '" + config + "'");
        while (rs.next()) {
            val = rs.getString(5);
        }
        rs.close();
        stmt.close();
        if (val != null) {
            val = val.trim();
        }
        return val;
    }

    public static int getAseConfigRunValueNoEx(Connection conn, String config) {
        int val = -1;
        try {
            val = AseConnectionUtils.getAseConfigRunValue(conn, config);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return val;
    }

    public static boolean getAseConfigRunValueBooleanNoEx(Connection conn, String config) {
        int val = -1;
        try {
            val = AseConnectionUtils.getAseConfigRunValue(conn, config);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return val > 0;
    }

    public static String getAseConfigRunValueStrNoEx(Connection conn, String config) {
        String val = null;
        try {
            val = AseConnectionUtils.getAseConfigRunValueStr(conn, config);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return val;
    }

    public static int getAseConfigConfigValue(Connection conn, String config) throws SQLException {
        int val = -1;
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("sp_configure '" + config + "'");
        while (rs.next()) {
            val = rs.getInt(4);
        }
        rs.close();
        stmt.close();
        return val;
    }

    public static boolean isAseConfigStatic(Connection conn, String config) throws SQLException {
        String val = "";
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("sp_configure '" + config + "'");
        while (rs.next()) {
            val = rs.getString(7);
        }
        rs.close();
        stmt.close();
        return val.equals("static");
    }

    public static boolean setCompatibilityMode(Connection conn, boolean on) {
        String option = "compatibility_mode";
        return AseConnectionUtils.setAseOption(conn, option, on);
    }

    public static boolean getCompatibilityMode(Connection conn) {
        String option = "compatibility_mode";
        return AseConnectionUtils.getAseOption(conn, option);
    }

    public static boolean setAseOption(Connection conn, String option, boolean on) {
        String sql = "set " + option + (on ? " on" : " off");
        try {
            Statement stmnt = conn.createStatement();
            stmnt.executeUpdate(sql);
            stmnt.close();
            return true;
        }
        catch (SQLException e) {
            _logger.warn((Object)("Problems execute SQL '" + sql + "', Caught: " + e.toString()));
            return false;
        }
    }

    public static boolean getAseOption(Connection conn, String option) {
        String sql = "-- check if we are in 'compatibility_mode', introduced in 15.0.3 esd#1 \ndeclare @option int \nselect @option = 0  \n    \nselect @option = sign(convert(tinyint,substring(@@options, c.low, 1)) & c.high) \n  from master.dbo.spt_values a, master.dbo.spt_values c \n  where a.number = c.number \n    and c.type = 'P' \n    and a.type = 'N' \n    and c.low <= datalength(@@options) \n    and a.name = '" + option + "' \n    \n    select @option\n\n";
        try {
            int resultOption = 0;
            Statement stmnt = conn.createStatement();
            ResultSet rs = stmnt.executeQuery(sql);
            while (rs.next()) {
                resultOption = rs.getInt(1);
            }
            rs.close();
            stmnt.close();
            return resultOption > 0;
        }
        catch (SQLException e) {
            _logger.warn((Object)("Problems execute SQL '" + sql + "', Caught: " + e.toString()));
            return false;
        }
    }

    public static boolean hasRole(Connection conn, String role) {
        int val = -1;
        String sql = "select proc_role('" + role + "')";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                val = rs.getInt(1);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException ex) {
            _logger.warn((Object)("Problems when executing sql: " + sql), (Throwable)ex);
        }
        _logger.debug((Object)("hasRole(role='" + role + "'): SQL 'select proc_role(rolename)' returned=" + val + ", so rasRole() will return=" + (val > 0)));
        return val > 0;
    }

    public static List<String> getActiveSystemRoles(Connection conn) {
        String sql = "select show_role()";
        try {
            LinkedList<String> roleList = new LinkedList<String>();
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String val;
                if (roleList == null) {
                    roleList = new LinkedList();
                }
                if ((val = rs.getString(1)) == null) continue;
                String[] sa = val.split(" ");
                for (int i = 0; i < sa.length; ++i) {
                    String role = sa[i].trim();
                    if (roleList.contains(role)) continue;
                    roleList.add(role);
                }
            }
            rs.close();
            stmt.close();
            _logger.debug((Object)("getRoles(roleList='" + roleList + "'."));
            return roleList;
        }
        catch (SQLException ex) {
            _logger.warn((Object)("Problems when executing sql: " + sql), (Throwable)ex);
            return null;
        }
    }

    public static List<String> getActiveRoles(Connection conn) {
        String sql = "exec sp_activeroles 'expand_down'";
        try {
            LinkedList<String> roleList = new LinkedList<String>();
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String role = rs.getString(1);
                if (roleList.contains(role)) continue;
                roleList.add(role);
            }
            rs.close();
            stmt.close();
            _logger.debug((Object)("getActiveRoles(roleList='" + roleList + "'."));
            return roleList;
        }
        catch (SQLException ex) {
            _logger.warn((Object)("Problems when executing sql: " + sql), (Throwable)ex);
            return null;
        }
    }

    public static Map<String, Integer> getMonitorConfigs(Connection conn) {
        String sql = "exec sp_configure 'Monitoring'";
        try {
            LinkedHashMap<String, Integer> configMap = null;
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (configMap == null) {
                    configMap = new LinkedHashMap<String, Integer>();
                }
                String name = rs.getString(1);
                int runValue = rs.getInt(5);
                configMap.put(name, runValue);
            }
            rs.close();
            stmt.close();
            _logger.debug((Object)("getMonitorConfigs(configMap='" + configMap + "'."));
            return configMap;
        }
        catch (SQLException ex) {
            _logger.warn((Object)("Problems when executing sql: " + sql), (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getShowplan(Connection conn, int spid, String htmlStartStr, boolean addHtmlTags) {
        if (htmlStartStr == null) {
            htmlStartStr = "";
        }
        String htmlBegin = "";
        String htmlEnd = "";
        String htmlNewLine = "";
        if (addHtmlTags) {
            htmlBegin = "<html>" + htmlStartStr + "<pre>";
            htmlEnd = "</pre></html>";
        }
        StringBuilder sb = null;
        String sql = "exec sp_showplan " + spid + ", null, null, null";
        SybMessageHandler curMsgHandler = null;
        if (conn instanceof SybConnection) {
            curMsgHandler = ((SybConnection)conn).getSybMessageHandler();
            ((SybConnection)conn).setSybMessageHandler(null);
        }
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(sql);
            for (SQLWarning sqlw = stmt.getWarnings(); sqlw != null; sqlw = sqlw.getNextWarning()) {
                if (sqlw.getErrorCode() == 10233 || sqlw.getSQLState() == "010P4") continue;
                if (sb == null) {
                    sb = new StringBuilder(htmlBegin);
                }
                sb = sb.append(sqlw.getMessage()).append(htmlNewLine);
            }
            stmt.close();
        }
        catch (SQLException e) {
            _logger.warn((Object)("Problems when executing sql: " + sql), (Throwable)e);
        }
        finally {
            if (curMsgHandler != null) {
                ((SybConnection)conn).setSybMessageHandler(curMsgHandler);
            }
        }
        if (sb == null) {
            return null;
        }
        while (sb.charAt(sb.length() - 1) == '\n') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.append(htmlEnd).toString();
    }

    private static boolean __isDbccTraceOnInMap(Connection conn, int trace) {
        if (conn == null) {
            return false;
        }
        List<Integer> traceList = _connHasTraceFlagEnabled.get(conn.toString());
        if (traceList == null) {
            return false;
        }
        return traceList.contains(trace);
    }

    private static void __setDbccTraceOnInMap(Connection conn, int trace) {
        if (conn == null) {
            return;
        }
        List<Integer> traceList = _connHasTraceFlagEnabled.get(conn.toString());
        if (traceList == null) {
            traceList = new ArrayList<Integer>();
        }
        traceList.add(trace);
    }

    public static void dbccTraceOn(Connection conn, int trace) {
        if (AseConnectionUtils.__isDbccTraceOnInMap(conn, trace)) {
            return;
        }
        String setSwitch = "set switch on " + trace + " with no_info";
        String dbccTraceon = "DBCC traceon(" + trace + ")";
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(setSwitch);
            stmt.close();
            AseConnectionUtils.__setDbccTraceOnInMap(conn, trace);
        }
        catch (SQLException e) {
            _logger.debug((Object)("Problems when executing sql '" + setSwitch + "', I will fallback and use '" + dbccTraceon + "' instead."));
            try {
                Statement stmt = conn.createStatement();
                stmt.executeUpdate(dbccTraceon);
                stmt.close();
                AseConnectionUtils.__setDbccTraceOnInMap(conn, trace);
            }
            catch (SQLException e2) {
                _logger.warn((Object)("Problems when executing sql: " + dbccTraceon), (Throwable)e2);
            }
        }
    }

    public static String monSqlText(Connection conn, int spid, boolean addHtmlTags) {
        String htmlBegin = "";
        String htmlEnd = "";
        if (addHtmlTags) {
            htmlBegin = "<html><pre>";
            htmlEnd = "</pre></html>";
        }
        StringBuilder sb = null;
        String sql = "select BatchID, LineNumber, SequenceInLine, SQLText from master..monProcessSQLText where SPID = " + spid;
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            int saveLineNumber = 1;
            while (rs.next()) {
                if (sb == null) {
                    sb = new StringBuilder(htmlBegin);
                }
                int atLineNum = rs.getInt(2);
                String sqltext = rs.getString(4);
                while (saveLineNumber < atLineNum) {
                    sb.append("\n");
                    if (++saveLineNumber <= 10240) continue;
                }
                if (atLineNum == saveLineNumber) {
                    sb.append(sqltext);
                } else {
                    sb.append(sqltext).append("\n");
                }
                saveLineNumber = atLineNum;
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            _logger.warn((Object)("Problems when executing sql: " + sql), (Throwable)e);
        }
        if (sb == null) {
            return null;
        }
        while (sb.charAt(sb.length() - 1) == '\n') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.append(htmlEnd).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dbccSqlText(Connection conn, int spid, boolean addHtmlTags) {
        String htmlBegin = "";
        String htmlEnd = "";
        String htmlNewLine = "";
        if (addHtmlTags) {
            htmlBegin = "<html><pre>";
            htmlEnd = "</pre></html>";
        }
        AseConnectionUtils.dbccTraceOn(conn, 3604);
        StringBuilder sb = null;
        String sql = "DBCC sqltext(" + spid + ")";
        SybMessageHandler curMsgHandler = null;
        if (conn instanceof SybConnection) {
            curMsgHandler = ((SybConnection)conn).getSybMessageHandler();
            ((SybConnection)conn).setSybMessageHandler(null);
        }
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(sql);
            for (SQLWarning sqlw = stmt.getWarnings(); sqlw != null; sqlw = sqlw.getNextWarning()) {
                if (sqlw.getMessage().startsWith("DBCC execution completed. If DBCC")) continue;
                if (sb == null) {
                    sb = new StringBuilder(htmlBegin);
                }
                String text = sqlw.getMessage();
                sb = sb.append(text).append(htmlNewLine);
            }
            stmt.close();
        }
        catch (SQLException e) {
            _logger.warn((Object)("Problems when executing sql: " + sql), (Throwable)e);
        }
        finally {
            if (curMsgHandler != null) {
                ((SybConnection)conn).setSybMessageHandler(curMsgHandler);
            }
        }
        if (sb == null) {
            return null;
        }
        while (sb.charAt(sb.length() - 1) == '\n') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.append(htmlEnd).toString();
    }

    public static String getObjectOwner(Connection conn, String dbname, String objectName) {
        if (StringUtil.isNullOrBlank(dbname)) {
            throw new RuntimeException("getObjectOwner(): dbname='" + dbname + "', which is blank or null. This is mandatory.");
        }
        if (StringUtil.isNullOrBlank(objectName)) {
            throw new RuntimeException("getObjectOwner(): objectName='" + objectName + "', which is blank or null. This is mandatory.");
        }
        dbname = dbname.trim();
        objectName = objectName.trim();
        String sql = "select owner = u.name \nfrom " + dbname + "..sysobjects o, " + dbname + "..sysusers u \nwhere o.name = '" + objectName + "' \n  and o.uid  = u.uid";
        String owner = "dbo";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                owner = rs.getString(1);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException ex) {
            _logger.warn((Object)("Problems when executing sql: " + sql), (Throwable)ex);
        }
        if (StringUtil.isNullOrBlank(owner)) {
            owner = "dbo";
        }
        return owner;
    }

    public static int findColumn(ResultSetMetaData rsmd, String colLabel) {
        if (rsmd == null) {
            throw new IllegalArgumentException("findColumn(ResultSetMetaData rsmd, String colLabel): rsmd can't be null");
        }
        if (colLabel == null) {
            throw new IllegalArgumentException("findColumn(ResultSetMetaData rsmd, String colLabel): colLabel can't be null");
        }
        int col_pos = -1;
        try {
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                if (!colLabel.equals(rsmd.getColumnLabel(i))) continue;
                col_pos = i;
                break;
            }
        }
        catch (SQLException e) {
            _logger.error((Object)("Problems accessing ResultSetMetaData, caught: " + e), (Throwable)e);
        }
        return col_pos;
    }

    public static ConnectionStateInfo getAseConnectionStateInfo(Connection conn, boolean getTranState) {
        String sql = "select dbname=db_name(), spid=@@spid, username = user_name(), susername =suser_name(), trancount=@@trancount, tranchained=@@tranchained";
        if (getTranState) {
            sql = sql + ", transtate=@@transtate";
        }
        ConnectionStateInfo csi = new ConnectionStateInfo();
        try {
            Statement stmnt = conn.createStatement();
            ResultSet rs = stmnt.executeQuery(sql);
            while (rs.next()) {
                csi._dbname = rs.getString(1);
                csi._spid = rs.getInt(2);
                csi._username = rs.getString(3);
                csi._susername = rs.getString(4);
                csi._tranCount = rs.getInt(5);
                csi._tranChained = rs.getInt(6);
                csi._tranState = getTranState ? rs.getInt(7) : 4;
            }
            sql = "select dbname=db_name(dbid), table_name=object_name(id, dbid), lock_type=type, lock_count=count(*)  from master.dbo.syslocks  where spid = @@spid\t group by dbid, id, type ";
            csi._lockCount = 0;
            csi._lockList.clear();
            rs = stmnt.executeQuery(sql);
            while (rs.next()) {
                String dbname = rs.getString(1);
                String tableName = rs.getString(2);
                int lockType = rs.getInt(3);
                int lockCount = rs.getInt(4);
                csi._lockCount += lockCount;
                csi._lockList.add(new LockRecord(dbname, tableName, lockType, lockCount));
            }
            rs.close();
            stmnt.close();
        }
        catch (SQLException sqle) {
            _logger.error((Object)("Error in getAseConnectionStateInfo() problems executing sql='" + sql + "'."), (Throwable)sqle);
        }
        _logger.debug((Object)("getAseConnectionStateInfo(): db_name()='" + csi._dbname + "', @@spid='" + csi._spid + "', user_name()='" + csi._username + "', suser_name()='" + csi._susername + "', @@transtate=" + csi._tranState + ", '" + csi.getTranStateStr() + "', @@trancount=" + csi._tranCount + "."));
        return csi;
    }

    public static String getAseLockType(int type) {
        switch (type) {
            case 1: {
                return "Ex_table";
            }
            case 2: {
                return "Sh_table";
            }
            case 3: {
                return "Ex_intent";
            }
            case 4: {
                return "Sh_intent";
            }
            case 5: {
                return "Ex_page";
            }
            case 6: {
                return "Sh_page";
            }
            case 7: {
                return "Update_page";
            }
            case 8: {
                return "Ex_row";
            }
            case 9: {
                return "Sh_row";
            }
            case 10: {
                return "Update_row";
            }
            case 11: {
                return "Sh_nextkey";
            }
            case 257: {
                return "Ex_table-blk";
            }
            case 258: {
                return "Sh_table-blk";
            }
            case 259: {
                return "Ex_intent-blk";
            }
            case 260: {
                return "Sh_intent-blk";
            }
            case 261: {
                return "Ex_page-blk";
            }
            case 262: {
                return "Sh_page-blk";
            }
            case 263: {
                return "Update_page-blk";
            }
            case 264: {
                return "Ex_row-blk";
            }
            case 265: {
                return "Sh_row-blk";
            }
            case 266: {
                return "Update_row-blk";
            }
            case 267: {
                return "Sh_nextkey-blk";
            }
            case 513: {
                return "Ex_table-demand";
            }
            case 514: {
                return "Sh_table-demand";
            }
            case 515: {
                return "Ex_intent-demand";
            }
            case 516: {
                return "Sh_intent-demand";
            }
            case 517: {
                return "Ex_page-demand";
            }
            case 518: {
                return "Sh_page-demand";
            }
            case 519: {
                return "Update_page-demand";
            }
            case 520: {
                return "Ex_row-demand";
            }
            case 521: {
                return "Sh_row-demand";
            }
            case 522: {
                return "Update_row-demand";
            }
            case 523: {
                return "Sh_nextkey-demand";
            }
            case 769: {
                return "Ex_table-demand-blk";
            }
            case 770: {
                return "Sh_table-demand-blk";
            }
            case 771: {
                return "Ex_intent-demand-blk";
            }
            case 772: {
                return "Sh_intent-demand-blk";
            }
            case 773: {
                return "Ex_page-demand-blk";
            }
            case 774: {
                return "Sh_page-demand-blk";
            }
            case 775: {
                return "Update_page-demand-blk";
            }
            case 776: {
                return "Ex_row-demand-blk";
            }
            case 777: {
                return "Sh_row-demand-blk";
            }
            case 778: {
                return "Update_row-demand-blk";
            }
            case 779: {
                return "Sh_nextkey-demand-blk";
            }
            case 1025: {
                return "Ex_table-request";
            }
            case 1026: {
                return "Sh_table-request";
            }
            case 1027: {
                return "Ex_intent-request";
            }
            case 1028: {
                return "Sh_intent-request";
            }
            case 1029: {
                return "Ex_page-request";
            }
            case 1030: {
                return "Sh_page-request";
            }
            case 1031: {
                return "Update_page-request";
            }
            case 1032: {
                return "Ex_row-request";
            }
            case 1033: {
                return "Sh_row-request";
            }
            case 1034: {
                return "Update_row-request";
            }
            case 1035: {
                return "Sh_nextkey-request";
            }
            case 1537: {
                return "Ex_table-demand-request";
            }
            case 1538: {
                return "Sh_table-demand-request";
            }
            case 1539: {
                return "Ex_intent-demand-request";
            }
            case 1540: {
                return "Sh_intent-demand-request";
            }
            case 1541: {
                return "Ex_page-demand-request";
            }
            case 1542: {
                return "Sh_page-demand-request";
            }
            case 1543: {
                return "Update_page-demand-request";
            }
            case 1544: {
                return "Ex_row-demand-request";
            }
            case 1545: {
                return "Sh_row-demand-request";
            }
            case 1546: {
                return "Update_row-demand-request";
            }
            case 1547: {
                return "Sh_nextkey-demand-request";
            }
        }
        return "unknown(" + type + ")";
    }

    public static boolean canDoSelectOnTable(Connection conn, String tableName) {
        String sql = "select * from " + tableName + " where 1=2";
        if (!AseConnectionUtils.isConnectionOk(conn)) {
            return false;
        }
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
            }
            rs.close();
            stmt.close();
            return true;
        }
        catch (SQLException ex) {
            _logger.warn((Object)("Authoritization problems when checking simple select on table '" + tableName + "'. SQL issued '" + sql + "' SQLException Error=" + ex.getErrorCode() + ", Msg='" + StringUtil.stripNewLine(ex.getMessage()) + "'."));
            return false;
        }
    }

    public static class LockRecord {
        public String _dbname = "";
        public String _tableName = "";
        public String _lockType = "";
        public int _lockCount = 0;

        public LockRecord(String dbname, String tableName, int lockType, int lockCount) {
            this._dbname = dbname;
            this._tableName = tableName;
            this._lockType = AseConnectionUtils.getAseLockType(lockType);
            this._lockCount = lockCount;
        }
    }

    public static class ConnectionStateInfo {
        public String _dbname = "";
        public int _spid = -1;
        public String _username = "";
        public String _susername = "";
        public int _tranState = -1;
        public int _tranCount = -1;
        public int _tranChained = -1;
        public int _lockCount = -1;
        public List<LockRecord> _lockList = new ArrayList<LockRecord>();
        public static final int TSQL_TRAN_IN_PROGRESS = 0;
        public static final int TSQL_TRAN_SUCCEED = 1;
        public static final int TSQL_STMT_ABORT = 2;
        public static final int TSQL_TRAN_ABORT = 3;
        public static final int TSQL_TRANSTATE_NOT_AVAILABLE = 4;
        public static final String[] TSQL_TRANSTATE_NAMES = new String[]{"TRAN_IN_PROGRESS", "TRAN_SUCCEED", "STMT_ABORT", "TRAN_ABORT", "NOT_AVAILABLE"};
        public static final String[] TSQL_TRANSTATE_DESCRIPTIONS = new String[]{"TRAN_IN_PROGRESS = Transaction in progress. \nThe previous statement executed successfully.", "TRAN_SUCCEED = Last Transaction succeeded. \nThe transaction completed and committed its changes.", "STMT_ABORT = Last Statement aborted. \nThe previous statement was aborted; \nNo effect on the transaction.", "TRAN_ABORT = Last Transaction aborted. \nThe transaction aborted and rolled back any changes.", "NOT_AVAILABLE = Not available in this system."};

        public boolean isTranStateUsed() {
            return this._tranState != 4;
        }

        public boolean isNonNormalTranState() {
            return !this.isNormalTranState();
        }

        public boolean isNormalTranState() {
            if (this._tranState == 1) {
                return true;
            }
            return this._tranState == 4;
        }

        public String getTranStateStr() {
            return this.tsqlTranStateToString(this._tranState);
        }

        public String getTranStateDescription() {
            return this.tsqlTranStateToDescription(this._tranState);
        }

        protected String tsqlTranStateToString(int state) {
            switch (state) {
                case 0: {
                    return TSQL_TRANSTATE_NAMES[state];
                }
                case 1: {
                    return TSQL_TRANSTATE_NAMES[state];
                }
                case 2: {
                    return TSQL_TRANSTATE_NAMES[state];
                }
                case 3: {
                    return TSQL_TRANSTATE_NAMES[state];
                }
                case 4: {
                    return TSQL_TRANSTATE_NAMES[state];
                }
            }
            return "TSQL_UNKNOWN_STATE(" + state + ")";
        }

        protected String tsqlTranStateToDescription(int state) {
            switch (state) {
                case 0: {
                    return TSQL_TRANSTATE_DESCRIPTIONS[state];
                }
                case 1: {
                    return TSQL_TRANSTATE_DESCRIPTIONS[state];
                }
                case 2: {
                    return TSQL_TRANSTATE_DESCRIPTIONS[state];
                }
                case 3: {
                    return TSQL_TRANSTATE_DESCRIPTIONS[state];
                }
                case 4: {
                    return TSQL_TRANSTATE_DESCRIPTIONS[state];
                }
            }
            return "TSQL_UNKNOWN_STATE(" + state + ")";
        }

        public String getLockListTableAsHtmlTable() {
            if (this._lockList.size() == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder("<TABLE BORDER=1>");
            sb.append("<TR> <TH>DB</TH> <TH>Table</TH> <TH>Type</TH> <TH>Count</TH> </TR>");
            for (LockRecord lr : this._lockList) {
                sb.append("<TR>");
                sb.append("<TD>").append(lr._dbname).append("</TD>");
                sb.append("<TD>").append(lr._tableName).append("</TD>");
                sb.append("<TD>").append(lr._lockType).append("</TD>");
                sb.append("<TD>").append(lr._lockCount).append("</TD>");
                sb.append("</TR>");
            }
            sb.append("</TABLE>");
            return sb.toString();
        }
    }
}

