/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.utils;

import com.sap.dbmtk.demo.ui.ConnectionDialog;
import com.sap.dbmtk.demo.ui.ResultSetTableModel;
import com.sap.dbmtk.demo.utils.AseConnectionUtils;
import com.sap.dbmtk.demo.utils.StringUtil;
import com.sap.dbmtk.demo.utils.SwingUtils;
import java.awt.Component;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class DbUtils {
    private static Logger _logger = Logger.getLogger(DbUtils.class);
    public static final String DB_PROD_NAME_SYBASE_ASE = "Adaptive Server Enterprise";
    public static final String DB_PROD_NAME_SYBASE_ASA = "SQL Anywhere";
    public static final String DB_PROD_NAME_SYBASE_IQ = "Sybase IQ";
    public static final String DB_PROD_NAME_SYBASE_RS = "Replication Server";
    public static final String DB_PROD_NAME_H2 = "H2";
    public static final String DB_PROD_NAME_HANA = "HDB";
    public static final String DB_PROD_NAME_MAXDB = "SAP DB";
    public static final String DB_PROD_NAME_HSQL = "HSQL Database Engine";
    public static final String DB_PROD_NAME_MSSQL = "Microsoft SQL Server";
    public static final String DB_PROD_NAME_ORACLE = "Oracle";
    public static final String DB_PROD_NAME_DB2_UX = "DB2/Linux";
    public static final String DB_PROD_NAME_DB2_ZOS = "DB2";
    public static final String DB_PROD_NAME_MYSQL = "MySQL";
    public static final String DB_PROD_NAME_DERBY = "Apache Derby";

    public static boolean isProductName(String checkProductName, String ... prodNameList) {
        if (checkProductName == null) {
            return false;
        }
        for (int i = 0; i < prodNameList.length; ++i) {
            String name = prodNameList[i];
            if (name == null) continue;
            if (checkProductName.equals(name)) {
                return true;
            }
            if (!DB_PROD_NAME_DB2_UX.equals(name) || !checkProductName.toLowerCase().startsWith(name.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static String getProductName(Connection conn) {
        if (conn == null) {
            throw new RuntimeException("DbUtils.setAutoCommit() conn=null, So I can't continue");
        }
        try {
            DatabaseMetaData md = conn.getMetaData();
            return md.getDatabaseProductName();
        }
        catch (SQLException ex) {
            return "";
        }
    }

    public static boolean getAutoCommitNoThrow(Connection conn, String dbVendorName) {
        try {
            return DbUtils.getAutoCommit(conn, dbVendorName);
        }
        catch (SQLException e) {
            _logger.warn((Object)("Problems when calling getAutoCommit(). Caught: " + e));
            return true;
        }
    }

    public static boolean getAutoCommit(Connection conn, String dbVendorName) throws SQLException {
        boolean isAutoCommit = true;
        if (StringUtil.isNullOrBlank(dbVendorName)) {
            dbVendorName = DbUtils.getProductName(conn);
        }
        if (DbUtils.isProductName(dbVendorName, DB_PROD_NAME_SYBASE_ASE)) {
            int atatTranChained = -1;
            Statement stmnt = conn.createStatement();
            ResultSet rs = stmnt.executeQuery("select @@tranchained");
            while (rs.next()) {
                atatTranChained = rs.getInt(1);
            }
            rs.close();
            stmnt.close();
            if (atatTranChained != -1) {
                isAutoCommit = atatTranChained == 0;
            }
        } else {
            isAutoCommit = conn.getAutoCommit();
        }
        return isAutoCommit;
    }

    public static boolean setAutoCommit(Connection conn, String dbVendorName, boolean toValue, String calledFrom) {
        return DbUtils.setAutoCommit(conn, dbVendorName, null, toValue, calledFrom);
    }

    public static boolean setAutoCommit(Connection conn, String dbVendorName, Component owner, boolean toValue, String calledFrom) {
        block20: {
            if (conn == null) {
                throw new RuntimeException("DbUtils.setAutoCommit() conn=null, So I can't continue");
            }
            if (calledFrom == null) {
                calledFrom = "";
            }
            if (StringUtil.isNullOrBlank(dbVendorName)) {
                dbVendorName = DbUtils.getProductName(conn);
            }
            try {
                boolean isAutoCommit = DbUtils.getAutoCommit(conn, dbVendorName);
                if (isAutoCommit != toValue) {
                    _logger.info((Object)("Setting JDBC AutoCommit to: " + toValue + (toValue ? " (unchained/normal mode)" : " (chained mode)")));
                    if (DbUtils.isProductName(dbVendorName, DB_PROD_NAME_SYBASE_ASE)) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug((Object)("setAutoCommit(" + dbVendorName + "): Special logic for Sybase ASE."));
                        }
                        Statement stmnt = conn.createStatement();
                        stmnt.executeUpdate(toValue ? "set chained off" : "set chained on");
                        AseConnectionUtils.checkSqlWarningsAndThrowSqlExceptionIfSeverityIsAbove10(stmnt.getWarnings());
                        AseConnectionUtils.checkSqlWarningsAndThrowSqlExceptionIfSeverityIsAbove10(conn.getWarnings());
                        stmnt.close();
                    } else {
                        conn.setAutoCommit(toValue);
                    }
                }
            }
            catch (SQLException ex) {
                Object[] buttons;
                String sybLockHtmlTable = null;
                int sybLockCount = -1;
                if (DbUtils.isProductName(dbVendorName, DB_PROD_NAME_SYBASE_ASE)) {
                    String sql = "select dbname=db_name(dbid), table_name=object_name(id, dbid), lock_type=type, lock_count=count(*)  from master.dbo.syslocks  where spid = @@spid\t group by dbid, id, type ";
                    try {
                        sybLockCount = 0;
                        StringBuilder sb = new StringBuilder("<TABLE BORDER=1>");
                        sb.append("<TR> <TH>DB</TH> <TH>Table</TH> <TH>Type</TH> <TH>Count</TH> </TR>");
                        Statement stmnt = conn.createStatement();
                        ResultSet rs = stmnt.executeQuery(sql);
                        while (rs.next()) {
                            ++sybLockCount;
                            sb.append("<TR>");
                            sb.append("<TD>").append(rs.getString(1)).append("</TD>");
                            sb.append("<TD>").append(rs.getString(2)).append("</TD>");
                            sb.append("<TD>").append(AseConnectionUtils.getAseLockType(rs.getInt(3))).append("</TD>");
                            sb.append("<TD>").append(rs.getString(4)).append("</TD>");
                            sb.append("</TR>");
                        }
                        rs.close();
                        sb.append("</TABLE>");
                        sb.append("<BR>");
                        sb.insert(0, "User <b>holds " + sybLockCount + " locks</b> in the server. Below is a summary table with current locks.<br>");
                        sybLockHtmlTable = sb.toString();
                        AseConnectionUtils.checkSqlWarningsAndThrowSqlExceptionIfSeverityIsAbove10(stmnt.getWarnings());
                        AseConnectionUtils.checkSqlWarningsAndThrowSqlExceptionIfSeverityIsAbove10(conn.getWarnings());
                        stmnt.close();
                    }
                    catch (SQLException ex2) {
                        _logger.warn((Object)("Problem checking if we are holding locks in the server. SQL='" + sql + "'. Caught: " + ex2));
                    }
                }
                if (sybLockCount == 0) {
                    _logger.info((Object)("setAutoCommit(): problems, but when examin the syslocks, the current SPID holds NO locks. So I will COMMIT and try setAutoCommit(" + toValue + ") again. BTW Exception Caught when trying setAutoCommit(" + toValue + ") the first time: " + ex.getMessage().replace('\n', ' ')));
                    try {
                        conn.commit();
                        conn.setAutoCommit(toValue);
                    }
                    catch (SQLException ex2) {
                        SwingUtils.showErrorMessage(owner, "setAutoCommit problem", "Sorry, Problems issuing JDBC setAutoCommit(" + toValue + ") on the connection.", ex);
                    }
                }
                String htmlMsg = "<html>Problems issuing JDBC setAutoCommit(<b>" + toValue + "</b>) on the connection<br><br>" + calledFrom + (StringUtil.isNullOrBlank(calledFrom) ? "" : "<br><br>") + (sybLockHtmlTable == null ? "" : sybLockHtmlTable) + "<b>SQLException</b>: <table BORDER=0 CELLSPACING=1 CELLPADDING=0>  <tr> <td><b>Error:   </b></td> <td>&nbsp;<code>" + ex.getErrorCode() + "</code></td> </tr>  <tr> <td><b>SQLState:</b></td> <td>&nbsp;<code>" + ex.getSQLState() + "</code></td> </tr>  <tr> <td><b>Message: </b></td> <td>&nbsp;<code>" + ex.getMessage().replace("\n", "<br>") + "</code></td> </tr></table><br>My guess is that some <i>explicit</i> or <i>implicit</i> change was done on the system<br>Please try one of the below methods to solve the issue.<ul>  <li>Commit - Will commit current transaction and then retry the setAutoCommit(<b>" + toValue + "</b>)</li>  <li>Rollback - Will rollback current transaction and then retry the setAutoCommit(<b>" + toValue + "</b>)</li>  <li>Cancel - Will simply do nothing and just continues.</li></ul></html>";
                int answer = JOptionPane.showOptionDialog(owner, htmlMsg, "Problems issuing JDBC setAutoCommit", -1, 3, null, buttons = new Object[]{"Commit and Retry", "Rollback and Retry", "Cancel"}, buttons[0]);
                if (answer != 0 && answer != 1) break block20;
                try {
                    if (answer == 0) {
                        conn.commit();
                    } else {
                        conn.rollback();
                    }
                    conn.setAutoCommit(toValue);
                }
                catch (SQLException ex2) {
                    SwingUtils.showErrorMessage(owner, "setAutoCommit problem", "Sorry, there were still Problems issuing JDBC setAutoCommit(" + toValue + ") on the connection.", ex);
                }
            }
        }
        return DbUtils.getAutoCommitNoThrow(conn, dbVendorName);
    }

    public static String getDatabaseServerName(Connection conn, String dbProductName) {
        if (conn == null) {
            return "";
        }
        String srvName = null;
        try {
            if (StringUtil.isNullOrBlank(dbProductName)) {
                dbProductName = ConnectionDialog.getDatabaseProductName(conn);
            }
            srvName = ConnectionDialog.getDatabaseServerName(conn);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (StringUtil.isNullOrBlank(srvName)) {
            try {
                srvName = conn.getMetaData().getURL();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return srvName;
    }

    public static List<ResultSetTableModel> exec(Connection conn, String sql) throws SQLException {
        ArrayList<ResultSetTableModel> rsList = new ArrayList<ResultSetTableModel>();
        if (conn == null) {
            return rsList;
        }
        Statement stmnt = conn.createStatement();
        boolean hasRs = stmnt.execute(sql);
        int rowsAffected = 0;
        do {
            if (hasRs) {
                ResultSet rs = stmnt.getResultSet();
                ResultSetTableModel tm = new ResultSetTableModel(rs, sql);
                rsList.add(tm);
                rs.close();
                continue;
            }
            rowsAffected = stmnt.getUpdateCount();
            if (rowsAffected < 0) continue;
        } while ((hasRs = stmnt.getMoreResults()) || rowsAffected != -1);
        stmnt.close();
        return rsList;
    }

    public static int getLineForFirstStatement(String sql) {
        if (sql == null) {
            return 0;
        }
        if ("".equals(sql)) {
            return 1;
        }
        int rowNumber = 0;
        boolean inMultiLineComment = false;
        Scanner scanner = new Scanner(sql);
        while (scanner.hasNextLine()) {
            ++rowNumber;
            String lineStr = scanner.nextLine().trim();
            if (lineStr.startsWith("/*") && lineStr.endsWith("*/")) continue;
            if (lineStr.startsWith("/*") && lineStr.indexOf("*/") > 0) {
                lineStr = lineStr.substring(lineStr.indexOf("*/") + 2).trim();
            }
            if (lineStr.startsWith("/*")) {
                inMultiLineComment = true;
                continue;
            }
            if (lineStr.endsWith("*/")) {
                inMultiLineComment = false;
                continue;
            }
            if (lineStr.indexOf("*/") >= 0) {
                inMultiLineComment = false;
                lineStr = lineStr.substring(lineStr.indexOf("*/") + 2).trim();
            }
            if (inMultiLineComment || lineStr.equals("") || lineStr.startsWith("--")) continue;
            return rowNumber;
        }
        return rowNumber;
    }

    public static String getHanaServername(Connection conn) {
        String UNKNOWN = "UNKNOWN";
        if (!AseConnectionUtils.isConnectionOk(conn)) {
            return "UNKNOWN";
        }
        String retStr = "UNKNOWN";
        String sql = "select DATABASE_NAME from m_database";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                retStr = rs.getString(1).trim();
            }
            rs.close();
            stmt.close();
            return retStr;
        }
        catch (SQLException e) {
            _logger.debug((Object)("When getting HANA Server Instance Name. sql='" + sql + "', Caught exception."), (Throwable)e);
            return "UNKNOWN";
        }
    }

    public static String parseHanaMessageForProcName(String msg) {
        if (msg == null) {
            return null;
        }
        int linePos = msg.indexOf(" line ");
        if (linePos > 0) {
            int firstQuote;
            String objName = null;
            int bracketPos = 0;
            for (int p = linePos; p > 0; --p) {
                if (msg.charAt(p) != ']') continue;
                bracketPos = p;
                break;
            }
            if (bracketPos > 0 && (firstQuote = msg.indexOf(34, bracketPos)) > 0 && firstQuote < linePos) {
                objName = msg.substring(bracketPos + 1, linePos - 1);
                objName = objName.replace("\"", "").trim();
            }
            return objName;
        }
        return null;
    }

    public static String getHanaObjectText(Connection conn, String objectName) {
        if (conn == null) {
            return null;
        }
        if (objectName == null) {
            return null;
        }
        if (objectName.indexOf(".") < 0) {
            return null;
        }
        int firstDot = objectName.indexOf(".");
        String schema = objectName.substring(0, firstDot).trim();
        String name = objectName.substring(firstDot + 1).trim();
        String sqlGetObjType = "select OBJECT_TYPE from PUBLIC.OBJECTS    where SCHEMA_NAME = '" + schema + "' and OBJECT_NAME    = '" + name + "'";
        String sqlGetProcText = "select DEFINITION  from PUBLIC.PROCEDURES where SCHEMA_NAME = '" + schema + "' and PROCEDURE_NAME = '" + name + "'";
        String sqlGetFuncText = "select DEFINITION  from PUBLIC.FUNCTIONS  where SCHEMA_NAME = '" + schema + "' and FUNCTION_NAME  = '" + name + "'";
        try {
            Statement stmnt = conn.createStatement();
            ResultSet rs = stmnt.executeQuery(sqlGetObjType);
            String objType = "";
            while (rs.next()) {
                objType = rs.getString(1);
            }
            String sql = null;
            if (objType.equalsIgnoreCase("PROCEDURE")) {
                sql = sqlGetProcText;
            } else if (objType.equalsIgnoreCase("FUNCTION")) {
                sql = sqlGetFuncText;
            } else {
                _logger.warn((Object)("getHanaObjectText(objectName='" + objectName + "'), was of type '" + objType + "', which isn't implemented yet, returning null"));
                return null;
            }
            StringBuilder sb = new StringBuilder();
            rs = stmnt.executeQuery(sql);
            while (rs.next()) {
                sb.append(rs.getString(1));
            }
            return sb.toString();
        }
        catch (SQLException e) {
            _logger.warn((Object)("Problems getting procedure/function text for '" + objectName + "' from HANA. Error Number: " + e.getErrorCode() + ", Message: " + e.getMessage()));
            return null;
        }
    }

    public static String getOracleServername(Connection conn) {
        String UNKNOWN = "UNKNOWN";
        if (!AseConnectionUtils.isConnectionOk(conn)) {
            return "UNKNOWN";
        }
        String retStr = "UNKNOWN";
        String sql = "select sys_context('USERENV','DB_NAME') as Instance from dual";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                retStr = rs.getString(1).trim();
            }
            rs.close();
            stmt.close();
            return retStr;
        }
        catch (SQLException e) {
            _logger.debug((Object)("When getting Oracle Server Instance Name. sql='" + sql + "', Caught exception."), (Throwable)e);
            return "UNKNOWN";
        }
    }

    public static String getOracleCharset(Connection conn) {
        String UNKNOWN = "UNKNOWN";
        if (!AseConnectionUtils.isConnectionOk(conn)) {
            return "UNKNOWN";
        }
        String retStr = "UNKNOWN";
        String sql = "select VALUE from NLS_DATABASE_PARAMETERS where PARAMETER = 'NLS_CHARACTERSET'";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                retStr = rs.getString(1).trim();
            }
            rs.close();
            stmt.close();
            return retStr;
        }
        catch (SQLException e) {
            _logger.debug((Object)("When getting Oracle Server CharacterSet. sql='" + sql + "', Caught exception."), (Throwable)e);
            return "UNKNOWN";
        }
    }

    public static String getOracleSortorder(Connection conn) {
        String UNKNOWN = "UNKNOWN";
        if (!AseConnectionUtils.isConnectionOk(conn)) {
            return "UNKNOWN";
        }
        String retStr = "UNKNOWN";
        String sql = "select VALUE from NLS_DATABASE_PARAMETERS where PARAMETER = 'NLS_SORT'";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                retStr = rs.getString(1).trim();
            }
            rs.close();
            stmt.close();
            return retStr;
        }
        catch (SQLException e) {
            _logger.debug((Object)("When getting Oracle Server Sort Order. sql='" + sql + "', Caught exception."), (Throwable)e);
            return "UNKNOWN";
        }
    }

    public static String getDb2Servername(Connection conn) {
        String UNKNOWN = "UNKNOWN";
        if (!AseConnectionUtils.isConnectionOk(conn)) {
            return "UNKNOWN";
        }
        String retStr = "UNKNOWN";
        String sql = "SELECT CURRENT SERVER as DBNAME, ei.INST_NAME, (SELECT HOST_NAME FROM TABLE(SYSPROC.ENV_GET_SYS_INFO())) FROM SYSIBMADM.ENV_INST_INFO ei";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                retStr = rs.getString(1).trim() + "/" + rs.getString(2).trim() + "@" + rs.getString(3).trim();
            }
            rs.close();
            stmt.close();
            return retStr;
        }
        catch (SQLException e) {
            _logger.debug((Object)("When getting DB2 Server Instance Name. sql='" + sql + "', Caught exception."), (Throwable)e);
            return "UNKNOWN";
        }
    }

    public static String getDb2Charset(Connection conn) {
        String UNKNOWN = "UNKNOWN";
        if (!AseConnectionUtils.isConnectionOk(conn)) {
            return "UNKNOWN";
        }
        String retStr = "UNKNOWN";
        String sql = "select VALUE from SYSIBMADM.DBCFG where NAME = 'codeset'";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                retStr = rs.getString(1).trim();
            }
            rs.close();
            stmt.close();
            return retStr;
        }
        catch (SQLException e) {
            _logger.debug((Object)("When getting DB2 Server CharacterSet. sql='" + sql + "', Caught exception."), (Throwable)e);
            return "UNKNOWN";
        }
    }

    public static String getDb2Sortorder(Connection conn) {
        String UNKNOWN = "UNKNOWN";
        return "UNKNOWN";
    }

    public static String getMaxDbServername(Connection conn) {
        return "";
    }

    public static String getMaxDbCharset(Connection conn) {
        String UNKNOWN = "UNKNOWN";
        return "UNKNOWN";
    }

    public static String getMaxDbSortorder(Connection conn) {
        String UNKNOWN = "UNKNOWN";
        return "UNKNOWN";
    }

    public static JdbcConnectionStateInfo getJdbcConnectionStateInfo(Connection conn) {
        JdbcConnectionStateInfo csi = new JdbcConnectionStateInfo();
        try {
            csi._catalog = conn.getCatalog();
            csi._autocommit = conn.getAutoCommit();
            csi._isolationLevel = conn.getTransactionIsolation();
        }
        catch (SQLException sqle) {
            _logger.error((Object)"Error in getJdbcConnectionStateInfo()", (Throwable)sqle);
        }
        return csi;
    }

    private static void test(int testCase, int expected, String str) {
        System.out.println();
        System.out.println(">>>>> BEGIN, test case(" + testCase + "): expected=" + expected);
        int r = DbUtils.getLineForFirstStatement(str);
        if (r != expected) {
            System.out.println("###### FAILED, test case(" + testCase + "): ret=" + r + ", expected=" + expected + " ===== THE STR:");
            Scanner sc = new Scanner(str);
            int lineNumber = 0;
            while (sc.hasNextLine()) {
                System.out.printf("%04d: %s%n", ++lineNumber, sc.nextLine());
            }
            System.out.println("###### END ########################################");
            System.out.println();
        } else {
            System.out.println("<<<<< -END-, test case(" + testCase + "): -OK-OK-OK-");
        }
    }

    public static void main(String[] args) {
        DbUtils.test(0, 0, null);
        DbUtils.test(1, 1, "");
        DbUtils.test(2, 1, " ");
        DbUtils.test(3, 1, "--askjdhgads");
        DbUtils.test(4, 2, "--askjdhgads\n XXX");
        DbUtils.test(5, 3, "\n\n\n");
        DbUtils.test(6, 2, "\nXXX");
        DbUtils.test(7, 2, "   /*xxxxx*/   \nXXXX");
        DbUtils.test(8, 1, "   /*xxxxx*/ XXXX");
        DbUtils.test(9, 3, "/*\nXXX\n*/\n");
        DbUtils.test(10, 4, "/*\nXXX\n*/\n  XXXXX");
        System.out.println("1: " + DbUtils.parseHanaMessageForProcName("SAP DBTech JDBC: [260] (at 28): invalid column name: XXX: line 1 col 29 (at pos 28)"));
        System.out.println("2: " + DbUtils.parseHanaMessageForProcName("SAP DBTech JDBC: [19999]: user-defined error:  [19999] \"SYSTEM\".\"SP_DBMTK_PROC_INSTALL_FINAL\": line 58 col 3 (at pos 1705): [19999] (range 3) user-defined error exception: user-defined error:  [19999] \"SYSTEM\".\"SP_DBMTK_ABORT_SESSION\": line 56 col 3 (at pos 1929): [19999] (range 3) user-defined error exception: *** Error while installing PROCEDURE SYSTEM.GS_P1  Object was not found."));
        System.out.println("3: " + DbUtils.parseHanaMessageForProcName("[304]: division by zero undefined:  [304] \"SYSTEM\".\"GS_P1\": line 5 col 2 (at pos 54): [304] (range 3) division by zero undefined exception: division by zero undefined:  at function /()"));
    }

    public static class JdbcConnectionStateInfo {
        public String _catalog = "";
        public boolean _autocommit = true;
        public int _isolationLevel = -1;

        protected String isolationLevelToString(int isolation) {
            switch (isolation) {
                case 1: {
                    return "0=READ_UNCOMMITTED";
                }
                case 2: {
                    return "1=READ_COMMITTED";
                }
                case 4: {
                    return "2=REPEATABLE_READ";
                }
                case 8: {
                    return "3=SERIALIZABLE";
                }
                case 0: {
                    return "NONE";
                }
            }
            return "TRANSACTION_ISOLATION_UNKNOWN_STATE(" + isolation + ")";
        }

        public String getCatalog() {
            return this._catalog;
        }

        public boolean getAutoCommit() {
            return this._autocommit;
        }

        public String getIsolationLevelStr() {
            return this.isolationLevelToString(this._isolationLevel);
        }
    }
}

