/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.utils;

import com.sap.dbmtk.demo.utils.SwingUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ImageLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private Dimension _boundary = null;

    public ImageLabel(ImageIcon icon, Dimension boundary) {
        super(icon);
        this._boundary = boundary;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        ImageIcon imageIcon = (ImageIcon)this.getIcon();
        Dimension imgSize = new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight());
        Dimension newSize = SwingUtils.getScaledDimension(imgSize, this._boundary);
        int width = (int)newSize.getWidth();
        int height = (int)newSize.getHeight();
        int x = 0;
        int y = 0;
        if (width < this.getWidth()) {
            x = (int)((double)this.getWidth() - newSize.getWidth()) / 2;
        }
        if (height < this.getHeight()) {
            y = (int)((double)this.getHeight() - newSize.getHeight()) / 2;
        }
        g.drawImage(imageIcon.getImage(), x, y, width, height, this);
    }
}

