/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.utils;

import org.apache.log4j.Logger;

public class Ver {
    private static Logger _logger = Logger.getLogger(Ver.class);
    public static final int VERSION_MAJOR = 1;
    public static final int VERSION_MINOR = 2;
    public static final int VERSION_MAINTENANCE = 3;
    public static final int VERSION_ROLLUP = 4;
    public static final int VERSION_SERVICE_PACK = 5;
    public static final int VERSION_PATCH_LEVEL = 6;

    public static int ver(int major, int minor, int maint, int sp, int pl) {
        if (major < 10) {
            _logger.warn((Object)("Version Converter. major=" + major + ", minor=" + minor + ",maint=" + maint + ",sp=" + sp + ", pl=" + pl + ". Major must be above 10 otherwise the calcuation will be wrong."));
        }
        return major * 10000000 + minor * 1000000 + maint * 100000 + sp * 100 + pl;
    }

    public static int ver(int major, int minor, int maint, int sp) {
        return Ver.ver(major, minor, maint, sp, 0);
    }

    public static int ver(int major, int minor, int maint) {
        return Ver.ver(major, minor, maint, 0, 0);
    }

    public static int ver(int major, int minor) {
        return Ver.ver(major, minor, 0, 0, 0);
    }

    public static String versionIntToStr(int version) {
        if (version > 100000000) {
            int baseVer = version / 100000;
            int major = baseVer / 100;
            int minor = baseVer % 100 / 10;
            int maintenance = baseVer % 10;
            int servicePack = version % 100000 / 100;
            int patchLevel = version % 100;
            String verStr = "";
            verStr = maintenance == 0 ? major + "." + minor : major + "." + minor + "." + maintenance;
            if (major >= 16) {
                if (servicePack > 0) {
                    verStr = verStr + " SP" + String.format("%02d", servicePack);
                }
                if (patchLevel > 0) {
                    verStr = verStr + " PL" + String.format("%02d", patchLevel);
                }
                return verStr;
            }
            if (major >= 15 && minor >= 7 && servicePack >= 50) {
                verStr = verStr + " SP" + servicePack;
                return verStr;
            }
            if (servicePack > 0) {
                String esdStr = Integer.toString(servicePack);
                if (patchLevel > 0) {
                    esdStr = esdStr + "." + patchLevel;
                }
                return verStr + " ESD#" + esdStr;
            }
            return verStr;
        }
        if (version > 1000000) {
            int major = version / 100000;
            int minor = (version - major * 100000) / 10000;
            int maintenance = (version - (major * 100000 + minor * 10000)) / 1000;
            int servicePack = version - (major * 100000 + minor * 10000 + maintenance * 1000);
            if (servicePack == 0) {
                if (maintenance == 0) {
                    return major + "." + minor;
                }
                return major + "." + minor + "." + maintenance;
            }
            if (servicePack < 100) {
                if (major >= 15 && minor >= 7 && servicePack >= 50) {
                    return major + "." + minor + "." + maintenance + " SP" + servicePack;
                }
                int mainEsd = servicePack / 10;
                int subEsd = servicePack % 10;
                String esdStr = Integer.toString(mainEsd);
                if (subEsd > 0) {
                    esdStr = mainEsd + "." + subEsd;
                }
                return major + "." + minor + "." + maintenance + " ESD#" + esdStr;
            }
            if (maintenance == 0) {
                return major + "." + minor + " SP" + servicePack;
            }
            return major + "." + minor + "." + maintenance + " SP" + servicePack;
        }
        int major = version / 1000;
        int minor = (version - major * 1000) / 100;
        int maintenance = (version - (major * 1000 + minor * 100)) / 10;
        int rollup = version - (major * 1000 + minor * 100 + maintenance * 10);
        if (rollup == 0) {
            return major + "." + minor + "." + maintenance;
        }
        return major + "." + minor + "." + maintenance + " ESD#" + rollup;
    }

    public static int versionIntPart(int version, int part) {
        if (version > 100000000) {
            int baseVer = version / 100000;
            int major = baseVer / 100;
            int minor = baseVer % 100 / 10;
            int maintenance = baseVer % 10;
            int servicePack = version % 100000 / 100;
            int patchLevel = version % 100;
            switch (part) {
                case 1: {
                    return major;
                }
                case 2: {
                    return minor;
                }
                case 3: {
                    return maintenance;
                }
                case 4: {
                    return servicePack;
                }
                case 5: {
                    return servicePack;
                }
                case 6: {
                    return patchLevel;
                }
            }
            return -1;
        }
        if (version > 1000000) {
            int major = version / 100000;
            int minor = (version - major * 100000) / 10000;
            int maintenance = (version - (major * 100000 + minor * 10000)) / 1000;
            int servicePack = version - (major * 100000 + minor * 10000 + maintenance * 1000);
            switch (part) {
                case 1: {
                    return major;
                }
                case 2: {
                    return minor;
                }
                case 3: {
                    return maintenance;
                }
                case 4: {
                    return servicePack;
                }
                case 5: {
                    return servicePack;
                }
                case 6: {
                    return 0;
                }
            }
            return -1;
        }
        int major = version / 1000;
        int minor = (version - major * 1000) / 100;
        int maintenance = (version - (major * 1000 + minor * 100)) / 10;
        int rollup = version - (major * 1000 + minor * 100 + maintenance * 10);
        switch (part) {
            case 1: {
                return major;
            }
            case 2: {
                return minor;
            }
            case 3: {
                return maintenance;
            }
            case 4: {
                return rollup;
            }
            case 5: {
                return rollup;
            }
            case 6: {
                return 0;
            }
        }
        return -1;
    }

    private static int fixVersionOverflow(int type, int version) {
        if (version < 0) {
            return 0;
        }
        if (type == 4) {
            if (version < 1000) {
                return version;
            }
            if (version >= 1000) {
                return 999;
            }
        }
        if (type == 5) {
            if (version < 1000) {
                return version;
            }
            if (version >= 1000) {
                return 999;
            }
        }
        if (type == 6) {
            if (version < 100) {
                return version;
            }
            if (version >= 100) {
                return 99;
            }
        }
        return version;
    }

    public static int sybVersionStringToNumber(String versionStr) {
        int patchLevel;
        int servicePack;
        int maint;
        int minor;
        int major;
        block36: {
            major = 0;
            minor = 0;
            maint = 0;
            servicePack = 0;
            patchLevel = 0;
            String[] aseVersionParts = versionStr.split("/");
            if (aseVersionParts.length > 0) {
                String aseVersionNumberStr = null;
                String aseEsdStr = null;
                String servivePackStr = null;
                String patchLevelStr = null;
                int aseVersionNumberStrArrayPos = -1;
                int aseEsdStrArrayPos = -1;
                for (int i = 0; i < aseVersionParts.length; ++i) {
                    if (aseVersionParts[i].matches("^[0-9][0-9][.][0-9].*") && aseVersionNumberStr == null) {
                        aseVersionNumberStr = aseVersionParts[i];
                        aseVersionNumberStrArrayPos = i;
                    }
                    if (aseVersionParts[i].indexOf("ESD#") > 0 && aseEsdStr == null) {
                        aseEsdStr = aseVersionParts[i];
                        aseEsdStrArrayPos = i;
                    }
                    if (aseVersionParts[i].matches(".* SP[0-9].*") && servivePackStr == null) {
                        servivePackStr = aseVersionParts[i];
                    }
                    if (!aseVersionParts[i].matches(".* PL[0-9].*") || patchLevelStr != null) continue;
                    patchLevelStr = aseVersionParts[i];
                }
                if (aseVersionNumberStr == null) {
                    _logger.warn((Object)("There ASE version string seems to be faulty, can't find any '##.#' in the version number string '" + versionStr + "'."));
                    return 0;
                }
                String[] aseVersionNumberParts = aseVersionNumberStr.split("\\.");
                if (aseVersionNumberParts.length > 1) {
                    try {
                        int end;
                        int start;
                        String versionPart = null;
                        if (aseVersionNumberParts.length >= 1) {
                            versionPart = aseVersionNumberParts[0].trim();
                            major = Ver.fixVersionOverflow(1, Integer.parseInt(versionPart));
                        }
                        if (aseVersionNumberParts.length >= 2) {
                            versionPart = aseVersionNumberParts[1].trim().substring(0, 1);
                            minor = Ver.fixVersionOverflow(2, Integer.parseInt(versionPart));
                        }
                        if (aseVersionNumberParts.length >= 3) {
                            versionPart = aseVersionNumberParts[2].trim().substring(0, 1);
                            maint = Ver.fixVersionOverflow(3, Integer.parseInt(versionPart));
                        }
                        if (aseVersionNumberParts.length >= 4 && aseVersionNumberStrArrayPos != aseEsdStrArrayPos) {
                            versionPart = aseVersionNumberParts[3].trim();
                            servicePack = Ver.fixVersionOverflow(4, Integer.parseInt(versionPart));
                        } else if (aseEsdStr != null) {
                            int esdEnd;
                            int subEsdStart = -1;
                            int subEsdEnd = -1;
                            int esdStart = aseEsdStr.indexOf("ESD#");
                            if (esdStart >= 0) {
                                esdStart += "ESD#".length();
                            }
                            for (esdEnd = esdStart; esdEnd < aseEsdStr.length(); ++esdEnd) {
                                if (Character.isDigit(aseEsdStr.charAt(esdEnd))) continue;
                                if (aseEsdStr.charAt(esdEnd) != '.') break;
                                for (subEsdEnd = subEsdStart = esdEnd + 1; subEsdEnd < aseEsdStr.length() && Character.isDigit(aseEsdStr.charAt(subEsdEnd)); ++subEsdEnd) {
                                }
                                break;
                            }
                            if (esdStart != -1) {
                                try {
                                    versionPart = aseEsdStr.trim().substring(esdStart, esdEnd);
                                    servicePack = Ver.fixVersionOverflow(5, Integer.parseInt(versionPart));
                                }
                                catch (RuntimeException e) {
                                    _logger.warn((Object)("Problems converting some part(s) of the ESD# in the version string '" + aseVersionNumberStr + "' into a number. ESD# string was '" + versionPart + "'. The version number will be set to " + Ver.ver(major, minor, maint, servicePack, patchLevel)));
                                }
                            }
                            if (subEsdStart != -1) {
                                try {
                                    versionPart = aseEsdStr.trim().substring(subEsdStart, subEsdEnd);
                                    patchLevel = Ver.fixVersionOverflow(6, Integer.parseInt(versionPart));
                                }
                                catch (RuntimeException e) {
                                    _logger.warn((Object)("Problems converting some part(s) of the ESD# in the version string '" + aseVersionNumberStr + "' into a number. ESD# string was '" + versionPart + "'. The version number will be set to " + Ver.ver(major, minor, maint, servicePack, patchLevel)));
                                }
                            }
                        }
                        if (servivePackStr != null) {
                            start = servivePackStr.indexOf(" SP");
                            if (start >= 0) {
                                start += " SP".length();
                            }
                            for (end = start; end < servivePackStr.length() && Character.isDigit(servivePackStr.charAt(end)); ++end) {
                            }
                            if (start != -1) {
                                try {
                                    versionPart = servivePackStr.trim().substring(start, end);
                                    servicePack = Ver.fixVersionOverflow(5, Integer.parseInt(versionPart));
                                }
                                catch (RuntimeException e) {
                                    _logger.warn((Object)("Problems converting some part(s) of the SP (ServicePack) in the version string '" + aseVersionNumberStr + "' into a number. Service Pack string was '" + versionPart + "'. The version number will be set to " + Ver.ver(major, minor, maint, servicePack, patchLevel)));
                                }
                            }
                        }
                        if (patchLevelStr == null) break block36;
                        start = patchLevelStr.indexOf(" PL");
                        if (start >= 0) {
                            start += " PL".length();
                        }
                        for (end = start; end < patchLevelStr.length() && Character.isDigit(patchLevelStr.charAt(end)); ++end) {
                        }
                        if (start == -1) break block36;
                        try {
                            versionPart = patchLevelStr.trim().substring(start, end);
                            patchLevel = Ver.fixVersionOverflow(6, Integer.parseInt(versionPart));
                        }
                        catch (RuntimeException e) {
                            _logger.warn((Object)("Problems converting some part(s) of the SP (ServicePack) in the version string '" + aseVersionNumberStr + "' into a number. Service Pack string was '" + versionPart + "'. The version number will be set to " + Ver.ver(major, minor, maint, servicePack, patchLevel)));
                        }
                    }
                    catch (RuntimeException e) {
                        _logger.warn((Object)("Problems converting some part(s) of the version string '" + aseVersionNumberStr + "' into a number. The version number will be set to " + Ver.ver(major, minor, maint, servicePack, patchLevel)));
                    }
                } else {
                    _logger.warn((Object)("There ASE version string seems to be faulty, can't find any '.' in the version number subsection '" + aseVersionNumberStr + "'."));
                }
            } else {
                _logger.warn((Object)("There ASE version string seems to be faulty, can't find any / in the string '" + versionStr + "'."));
            }
        }
        return Ver.ver(major, minor, maint, servicePack, patchLevel);
    }

    public static void main(String[] args) {
        int version = 0;
        version = 125000300;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 125400100;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 0x77977AA;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 157000420;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 157000000;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 157010000;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 157010200;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 157015000;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 157016000;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 157005000;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 157005100;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 157006000;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 160000000;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 160000001;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 160000100;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 160000101;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 161200101;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 999999999;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        System.out.println("----------------------------------------------------------------------------------");
        version = Ver.ver(12, 5, 4, 10, 2);
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = Ver.ver(15, 7, 0, 100);
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = Ver.ver(15, 7, 0, 101);
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = Ver.ver(16, 0);
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = Ver.ver(16, 0, 0, 0, 1);
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = Ver.ver(16, 0, 0, 1);
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = Ver.ver(16, 0, 0, 1, 1);
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        System.out.println("----------------------------------------------------------------------------------");
        version = Ver.ver(12, 5, 4, 10, 2);
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = Ver.ver(15, 7, 0, 51, 0);
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = Ver.ver(15, 7, 0, 101, 0);
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = Ver.ver(44, 5, 6, 777, 88);
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        System.out.println("----------------------------------------------------------------------------------");
        version = 1250030;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 1254010;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 1570042;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 1570000;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 1570100;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 1570120;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 1570150;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 1570160;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 1570050;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 1570051;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        version = 1570060;
        System.out.println(version + " = " + Ver.versionIntToStr(version));
        System.out.println("----------------------------------------------------------------------------------");
        Ver.testVersion(Ver.ver(12, 5, 0, 1, 1), "12.5.0 ESD#1.1");
        Ver.testVersion(Ver.ver(12, 5, 0, 3), "Adaptive Server Enterprise/12.5.0.3/EBF XXXX ESD#4/...");
        Ver.testVersion(Ver.ver(12, 5, 0, 10), "Adaptive Server Enterprise/12.5.0.10/...");
        Ver.testVersion(Ver.ver(12, 5, 4, 1), "Adaptive Server Enterprise/12.5.4/EBF XXXX SMP ESD#1 /...");
        Ver.testVersion(Ver.ver(12, 5, 4, 11), "Adaptive Server Enterprise/12.5.4/EBF XXXX SMP ESD#11/...");
        Ver.testVersion(Ver.ver(15, 5, 0, 1, 5), "15.5.0 ESD#1.5");
        Ver.testVersion(Ver.ver(15, 0, 2, 5), "Adaptive Server Enterprise/15.0.2/EBF XXXX SMP ESD#5 /...");
        Ver.testVersion(Ver.ver(15, 0, 3, 4), "Adaptive Server Enterprise/15.0.3/EBF XXXX SMP ESD#4 /...");
        Ver.testVersion(Ver.ver(15, 0, 3, 4, 2), "Adaptive Server Enterprise/15.0.3/EBF XXXX SMP ESD#4.2 /...");
        Ver.testVersion(Ver.ver(15, 7, 0, 4), "Adaptive Server Enterprise/15.7.0/EBF XXXX SMP ESD#4 /...");
        Ver.testVersion(Ver.ver(15, 7, 0, 4, 2), "Adaptive Server Enterprise/15.7.0/EBF XXXX SMP ESD#4.2 /...");
        Ver.testVersion(Ver.ver(15, 7, 0, 100), "Adaptive Server Enterprise/15.7/EBF XXXX SMP SP100 /...");
        Ver.testVersion(Ver.ver(15, 7, 0, 101), "Adaptive Server Enterprise/15.7/EBF XXXX SMP SP101 /...");
        Ver.testVersion(Ver.ver(15, 7, 0, 111), "Adaptive Server Enterprise/15.7/EBF XXXX SMP SP111 /...");
        Ver.testVersion(Ver.ver(15, 7, 0, 200), "Adaptive Server Enterprise/15.7/EBF XXXX SMP SP200 /...");
        Ver.testVersion(Ver.ver(15, 7, 0, 999), "Adaptive Server Enterprise/15.7/EBF XXXX SMP SP2000 /...");
        Ver.testVersion(Ver.ver(15, 7, 1, 100), "Adaptive Server Enterprise/15.7.1/EBF XXXX SMP SP100 /...");
        Ver.testVersion(Ver.ver(15, 7, 0, 50), "Adaptive Server Enterprise/15.7.0/EBF XXXX SMP SP50 /...");
        Ver.testVersion(Ver.ver(15, 7, 0, 51), "Adaptive Server Enterprise/15.7.0/EBF XXXX SMP SP51 /...");
        Ver.testVersion(Ver.ver(16, 0), "Adaptive Server Enterprise/16.0/EBF XXXX SMP /...");
        Ver.testVersion(Ver.ver(16, 0, 0, 0, 1), "Adaptive Server Enterprise/16.0/EBF XXXX SMP PL1 /...");
        Ver.testVersion(Ver.ver(16, 0, 0, 0, 1), "Adaptive Server Enterprise/16.0/EBF XXXX SMP PL01 /...");
        Ver.testVersion(Ver.ver(16, 0, 0, 1), "Adaptive Server Enterprise/16.0/EBF XXXX SMP SP1 /...");
        Ver.testVersion(Ver.ver(16, 0, 0, 1), "Adaptive Server Enterprise/16.0/EBF XXXX SMP SP01 /...");
        Ver.testVersion(Ver.ver(16, 0, 0, 1, 1), "Adaptive Server Enterprise/16.0/EBF XXXX SMP SP1 PL1/...");
        Ver.testVersion(Ver.ver(16, 0, 0, 1, 1), "Adaptive Server Enterprise/16.0/EBF XXXX SMP SP01 PL01/...");
        Ver.testVersion(Ver.ver(16, 0, 1, 1, 1), "Adaptive Server Enterprise/16.0.1/EBF XXXX SMP SP1 PL1/...");
        Ver.testVersion(Ver.ver(16, 0, 1, 1, 1), "Adaptive Server Enterprise/16.0.1/EBF XXXX SMP SP01 PL01/...");
        Ver.testVersion(Ver.ver(16, 1, 0, 1, 1), "Adaptive Server Enterprise/16.1/EBF XXXX SMP SP01 PL01/...");
        Ver.testVersion(Ver.ver(16, 0), "Adaptive Server Enterprise/16.0/EBF XXXX SMP /...");
        Ver.testVersion(Ver.ver(16, 0, 0, 0, 1), "Adaptive Server Enterprise/16.0 PL1/EBF XXXX SMP /...");
        Ver.testVersion(Ver.ver(16, 0, 0, 0, 1), "Adaptive Server Enterprise/16.0 PL01 /EBF XXXX SMP /...");
        Ver.testVersion(Ver.ver(16, 0, 0, 1), "Adaptive Server Enterprise/16.0 SP1 /EBF XXXX SMP /...");
        Ver.testVersion(Ver.ver(16, 0, 0, 1), "Adaptive Server Enterprise/16.0 SP01/EBF XXXX SMP /...");
        Ver.testVersion(Ver.ver(16, 0, 0, 1, 1), "Adaptive Server Enterprise/16.0 SP1 PL1/EBF XXXX SMP/...");
        Ver.testVersion(Ver.ver(16, 0, 0, 1, 1), "Adaptive Server Enterprise/16.0 SP01 PL01/EBF XXXX SMP /...");
        Ver.testVersion(Ver.ver(16, 0, 1, 1, 1), "Adaptive Server Enterprise/16.0.1 SP1 PL1/EBF XXXX SMP /...");
        Ver.testVersion(Ver.ver(16, 0, 1, 1, 1), "Adaptive Server Enterprise/16.0.1 SP01 PL01/EBF XXXX SMP /...");
        Ver.testVersion(Ver.ver(16, 1, 0, 1, 1), "Adaptive Server Enterprise/16.1 SP01 PL01/EBF XXXX SMP /...");
        Ver.testVersion(Ver.ver(16, 0, 0, 0, 0), "Adaptive Server Enterprise/16.0/EBF 22385 SMP/P/X64/Windows Server/asecepheus/3530/64-bit/FBO/Sun Feb 16 06:52:50 2014");
        Ver.testVersion(Ver.ver(16, 0, 0, 0, 1), "Adaptive Server Enterprise/16.0 GA PL01/EBF 22544 SMP/P/x86_64/Enterprise Linux/ase160sp00pl01/3523/64-bit/FBO/Tue Apr 15 13:24:31 2014");
    }

    private static boolean testVersion(int expectedIntVer, String verStr) {
        int version = Ver.sybVersionStringToNumber(verStr);
        if (version != expectedIntVer) {
            System.out.println("FAILED: version=" + version + ", expectedVersion=" + expectedIntVer + ", VersionStr='" + verStr + "'.");
            return false;
        }
        System.out.println("OK    : version=" + version + ", expectedVersion=" + expectedIntVer + ", VersionStr='" + verStr + "'.");
        return true;
    }
}

