/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.exceptions.jdbc40.SQLClientInfoException;
import java.sql.ClientInfoStatus;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;

public class ClientInfo {
    private final Properties m_properties = new Properties();
    private final HashSet m_unsetProperties = new HashSet();
    boolean m_hasChanged = false;

    public static ClientInfo setClientInfo(Object ci, Properties props) throws java.sql.SQLClientInfoException {
        ClientInfo erg = ci == null ? new ClientInfo() : (ClientInfo)ci;
        erg.parseProperties(props);
        return erg;
    }

    public static Properties getClientInfo(Object ci) {
        if (ci == null) {
            return new Properties();
        }
        return ((ClientInfo)ci).getProperties();
    }

    public static String getClientInfo(Object ci, String name) {
        if (ci == null) {
            return null;
        }
        return ((ClientInfo)ci).getProperties().getProperty(name, null);
    }

    public static ClientInfo setClientInfo(Object ci, String name, String value) throws java.sql.SQLClientInfoException {
        ClientInfo erg = ci == null ? new ClientInfo() : (ClientInfo)ci;
        if (!erg.setProperty(name, value)) {
            HashMap<String, ClientInfoStatus> failureProps = new HashMap<String, ClientInfoStatus>();
            failureProps.put(name.toUpperCase(), ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            throw SQLClientInfoException.createException(failureProps);
        }
        return erg;
    }

    public void parseProperties(Properties props) throws java.sql.SQLClientInfoException {
        if (props == null || props.isEmpty()) {
            Enumeration<Object> e = this.m_properties.keys();
            while (e.hasMoreElements()) {
                String key = ((String)e.nextElement()).toUpperCase();
                if (null == this.m_properties.remove(key)) continue;
                this.m_unsetProperties.add(key);
            }
            this.m_hasChanged = true;
            return;
        }
        Enumeration<Object> e = props.keys();
        HashMap<String, ClientInfoStatus> failureProps = null;
        while (e.hasMoreElements()) {
            String val;
            String key = ((String)e.nextElement()).toUpperCase();
            if (this.setProperty(key, val = props.getProperty(key))) continue;
            if (failureProps == null) {
                failureProps = new HashMap<String, ClientInfoStatus>();
            }
            failureProps.put(key, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
        }
        if (failureProps != null) {
            throw SQLClientInfoException.createException(failureProps);
        }
    }

    private boolean setProperty(String key, String value) throws java.sql.SQLClientInfoException {
        if (key == null) {
            HashMap<String, ClientInfoStatus> failureProps = new HashMap<String, ClientInfoStatus>();
            failureProps.put(key, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            throw SQLClientInfoException.createException(failureProps);
        }
        key = key.toUpperCase();
        if (value == null) {
            if (null != this.m_properties.remove(key)) {
                this.m_unsetProperties.add(key);
            }
        } else {
            this.m_properties.put(key, value);
        }
        this.m_hasChanged = true;
        return true;
    }

    public Properties getProperties() {
        Properties erg = new Properties();
        Enumeration<Object> e = this.m_properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)this.m_properties.get(key);
            erg.put(key, val);
        }
        return erg;
    }

    public static HashSet getUnsetProperties(Object ci) {
        if (ci == null) {
            return new HashSet();
        }
        ClientInfo cli = (ClientInfo)ci;
        return cli.m_unsetProperties;
    }

    static boolean hasChanged(Object ci) {
        if (ci == null) {
            return false;
        }
        return ((ClientInfo)ci).m_hasChanged;
    }

    static void setHasChanged(Object ci, boolean val) {
        if (ci == null) {
            return;
        }
        ((ClientInfo)ci).m_hasChanged = val;
    }
}

