/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.DataFormatDescription;
import java.sql.SQLException;

class FetchChunk {
    static final int TYPE_FIRST = 1;
    static final int TYPE_LAST = 2;
    static final int TYPE_ABSOLUTE_UP = 3;
    static final int TYPE_ABSOLUTE_DOWN = 4;
    static final int TYPE_RELATIVE_UP = 5;
    static final int TYPE_RELATIVE_DOWN = 6;
    private DataPart replyData;
    private DataPart currentRecord;
    private int type;
    private int start_index;
    private int end_index;
    private int currentOffset;
    private boolean first;
    private boolean last;
    private int recordSize;
    private int chunkSize;
    private int rowsInResultSet;
    private boolean wasLastPart;
    private boolean isResultSetClosedOnServerSide;

    FetchChunk(int type, int absoluteStartRow, DataPart dataPart, int recordSize, int maxRows, int rowsInResultSet, DataFormatDescription dfd) throws SQLException {
        this.type = type;
        this.recordSize = recordSize;
        this.rowsInResultSet = rowsInResultSet;
        this.replyData = dataPart;
        if (this.replyData == null) {
            throw SQLExceptionSapDB.generateSQLException("error.packet.fetchnodatapart");
        }
        this.wasLastPart = dataPart.isLastPart();
        this.isResultSetClosedOnServerSide = dataPart.isResultSetClosedOnServer();
        this.chunkSize = this.replyData.getArgCount();
        this.currentOffset = 0;
        this.currentRecord = this.replyData.getRecordPointer();
        this.currentRecord.moveRecordPointer(this.currentOffset, this.recordSize);
        if (absoluteStartRow > 0) {
            this.start_index = absoluteStartRow;
            this.end_index = absoluteStartRow + this.chunkSize - 1;
        } else if (rowsInResultSet != -1) {
            this.start_index = absoluteStartRow < 0 ? rowsInResultSet + absoluteStartRow + 1 : rowsInResultSet - absoluteStartRow + this.chunkSize;
            this.end_index = this.start_index + this.chunkSize - 1;
        } else {
            this.start_index = absoluteStartRow;
            this.end_index = absoluteStartRow + this.chunkSize - 1;
        }
        this.determineFlags(maxRows);
    }

    private void determineFlags(int maxRows) {
        if (this.wasLastPart) {
            switch (this.type) {
                case 1: 
                case 2: 
                case 6: {
                    this.first = true;
                    this.last = true;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.last = true;
                }
            }
        }
        if (this.start_index == 1) {
            this.first = true;
        }
        if (this.end_index == -1) {
            this.last = true;
        }
        if (maxRows != 0 && this.isForward() && this.end_index >= maxRows) {
            this.end_index = maxRows;
            this.chunkSize = maxRows + 1 - this.start_index;
            this.last = true;
        }
    }

    DataPart getCurrentRecord() {
        return this.currentRecord;
    }

    boolean containsRow(int row) {
        if (this.start_index <= row && this.end_index >= row) {
            return true;
        }
        if (this.isForward() && this.last && row < 0) {
            return row >= this.start_index - this.end_index - 1;
        }
        if (!this.isForward() && this.first && row > 0) {
            return row <= this.end_index - this.start_index + 1;
        }
        if (this.rowsInResultSet != -1 && (this.start_index < 0 && row > 0 || this.start_index > 0 && row < 0)) {
            int inverted_row = row > 0 ? row - this.rowsInResultSet - 1 : row + this.rowsInResultSet + 1;
            return this.start_index <= inverted_row && this.end_index >= inverted_row;
        }
        return false;
    }

    boolean move(int relativepos) throws SQLException {
        if (this.currentOffset + relativepos < 0 || this.currentOffset + relativepos >= this.chunkSize) {
            return false;
        }
        this.unsafeMove(relativepos);
        return true;
    }

    private void unsafeMove(int relativepos) throws SQLException {
        this.currentOffset += relativepos;
        this.currentRecord.moveRecordPointer(relativepos, this.recordSize);
    }

    boolean setRow(int row) throws SQLException {
        if (this.start_index <= row && this.end_index >= row) {
            this.unsafeMove(row - this.start_index - this.currentOffset);
            return true;
        }
        if (this.isForward() && this.last && row < 0 && row >= this.start_index - this.end_index - 1) {
            this.unsafeMove(this.end_index + row + 1 - this.start_index - this.currentOffset);
            return true;
        }
        if (!this.isForward() && this.first && row > 0 && row <= this.end_index - this.start_index + 1) {
            this.unsafeMove(row - 1 - this.currentOffset);
        }
        if (this.rowsInResultSet != -1 && (this.start_index < 0 && row > 0 || this.start_index > 0 && row < 0)) {
            int inverted_row = row > 0 ? row - this.rowsInResultSet - 1 : row + this.rowsInResultSet + 1;
            return this.setRow(inverted_row);
        }
        return false;
    }

    void moveToUpperBound() throws SQLException {
        int relativepos = this.chunkSize - this.currentOffset - 1;
        this.currentRecord.moveRecordPointer(relativepos, this.recordSize);
        this.currentOffset = this.chunkSize - 1;
    }

    boolean isAtUpperBound() {
        return this.currentOffset == this.chunkSize - 1;
    }

    boolean isAtLowerBound() {
        return this.currentOffset == 0;
    }

    DataPart getReplyData() {
        return this.replyData;
    }

    public boolean isFirst() {
        return this.first;
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }

    public int size() {
        return this.chunkSize;
    }

    public boolean positionedAtFirst() {
        return this.first && this.currentOffset == 0;
    }

    public boolean positionedAtLast() {
        return this.last && this.currentOffset == this.chunkSize - 1;
    }

    int getLogicalPos() {
        return this.start_index + this.currentOffset;
    }

    int pos() {
        return this.currentOffset;
    }

    int getKernelPos() {
        switch (this.type) {
            case 2: 
            case 4: 
            case 5: {
                return this.start_index;
            }
        }
        return this.end_index;
    }

    boolean isForward() {
        return this.type == 1 || this.type == 3 || this.type == 5;
    }

    void setRowsInResultSet(int rows) {
        this.rowsInResultSet = rows;
    }

    int getStart() {
        return this.start_index;
    }

    int getEnd() {
        return this.end_index;
    }

    public String traceString() {
        StringBuffer result = new StringBuffer();
        result.append("FETCH CHUNK [\n");
        switch (this.type) {
            case 1: {
                result.append("  TYPE           : FIRST\n");
                break;
            }
            case 2: {
                result.append("  TYPE           : LAST\n");
                break;
            }
            case 3: {
                result.append("  TYPE           : ABSOLUTE (UP)\n");
                break;
            }
            case 4: {
                result.append("  TYPE           : ABSOLUTE (DOWN)\n");
                break;
            }
            case 5: {
                result.append("  TYPE           : RELATIVE (UP)\n");
                break;
            }
            case 6: {
                result.append("  TYPE           : RELATIVE (DOWN)\n");
                break;
            }
            default: {
                result.append("  TYPE           : UNKNOWN\n");
            }
        }
        result.append("  START INDEX    : " + this.start_index + "\n");
        result.append("  END INDEX      : " + this.end_index + "\n");
        result.append("  CURRENT        : " + this.currentOffset + "\n");
        result.append("  FIRST          : " + (this.first ? "TRUE" : "FALSE") + "\n");
        result.append("  LAST           : " + (this.last ? "TRUE" : "FALSE") + "\n");
        result.append("  RECORD SIZE    : " + this.recordSize + "\n");
        result.append("  SIZE           : " + this.chunkSize + "\n");
        result.append("  ROWS IN RESULT : " + this.rowsInResultSet + "\n");
        result.append("]");
        return result.toString();
    }

    public boolean isWasLastPart() {
        return this.wasLastPart;
    }

    public boolean isResultSetClosedOnServerSide() {
        return this.isResultSetClosedOnServerSide;
    }
}

