/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.RequestPacket;
import com.sap.db.jdbc.translators.Putval;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.util.MemIndirection;
import com.sap.db.util.StructuredMem;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public abstract class DataPart
extends MemIndirection {
    private static final int maxArgCount = Short.MAX_VALUE;
    protected int argCount = 0;
    protected int extent = 0;
    protected int massExtent = 0;
    StructuredMem originalMem;
    RequestPacket requestPacket;
    boolean isLastPart = false;
    boolean isResultSetClosedOnServer = false;

    DataPart(StructuredMem rawMem, RequestPacket requestPacket) {
        super(rawMem);
        this.originalMem = rawMem.getPointer(0);
        this.requestPacket = requestPacket;
    }

    DataPart(StructuredMem rawMem, boolean lastPart, boolean isResultSetClosed) {
        super(rawMem);
        this.originalMem = rawMem.getPointer(0);
        this.requestPacket = null;
        this.isLastPart = lastPart;
        this.isResultSetClosedOnServer = isResultSetClosed;
    }

    public abstract void addArg(int var1, int var2);

    public void close() {
        this.requestPacket.closePart(this.massExtent + this.extent, this.argCount);
    }

    public void closeArrayPart(int rows) {
        this.requestPacket.closePart(this.massExtent + this.extent, rows);
    }

    protected int getMaxDataSize() {
        int len = this.size() - this.extent;
        len -= len % 8;
        return len;
    }

    public boolean hasRoomFor(int recordSize) {
        return this.argCount < Short.MAX_VALUE && this.size() - this.extent > recordSize;
    }

    public int getExtent() {
        return this.extent;
    }

    public int increaseExtent(int val) {
        return this.extent += val;
    }

    public void setFirstPart() {
        this.requestPacket.addPartAttribute(4);
    }

    public void setLastPart() {
        this.requestPacket.addPartAttribute(1);
    }

    public void moveRecordBase() {
        this.moveBase(this.extent);
        this.massExtent += this.extent;
        this.extent = 0;
    }

    public void markEmptyStream(StructuredMem descriptorMark) {
        descriptorMark.putInt1(2, 27);
        descriptorMark.putInt4(this.massExtent + this.extent + 1, 32);
        descriptorMark.putInt4(0, 36);
    }

    public abstract boolean fillWithOMSReader(Reader var1, int var2) throws SQLException;

    public abstract boolean fillWithProcedureReader(Reader var1, short var2) throws SQLException;

    public abstract void addRow(int var1);

    public abstract int putNull(int var1, int var2, int var3);

    public abstract void putDefault(int var1, int var2);

    public abstract StructuredMem putDescriptor(int var1, byte[] var2);

    public abstract void fillWithOMSReturnCode(int var1) throws SQLException;

    public abstract boolean fillWithOMSStream(InputStream var1, boolean var2) throws SQLException;

    public abstract boolean fillWithProcedureStream(InputStream var1, short var2) throws SQLException;

    public boolean fillWithStream(InputStream stream, StructuredMem descriptorMark, Putval putval, boolean isExecute) throws SQLException {
        int maxDataSize = this.getMaxDataSize();
        int options = 2;
        if (maxDataSize <= 1) {
            options = 0;
            descriptorMark.putInt1(options, isExecute ? 0 : 7);
            return false;
        }
        int dataStart = this.extent;
        byte[] readBuf = new byte[4096];
        boolean streamExhausted = false;
        try {
            while (!streamExhausted && maxDataSize > 0) {
                int bytesRead = stream.read(readBuf, 0, Math.min(maxDataSize, 4096));
                if (bytesRead == -1) {
                    streamExhausted = true;
                    continue;
                }
                this.mem.putBytes(readBuf, this.extent, bytesRead);
                this.extent += bytesRead;
                maxDataSize -= bytesRead;
            }
        }
        catch (IOException exc) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", exc.getMessage());
        }
        if (streamExhausted) {
            options = (byte)(options + 4);
        }
        descriptorMark.putInt1(options, isExecute ? 0 : 7);
        if (isExecute) {
            descriptorMark.putInt4(this.massExtent + dataStart + 1, 5);
        } else {
            descriptorMark.putInt8(0L, 8);
        }
        descriptorMark.putInt4(this.extent - dataStart, isExecute ? 1 : 16);
        putval.markRequestedChunk(this.getPointer(dataStart), this.extent - dataStart);
        return streamExhausted;
    }

    public boolean fillWithReader(Reader reader, StructuredMem descriptorMark, Putval putval, boolean isExecute) throws SQLException {
        int maxDataSize = this.getMaxDataSize();
        int options = 2;
        if (maxDataSize <= 1) {
            options = 0;
            descriptorMark.putInt1(options, isExecute ? 0 : 7);
            return false;
        }
        int dataStart = this.extent;
        char[] readBuf = new char[4096];
        boolean streamExhausted = false;
        try {
            while (!streamExhausted && maxDataSize > 3) {
                int charsRead = reader.read(readBuf, 0, Math.min(maxDataSize / 3, 4096));
                if (charsRead == -1) {
                    streamExhausted = true;
                    continue;
                }
                int bytesWritten = this.mem.putBigUnicode(readBuf, this.extent, charsRead);
                this.extent += bytesWritten;
                maxDataSize -= bytesWritten;
            }
        }
        catch (IOException exc) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", exc.getMessage());
        }
        if (streamExhausted) {
            options = (byte)(options + 4);
        }
        descriptorMark.putInt1(options, isExecute ? 0 : 7);
        if (isExecute) {
            descriptorMark.putInt4(this.massExtent + dataStart + 1, 5);
        } else {
            descriptorMark.putInt8(0L, 8);
        }
        descriptorMark.putInt4(this.extent - dataStart, isExecute ? 1 : 16);
        putval.markRequestedChunk(this.getPointer(dataStart), this.extent - dataStart);
        return streamExhausted;
    }

    public int getArgCount() {
        return this.argCount;
    }

    public abstract void moveRecordPointer(int var1, int var2) throws SQLException;

    public abstract DataPart getRecordPointer() throws SQLException;

    public abstract boolean isNull(SQLParamController var1, int var2) throws SQLException;

    public abstract int checkDefineByte(SQLParamController var1, DataPart var2, int var3);

    public abstract byte getBoolean(int var1) throws SQLException;

    public abstract byte[] getBytesFillUp(int var1, int var2);

    public abstract StructuredMem getLOBDataPointer(int var1);

    public StructuredMem getRawData() {
        return this.mem;
    }

    public boolean isLastPart() {
        return this.isLastPart;
    }

    public boolean isEmptyPart() {
        return this.argCount == 0;
    }

    public boolean isResultSetClosedOnServer() {
        return this.isResultSetClosedOnServer;
    }

    public void resetCurrentRecord() {
        this.extent = 0;
    }
}

