/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.exceptions.InternalReconnectException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.exceptions.StreamIOException;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.packet.ReplyPacket;
import com.sap.db.jdbc.packet.RequestPacket;
import com.sap.db.jdbc.translators.DBTechTranslator;
import com.sap.db.rte.comm.JdbcCommunication;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.StructuredBytes;
import com.sap.db.util.StructuredMem;
import com.sap.db.vsp00.LongDesc;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public abstract class AbstractGetval {
    protected ConnectionSapDB connection;
    protected byte[] descriptor;
    protected StructuredMem streamBuffer;
    protected int itemsInBuffer;
    protected boolean atEnd;
    protected boolean firstChunk = true;
    protected boolean lastChunk = false;
    protected long currentChunkStartPos;
    protected long currentChunkEndPos;
    protected long longPosition = 0L;
    protected long totalLOBCharacterLength = -1L;
    protected long totalLOBByteLength = -1L;
    protected boolean packetEncodingUnicode = false;
    protected boolean isUnicodeColumn = false;
    protected int sourceType = 0;
    protected long m_sessionContextCount = 0L;
    protected JdbcCommunication m_session;
    static final int maxLOBReadChunkSize = 200000;
    static final int firstChunkCapacity = 1024;
    boolean m_lastChunkWasEmpty = false;

    protected void isValid() throws SQLException {
        if (this.m_sessionContextCount != this.m_session.getSessionContextCount()) {
            throw SQLExceptionSapDB.generateSQLException("error.objectisclosed", this);
        }
    }

    protected abstract boolean isReReadEnabled();

    public AbstractGetval(ConnectionSapDB connection, byte[] descr, StructuredMem dataPart, int itemSize, JdbcCommunication session) {
        this.connection = connection;
        this.m_sessionContextCount = session.getSessionContextCount();
        this.m_session = session;
        this.sourceType = descr[0];
        this.itemsInBuffer = DBTechTranslator.dataFormat.getInt4(descr, 28);
        this.totalLOBCharacterLength = DBTechTranslator.dataFormat.getInt8(descr, 4);
        this.totalLOBByteLength = DBTechTranslator.dataFormat.getInt8(descr, 12);
        this.streamBuffer = dataPart;
        this.descriptor = new byte[8];
        System.arraycopy(descr, 20, this.descriptor, 0, 8);
        this.lastChunk = (descr[1] & 4) != 0;
        this.currentChunkStartPos = 0L;
        this.currentChunkEndPos = 1023L;
    }

    protected boolean nextChunk() throws StreamIOException {
        try {
            ReplyPacket replyPacket;
            this.isValid();
            if (this.lastChunk || this.atEnd) {
                this.atEnd = true;
                return false;
            }
            this.firstChunk = false;
            JdbcCommunication session = this.getSession();
            RequestPacket requestPacket = this.connection.getRequestPacket(session);
            DataPart longpart = requestPacket.initReadLOB(this.connection.getAutoCommit(), this.connection.getStatementContext());
            longpart.putBytes(this.descriptor, 0, this.descriptor.length);
            longpart.putInt8(this.longPosition + 1L, 8);
            longpart.putInt4(200000, 16);
            longpart.addArg(0, 24);
            longpart.close();
            try {
                replyPacket = this.connection.execute(requestPacket, this, 2, session, false);
            }
            catch (SQLExceptionSapDB sqlExc) {
                throw new StreamIOException(sqlExc);
            }
            if (replyPacket.findPart(18) == -1) {
                throw new StreamIOException(SQLExceptionSapDB.generateSQLException("error.longdata.expected"));
            }
            int dataPos = replyPacket.getPartDataPos();
            byte options = replyPacket.getInt1(dataPos + 8);
            this.itemsInBuffer = replyPacket.getInt4(dataPos + 9);
            if (this.itemsInBuffer == 0) {
                if (this.m_lastChunkWasEmpty) {
                    throw new StreamIOException(SQLExceptionSapDB.generateSQLException("error.stream.emptyChunk"));
                }
                this.m_lastChunkWasEmpty = true;
            } else {
                this.m_lastChunkWasEmpty = false;
            }
            if (this.isReReadEnabled() && this.longPosition == 0L && this.totalLOBByteLength >= 1024L) {
                this.itemsInBuffer = 1024;
            }
            this.streamBuffer = replyPacket.getPointer(dataPos + 16);
            boolean bl = this.lastChunk = (options & 4) != 0;
            if (this.isReReadEnabled() && this.longPosition == 0L && this.totalLOBByteLength > 1024L) {
                this.lastChunk = this.lastChunk && this.longPosition + (long)this.itemsInBuffer == this.totalLOBByteLength;
            }
            this.currentChunkStartPos = this.longPosition;
            this.currentChunkEndPos = this.longPosition + (long)(this.longPosition == 0L ? 1024 : this.itemsInBuffer) - 1L;
            return true;
        }
        catch (InternalReconnectException e) {
            throw new StreamIOException(SQLExceptionSapDB.generateSQLException("error.objectisclosed", this));
        }
        catch (SQLException exc) {
            throw new StreamIOException(exc);
        }
    }

    protected long getPositionGetval(byte[] pattern, long start) throws SQLException {
        int patternLen;
        if (start > Integer.MAX_VALUE || start < 1L) {
            throw SQLExceptionSapDB.generateSQLException("error.illegalparam", new Integer(2), new Long(start));
        }
        if (pattern == null || (patternLen = pattern.length) == 0) {
            throw SQLExceptionSapDB.generateSQLException("error.illegalparam", new Integer(1), new Integer(pattern == null ? 0 : pattern.length));
        }
        JdbcCommunication session = this.getSession();
        RequestPacket requestPacket = this.connection.getRequestPacket(session);
        DataPart longpart = requestPacket.initReadLOB(this.connection.getAutoCommit(), this.connection.getStatementContext());
        longpart.putInt1(0, 0);
        longpart.putBytes(this.descriptor, 1);
        longpart.putInt4((int)start, 21);
        longpart.putInt1(11, 28);
        longpart.putInt4(42, 33);
        longpart.putBytes(pattern, 41, patternLen);
        longpart.putInt4(patternLen, 37);
        longpart.addArg(1, 41 + patternLen);
        longpart.close();
        ReplyPacket replyPacket = this.connection.execute(requestPacket, this, 2, session, false);
        StructuredBytes descBytes = new StructuredBytes(this.getDescriptorFromReply(replyPacket));
        long result = -1L;
        if (descBytes.getInt1(27) != 3) {
            result = descBytes.getInt4(20);
        }
        int oldInternPos = LongDesc.getInternPos(this.descriptor);
        descBytes.putInt4(oldInternPos, 20);
        descBytes.putInt1(this.descriptor[27], 27);
        this.descriptor = descBytes.bytes();
        return result;
    }

    public long lengthInBytes() throws SQLException {
        return this.totalLOBByteLength;
    }

    public long lengthInCharacters() throws SQLException {
        return this.totalLOBCharacterLength;
    }

    private byte[] getDescriptorFromReply(ReplyPacket replyPacket) throws SQLException {
        if (replyPacket.findPart(255) == -1) {
            throw SQLExceptionSapDB.generateSQLException("error.longdata.expected");
        }
        int dataPos = replyPacket.getPartDataPos();
        return replyPacket.getDataBytes(dataPos, 41);
    }

    abstract InputStream getAsciiStream() throws SQLException;

    abstract InputStream getBinaryStream() throws SQLException;

    abstract Reader getCharacterStream() throws SQLException;

    public long position(String searchstr, long start) throws SQLException {
        this.isValid();
        byte[] pattern = this.transSearchPattern(searchstr);
        return this.getPositionGetval(pattern, start);
    }

    public final int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.setbytes.notimplemented"));
    }

    public final int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.setbytes.notimplemented"));
    }

    public final OutputStream setBinaryStream(long pos) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.setbinarystream.notimplemented"));
    }

    public final void truncate(long len) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.truncate.notimplemented"));
    }

    public final int setString(long pos, String str) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.setstring.notimplemented"));
    }

    public final int setString(long pos, String str, int offset, int len) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.setstring.notimplemented"));
    }

    public final OutputStream setAsciiStream(long pos) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.setasciistream.notimplemented"));
    }

    public final Writer setCharacterStream(long pos) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.setcharacterstream.notimplemented"));
    }

    public long position(Clob lob, long start) throws SQLException {
        this.isValid();
        String val = lob.getSubString(1L, (int)lob.length());
        return this.position(val, start);
    }

    public final ConnectionSapDB getConnection() {
        return this.connection;
    }

    public byte[] getDescriptor() {
        return this.descriptor;
    }

    public abstract long length() throws SQLException;

    public abstract byte[] transSearchPattern(String var1);

    public void free() throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "GetvalLob", "free");
    }

    public boolean isUnicodeColumn() {
        return this.isUnicodeColumn;
    }

    protected abstract boolean isBinary();

    private JdbcCommunication getSession() throws SQLException {
        this.connection.handleTransaction(this.m_session, false);
        return this.m_session;
    }
}

