/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.BinaryDataTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;

class BooleanTranslator
extends BinaryDataTranslator {
    BooleanTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    public BigDecimal getBigDecimal(SQLParamController controller, DataPart mem) throws SQLException {
        if (this.isNull(controller, mem)) {
            return null;
        }
        boolean isTrue = this.getBoolean(controller, mem);
        BigDecimal result = isTrue ? BigDecimal.valueOf(1L) : BigDecimal.valueOf(0L);
        return result;
    }

    public boolean getBoolean(SQLParamController controller, DataPart mem) throws SQLException {
        boolean result = false;
        if (!this.isNull(controller, mem)) {
            byte raw = mem.getBoolean(this.bufpos_output);
            result = raw != 0;
        }
        return result;
    }

    public byte getByte(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getBoolean(controller, mem) ? (byte)1 : 0;
    }

    public float getFloat(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getBoolean(controller, mem) ? 1.0f : 0.0f;
    }

    public double getDouble(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getBoolean(controller, mem) ? 1.0 : 0.0;
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        if (this.isNull(controller, mem)) {
            return null;
        }
        boolean isTrue = this.getBoolean(controller, mem);
        Boolean result = isTrue ? Boolean.TRUE : Boolean.FALSE;
        return result;
    }

    public int getInt(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getBoolean(controller, mem) ? 1 : 0;
    }

    public long getLong(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getBoolean(controller, mem) ? 1L : 0L;
    }

    public short getShort(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getBoolean(controller, mem) ? (short)1 : 0;
    }

    public Object transBooleanForInput(boolean newValue) {
        byte[] result = new byte[]{newValue ? (byte)1 : 0};
        return result;
    }

    public Object transSpecificForInput(Object obj) throws SQLException {
        Object result = null;
        if (obj instanceof Boolean) {
            result = this.transBooleanForInput((Boolean)obj);
        } else if (obj instanceof Number) {
            int numValue = ((Number)obj).intValue();
            result = numValue == 0 ? this.transBooleanForInput(false) : this.transBooleanForInput(true);
        } else if (obj instanceof Date) {
            throw this.newSetException(obj.getClass().getName());
        }
        return result;
    }

    public Object transStringForInput(String val) {
        if (val == null) {
            return null;
        }
        Boolean boolObj = new Boolean(val);
        return this.transBooleanForInput(boolObj);
    }
}

