/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.DBTechTranslator;
import com.sap.db.jdbc.translators.LegacyTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.util.StringUtil;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

abstract class CharDataTranslator
extends LegacyTranslator {
    protected static final byte[] HighTime_C = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51};
    protected static final byte[] LowTime_C = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49};

    protected CharDataTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
        this.characterDatatypePostfix = " ASCII";
    }

    public boolean isCaseSensitive() {
        return true;
    }

    protected int putSpecific(DataPart dataPart, Object data) throws SQLException {
        byte[] bytes = StringUtil.bytes_iso8859_1(data.toString());
        this.checkFieldLimits(bytes.length);
        return dataPart.putStringBytes(bytes, this.bufpos_input, this.physicalLength - 1);
    }

    public Date getDate(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        String strValue = this.getString(controller, mem);
        if (strValue == null) {
            return null;
        }
        try {
            Date dateValue = Date.valueOf(strValue);
            if (cal == null) {
                return dateValue;
            }
            cal.setTime(dateValue);
            return DBTechTranslator.CalendarUtil.getDateFromCalendar(cal);
        }
        catch (IllegalArgumentException dateExc) {
            try {
                Timestamp tsValue = Timestamp.valueOf(strValue);
                if (cal == null) {
                    return new Date(tsValue.getTime());
                }
                cal.setTime(tsValue);
                return DBTechTranslator.CalendarUtil.getDateFromCalendar(cal);
            }
            catch (IllegalArgumentException tsExc) {
                throw this.newParseException(strValue, "Date");
            }
        }
    }

    public Time getTime(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        String strValue = this.getString(controller, mem);
        if (strValue == null) {
            return null;
        }
        try {
            Time dateValue = Time.valueOf(strValue);
            if (cal == null) {
                return dateValue;
            }
            cal.setTime(dateValue);
            return DBTechTranslator.CalendarUtil.getTimeFromCalendar(cal);
        }
        catch (IllegalArgumentException dateExc) {
            try {
                Timestamp dateValue = Timestamp.valueOf(strValue);
                if (cal == null) {
                    return new Time(dateValue.getTime());
                }
                cal.setTime(dateValue);
                return DBTechTranslator.CalendarUtil.getTimeFromCalendar(cal);
            }
            catch (IllegalArgumentException dateExc2) {
                throw this.newParseException(strValue, "Time");
            }
        }
    }

    public Timestamp getTimestamp(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        String strValue = this.getString(controller, mem);
        if (strValue == null) {
            return null;
        }
        try {
            Timestamp ts = Timestamp.valueOf(strValue);
            if (cal == null) {
                return ts;
            }
            cal.setTime(ts);
            return DBTechTranslator.CalendarUtil.getTimestampFromCalendar(cal, ts.getNanos());
        }
        catch (IllegalArgumentException tsExc) {
            try {
                Date dateValue = Date.valueOf(strValue);
                if (cal == null) {
                    return new Timestamp(dateValue.getTime());
                }
                cal.setTime(dateValue);
                return DBTechTranslator.CalendarUtil.getTimestampFromCalendar(cal, 0);
            }
            catch (IllegalArgumentException dateExc) {
                throw this.newParseException(strValue, "Timestamp");
            }
        }
    }

    public int getFieldLength(DataPart mem) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getFieldLength", this.getClass().toString());
    }
}

