/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.comunication.protocol.DataType;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.DBProcParameterInfo;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.Putval;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.util.DataFormatFullSwap;
import com.sap.db.util.StructuredMem;
import com.sap.db.util.VDNNumber;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class DBTechTranslator {
    protected int logicalLength;
    protected int physicalLength;
    protected int bufpos_input;
    protected int bufpos_output;
    protected byte mode;
    protected byte ioType;
    protected byte dataType;
    protected int fieldOffset;
    protected int idxInGroup;
    protected boolean writeAllowed = false;
    protected boolean isReadOnly = false;
    protected boolean isAutoIncrement = false;
    protected String characterDatatypePostfix = "";
    private String tableName;
    private String schemaName;
    private String columnName;
    private String columnLabel;
    public static final int nullDefineByte = 1;
    public static final int specialNullValueDefineByte = 2;
    public static final int unknownDefineByte = -1;
    static final int IGREG = 588829;
    static final int ZEITENWENDE = 1721424;
    static final int JGREG = 2299161;
    public static final String DefaultValue = "DefaultValue";
    public static DataFormatFullSwap dataFormat = new DataFormatFullSwap();

    protected DBTechTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncre) {
        this.mode = (byte)mode;
        this.ioType = (byte)ioType;
        this.dataType = (byte)dataType;
        this.logicalLength = len;
        this.physicalLength = ioLen;
        this.bufpos_input = bufpos_in;
        this.bufpos_output = bufpos_out;
    }

    public void allowWrites() {
        this.writeAllowed = true;
    }

    public InputStream getAsciiStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        throw this.newGetException("AsciiStream");
    }

    public BigDecimal getBigDecimal(int scale, SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("BigDecimal");
    }

    public BigDecimal getBigDecimal(SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("BigDecimal");
    }

    public InputStream getBinaryStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        throw this.newGetException("BinaryStream");
    }

    public Blob getBlob(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        throw this.newGetException("Blob");
    }

    public boolean getBoolean(SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("boolean");
    }

    public int getOutputBufpos() {
        return this.bufpos_output;
    }

    public byte getByte(SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("byte");
    }

    public byte[] getBytes(SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("byte []");
    }

    public String getCatalogName() {
        return "";
    }

    public Reader getCharacterStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        throw this.newGetException("CharacterStream");
    }

    public Clob getClob(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        throw this.newGetException("Clob");
    }

    public int getColIndex() {
        return this.bufpos_output - 1;
    }

    public String getColumnClassName() {
        if (Driver.isJDBC40) {
            return DataType.sqlTypeJavaClassMap40[this.dataType];
        }
        return DataType.sqlTypeJavaClassMap[this.dataType];
    }

    public int getColumnDisplaySize() {
        switch (this.dataType) {
            case 14: {
                return new Date(0L).toString().length();
            }
            case 15: {
                return new Time(0L).toString().length();
            }
            case 16: {
                return new Timestamp(0L).toString().length();
            }
        }
        return this.logicalLength;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getColumnType() {
        return DataType.getSQLType(this.dataType);
    }

    public String getColumnTypeName() {
        return DataType.getSQLTypeName(this.dataType);
    }

    public Date getDate(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        throw this.newGetException("Date");
    }

    public double getDouble(SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("double");
    }

    public float getFloat(SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("float");
    }

    public int getInt(SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("int");
    }

    public long getLong(SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("long");
    }

    public Reader getNCharacterStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        throw this.newGetException("NCharacterStream");
    }

    public NClob getNClob(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        throw this.newGetException("NClob");
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("Object");
    }

    public int getPhysicalLength() {
        return this.physicalLength;
    }

    public int getPrecision() {
        return this.logicalLength;
    }

    public Putval getPutvalObject() {
        return null;
    }

    public int getScale() {
        return 0;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public short getShort(SQLParamController controllerc, DataPart mem) throws SQLException {
        throw this.newGetException("short");
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        Object rawResult = this.getObject(controller, mem);
        String result = rawResult == null ? null : rawResult.toString();
        return result;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Time getTime(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        throw this.newGetException("Time");
    }

    public Timestamp getTimestamp(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        throw this.newGetException("Timestamp");
    }

    public InputStream getUnicodeStream(SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("UnicodeStream");
    }

    public int getParameterMode() {
        return this.ioType;
    }

    public boolean isAutoIncrement() {
        return this.isAutoIncrement;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public boolean isCurrency() {
        return false;
    }

    public boolean isDefinitelyWritable() {
        return false;
    }

    public boolean isInput() {
        return this.ioType != 4;
    }

    public boolean isOutput() {
        return this.ioType != 1;
    }

    public boolean isLongKind() {
        return DataType.isLongKind(this.dataType);
    }

    public boolean isNull(SQLParamController controller, DataPart mem) throws SQLException {
        return mem.isNull(controller, this.bufpos_output);
    }

    public int checkDefineByte(SQLParamController controller, DataPart mem) {
        return mem.checkDefineByte(controller, mem, this.bufpos_output);
    }

    public int isNullable() {
        int result = (this.mode & 1) != 0 ? 0 : ((this.mode & 2) != 0 ? 1 : 2);
        return result;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isSearchable() {
        return true;
    }

    public boolean isSigned() {
        return DataType.isSigned(this.dataType);
    }

    public boolean isWritable() {
        return this.writeAllowed;
    }

    public boolean put(DataPart dataPart, Object data) throws SQLException {
        boolean erg = true;
        if (this.ioType != 4) {
            if (data == null) {
                erg = -1 != dataPart.putNull(this.bufpos_input, this.physicalLength - 1, this.dataType);
            } else {
                erg = -1 != this.putSpecific(dataPart, data);
                dataPart.addArg(this.bufpos_input, this.physicalLength - 1);
            }
        }
        return erg;
    }

    public void putProcOutput(DataPart dataPart, Object data) throws SQLException {
        if (this.ioType != 1) {
            if (data == null) {
                dataPart.putNull(this.bufpos_input, this.physicalLength - 1, this.dataType);
            } else if (data == DefaultValue) {
                dataPart.putDefault(this.bufpos_input, this.physicalLength - 1);
            } else {
                this.putSpecific(dataPart, data);
                dataPart.addArg(this.bufpos_input, this.physicalLength - 1);
            }
        }
    }

    protected abstract int putSpecific(DataPart var1, Object var2) throws SQLException;

    public void setColName(String atableName, String aschemaName, String acolumnName, String acolumnDisplayName) {
        this.tableName = atableName;
        this.schemaName = aschemaName;
        this.columnName = acolumnName;
        this.columnLabel = acolumnDisplayName;
    }

    public Object transBooleanForInput(boolean val) throws SQLException {
        byte[] value = new byte[]{28, val ? (byte)1 : 0};
        return value;
    }

    public Object transByteForInput(byte val) throws SQLException {
        byte[] value = new byte[]{12, 1, val};
        return value;
    }

    public Object transBytesForInput(byte[] val) throws SQLException {
        if (val == null) {
            return null;
        }
        byte[] value = dataFormat.putBytes(val);
        return value;
    }

    public Object transDoubleForInput(double val) throws SQLException {
        byte[] value = new byte[9];
        value[0] = 7;
        dataFormat.putDouble(value, val, 1);
        return value;
    }

    public Object transFloatForInput(float val) throws SQLException {
        byte[] value = new byte[5];
        value[0] = 6;
        dataFormat.putFloat(value, val, 1);
        return value;
    }

    public Object transIntForInput(int val) throws SQLException {
        byte[] value = new byte[5];
        value[0] = 3;
        dataFormat.putInt4(value, val, 1);
        return value;
    }

    public Object transLongForInput(long val) throws SQLException {
        byte[] value = new byte[9];
        value[0] = 4;
        dataFormat.putInt8(value, val, 1);
        return value;
    }

    public Object transShortForInput(short val) throws SQLException {
        byte[] value = new byte[3];
        value[0] = 2;
        dataFormat.putInt2(value, val, 1);
        return value;
    }

    public Object transStringForInput(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        byte[] value = dataFormat.putString(val);
        return value;
    }

    public Object transAsciiStreamForInput(InputStream stream, long length) throws SQLException {
        if (stream == null) {
            return null;
        }
        throw this.newSetException("java.io.InputStream");
    }

    public Object transBigDecimalForInput(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            return null;
        }
        byte[] value = new byte[17];
        value[0] = 5;
        dataFormat.putBigDecimal(value, bigDecimal, 1);
        return value;
    }

    public Object transBinaryStreamForInput(InputStream stream, long length) throws SQLException {
        if (stream == null) {
            return null;
        }
        throw this.newSetException("java.io.InputStream");
    }

    public Object transBlobForInput(Blob blob, ConnectionSapDB conn) throws SQLException {
        if (blob == null) {
            return null;
        }
        throw this.newSetException("java.sql.Blob");
    }

    public Object transCharacterStreamForInput(Reader stream, long length) throws SQLException {
        if (stream == null) {
            return null;
        }
        throw this.newSetException("java.io.Reader");
    }

    public Object transClobForInput(Clob clob, ConnectionSapDB conn) throws SQLException {
        if (clob == null) {
            return null;
        }
        throw this.newSetException("java.sql.Clob");
    }

    public Object transDateForInput(Date val, Calendar cal) throws SQLException {
        if (val == null) {
            return null;
        }
        cal.setTime(val);
        byte[] value = new byte[5];
        value[0] = 14;
        int date_null = 32768;
        short year = (short)(cal.get(1) | date_null);
        byte month = (byte)cal.get(2);
        byte day = (byte)cal.get(5);
        dataFormat.putInt2(value, year, 1);
        dataFormat.putInt1(value, month, 3);
        dataFormat.putInt1(value, day, 4);
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Object transObjectForInput(Object val) throws SQLException {
        if (val == null) {
            return null;
        }
        Object result = this.transSpecificForInput(val);
        if (result != null) {
            return result;
        }
        if (val instanceof String) {
            result = this.transStringForInput((String)val);
        }
        if (val instanceof BigDecimal) {
            return this.transStringForInput(VDNNumber.bigDecimal2PlainString((BigDecimal)val));
        }
        Class<?> clazz = val.getClass();
        if (!clazz.isArray()) return this.transStringForInput(val.toString());
        String clazzName = clazz.getName();
        if (clazzName.equals("[B")) {
            return this.transBytesForInput((byte[])val);
        }
        if (!clazzName.equals("[C")) throw this.newSetException(clazzName);
        return this.transStringForInput(new String((char[])val));
    }

    protected abstract Object transSpecificForInput(Object var1) throws SQLException;

    public Object transTimeForInput(Time val, Calendar cal) throws SQLException {
        if (val == null) {
            return null;
        }
        cal.setTime(val);
        byte[] value = new byte[5];
        value[0] = 15;
        int time_null = 128;
        byte hour = (byte)(cal.get(11) | time_null);
        byte minute = (byte)cal.get(12);
        short milli = (short)(cal.get(13) * 1000);
        dataFormat.putInt1(value, hour, 1);
        dataFormat.putInt1(value, minute, 2);
        dataFormat.putInt2(value, milli, 3);
        return value;
    }

    public Object transTimestampForInput(Timestamp val, Calendar cal) throws SQLException {
        if (val == null) {
            return null;
        }
        byte[] value = new byte[9];
        cal.setTime(val);
        value[0] = 16;
        int date_null = 32768;
        int time_null = 128;
        short year = (short)(cal.get(1) | date_null);
        byte month = (byte)cal.get(2);
        byte day = (byte)cal.get(5);
        byte hour = (byte)(cal.get(11) | time_null);
        byte minute = (byte)cal.get(12);
        short milli = (short)(cal.get(13) * 1000 + val.getNanos() / 1000000);
        dataFormat.putInt2(value, year, 1);
        dataFormat.putInt1(value, month, 3);
        dataFormat.putInt1(value, day, 4);
        dataFormat.putInt1(value, hour, 5);
        dataFormat.putInt1(value, minute, 6);
        dataFormat.putInt2(value, milli, 7);
        return value;
    }

    public Object transUnicodeStreamForInput(InputStream stream) throws SQLException {
        if (stream == null) {
            return null;
        }
        throw this.newSetException("java.io.InputStream");
    }

    public Object cloneObjectForBatch(Object object) {
        return object;
    }

    protected SQLException newGetException(String requestedType) {
        return SQLExceptionSapDB.generateSQLException("error.conversion.sqljava", this.getColumnTypeName(), requestedType);
    }

    protected SQLException newSetException(String requestedType) {
        return SQLExceptionSapDB.generateSQLException("error.conversion.javasql", requestedType, this.getColumnTypeName());
    }

    protected SQLException newParseException(String data, String requestedType) {
        if (requestedType == null) {
            requestedType = this.getColumnTypeName();
        }
        return SQLExceptionSapDB.generateSQLException("error.conversion.data", data, requestedType);
    }

    public byte bigDecimal2Byte(BigDecimal bd) throws SQLException {
        if (bd == null) {
            return 0;
        }
        return (byte)bd.intValue();
    }

    public double bigDecimal2Double(BigDecimal bd) throws SQLException {
        if (bd == null) {
            return 0.0;
        }
        return bd.doubleValue();
    }

    public float bigDecimal2Float(BigDecimal bd) throws SQLException {
        if (bd == null) {
            return 0.0f;
        }
        return (float)bd.doubleValue();
    }

    public int bigDecimal2Int(BigDecimal bd) throws SQLException {
        if (bd == null) {
            return 0;
        }
        return bd.intValue();
    }

    public long bigDecimal2Long(BigDecimal bd) throws SQLException {
        if (bd == null) {
            return 0L;
        }
        return bd.longValue();
    }

    public short bigDecimal2Short(BigDecimal bd) throws SQLException {
        if (bd == null) {
            return 0;
        }
        return (short)bd.intValue();
    }

    protected void checkFieldLimits(int byteLength) throws SQLException {
    }

    protected boolean isUnicodeColumn() {
        return false;
    }

    public boolean isStreamKind() {
        return false;
    }

    public void setProcParamInfo(DBProcParameterInfo info) throws SQLException {
    }

    public int getDataTypeCode() {
        return this.dataType;
    }

    public int getFieldOffset() {
        return this.fieldOffset;
    }

    public int getIdxInGroup() {
        return this.idxInGroup;
    }

    public void setFieldOffset(int offset) {
        this.fieldOffset = offset;
    }

    public void setIdxInGroup(int index) {
        this.idxInGroup = index;
    }

    static class CalendarUtil {
        CalendarUtil() {
        }

        static Timestamp getTimestampFromCalendar(Calendar cal, int nano) {
            Timestamp ts = new Timestamp(cal.getTime().getTime());
            ts.setNanos(nano);
            return ts;
        }

        static Time getTimeFromCalendar(Calendar cal) {
            return new Time(cal.getTime().getTime());
        }

        static Date getDateFromCalendar(Calendar cal) {
            return new Date(cal.getTime().getTime());
        }
    }
}

