/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.DBTechTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.jdbc.translators.TimeTranslator;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class SecondTimeTranslator
extends TimeTranslator {
    public SecondTimeTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    public SecondTimeTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out) {
        this(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, false, false);
    }

    public Object transTimeForInput(Time val, Calendar cal) throws SQLException {
        if (val == null) {
            return null;
        }
        cal.setTime(val);
        byte[] value = new byte[5];
        value[0] = 64;
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        dataFormat.putInt4(value, hour * 60 * 60 + minute * 60 + second + 1, 1);
        return value;
    }

    public Timestamp getTimestamp(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        Timestamp result = null;
        if (!this.isNull(controller, mem)) {
            int secondtime = mem.getInt4(this.bufpos_output) - 1;
            int seconds = secondtime % 60;
            int minutes = (secondtime /= 60) % 60;
            int hours = secondtime / 60;
            long now = System.currentTimeMillis() / 86400000L * 86400000L;
            result = new Timestamp(now);
            result.setHours(hours);
            result.setMinutes(minutes);
            result.setSeconds(seconds);
            if (cal != null) {
                cal.clear();
                cal.setTimeInMillis(result.getTime());
                result = DBTechTranslator.CalendarUtil.getTimestampFromCalendar(cal, 0);
            }
        }
        return result;
    }

    public Time getTime(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        Time result = null;
        if (!this.isNull(controller, mem)) {
            int secondtime = mem.getInt4(this.bufpos_output) - 1;
            int seconds = secondtime % 60;
            int minutes = (secondtime /= 60) % 60;
            int hours = secondtime / 60;
            result = new Time(hours, minutes, seconds);
            if (cal != null) {
                cal.clear();
                cal.setTimeInMillis(result.getTime());
                result = DBTechTranslator.CalendarUtil.getTimeFromCalendar(cal);
            }
        }
        return result;
    }

    public int getPrecision() {
        return 8;
    }

    public int getColumnDisplaySize() {
        return 8;
    }
}

