/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.DBTechTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.jdbc.translators.TimeTranslator;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class Time2Translator
extends TimeTranslator {
    public Time2Translator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    public Time2Translator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out);
    }

    public Time getTime(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        Time result = null;
        if (!this.isNull(controller, mem)) {
            byte[] buffer = mem.getBytes(this.bufpos_output, this.physicalLength - 1);
            int millisec = buffer[2] & 0xFF | buffer[3] << 8 & 0xFF00;
            byte min = buffer[1];
            int hour = buffer[0];
            if ((hour & 0x80) != 0) {
                hour &= 0x7F;
            }
            if (cal == null) {
                result = new Time(hour, min, millisec / 1000);
            } else {
                cal.clear();
                cal.set(1970, 0, 1, hour, min, millisec / 1000);
                result = DBTechTranslator.CalendarUtil.getTimeFromCalendar(cal);
            }
        }
        return result;
    }

    public Timestamp getTimestamp(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        Time timeValue = this.getTime(controller, mem, cal);
        if (timeValue == null) {
            return null;
        }
        Timestamp result = new Timestamp(System.currentTimeMillis());
        result.setHours(timeValue.getHours());
        result.setMinutes(timeValue.getMinutes());
        result.setSeconds(timeValue.getSeconds());
        result.setNanos(0);
        return result;
    }
}

