/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.DBTechTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.jdbc.translators.VariableDataLengthTranslator;
import com.sap.db.util.StructuredMem;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class TimestampTranslator
extends VariableDataLengthTranslator {
    TimestampTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    protected TimestampTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out) {
        this(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, false, false);
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        switch (this.dataType) {
            case 14: {
                return this.getDate(controller, mem, null);
            }
            case 15: {
                return this.getTime(controller, mem, null);
            }
        }
        return this.getTimestamp(controller, mem, null);
    }

    public Date getDate(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        Timestamp timestamp = this.getTimestamp(controller, mem, cal);
        Date result = null;
        if (timestamp != null) {
            result = new Date(timestamp.getTime());
        }
        return result;
    }

    public Time getTime(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        Timestamp timestamp = this.getTimestamp(controller, mem, cal);
        Time result = null;
        if (timestamp != null) {
            result = new Time(timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds());
        }
        return result;
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        switch (this.dataType) {
            case 14: 
            case 63: {
                Date timestamp = this.getDate(controller, mem, null);
                if (timestamp == null) {
                    return null;
                }
                return TimestampTranslator.Date2String(timestamp);
            }
            case 15: 
            case 64: {
                Time timestamp = this.getTime(controller, mem, null);
                if (timestamp == null) {
                    return null;
                }
                return TimestampTranslator.Time2String(timestamp);
            }
        }
        Timestamp timestamp = this.getTimestamp(controller, mem, null);
        if (timestamp == null) {
            return null;
        }
        return TimestampTranslator.Timestamp2String(timestamp);
    }

    public static String Timestamp2String(Timestamp ts) {
        int absyear;
        int year = ts.getYear() + 1900;
        int month = ts.getMonth() + 1;
        int day = ts.getDate();
        int hour = ts.getHours();
        int minute = ts.getMinutes();
        int second = ts.getSeconds();
        int nanos = ts.getNanos();
        StringBuffer buf = new StringBuffer(29);
        if (year < 0) {
            absyear = -1 * year;
            buf.append('-');
        } else {
            absyear = year;
        }
        if (absyear < 10) {
            buf.append("000");
        } else if (absyear < 100) {
            buf.append("00");
        } else if (absyear < 1000) {
            buf.append("0");
        }
        buf.append(absyear);
        buf.append('-');
        if (month < 10) {
            buf.append("0");
        }
        buf.append(month);
        buf.append('-');
        if (day < 10) {
            buf.append("0");
        }
        buf.append(day);
        buf.append(' ');
        if (hour < 10) {
            buf.append("0");
        }
        buf.append(hour);
        buf.append(':');
        if (minute < 10) {
            buf.append("0");
        }
        buf.append(minute);
        buf.append(':');
        if (second < 10) {
            buf.append("0");
        }
        buf.append(second);
        buf.append('.');
        if (nanos < 10) {
            buf.append("00000000");
        } else if (nanos < 100) {
            buf.append("0000000");
        } else if (nanos < 1000) {
            buf.append("000000");
        } else if (nanos < 10000) {
            buf.append("00000");
        } else if (nanos < 100000) {
            buf.append("0000");
        } else if (nanos < 1000000) {
            buf.append("000");
        } else if (nanos < 10000000) {
            buf.append("00");
        } else if (nanos < 100000000) {
            buf.append("0");
        }
        buf.append(nanos);
        return buf.toString();
    }

    static String Date2String(Date ts) {
        int absyear;
        int year = ts.getYear() + 1900;
        int month = ts.getMonth() + 1;
        int day = ts.getDate();
        StringBuffer buf = new StringBuffer(29);
        if (year < 0) {
            absyear = -1 * year;
            buf.append('-');
        } else {
            absyear = year;
        }
        if (absyear < 10) {
            buf.append("000");
        } else if (absyear < 100) {
            buf.append("00");
        } else if (absyear < 1000) {
            buf.append("0");
        }
        buf.append(absyear);
        buf.append('-');
        if (month < 10) {
            buf.append("0");
        }
        buf.append(month);
        buf.append('-');
        if (day < 10) {
            buf.append("0");
        }
        buf.append(day);
        return buf.toString();
    }

    static String Time2String(Time ts) {
        int hour = ts.getHours();
        int minute = ts.getMinutes();
        int second = ts.getSeconds();
        StringBuffer buf = new StringBuffer(29);
        if (hour < 10) {
            buf.append("0");
        }
        buf.append(hour);
        buf.append(':');
        if (minute < 10) {
            buf.append("0");
        }
        buf.append(minute);
        buf.append(':');
        if (second < 10) {
            buf.append("0");
        }
        buf.append(second);
        return buf.toString();
    }

    public Timestamp getTimestamp(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        Timestamp result = null;
        if (!this.isNull(controller, mem)) {
            byte[] buffer = mem.getBytes(this.bufpos_output, this.physicalLength - 1);
            int millisec = buffer[6] & 0xFF | buffer[7] << 8 & 0xFF00;
            byte min = buffer[5];
            int hour = buffer[4];
            byte day = buffer[3];
            byte month = buffer[2];
            int year = buffer[0] & 0xFF | buffer[1] << 8 & 0xFF00;
            if ((year & 0x8000) != 0) {
                year &= Short.MAX_VALUE;
            }
            if ((hour & 0x80) != 0) {
                hour &= 0x7F;
            }
            if ((year & 0x4000) != 0) {
                year |= 0x8000;
            }
            if (cal == null) {
                result = new Timestamp(year - 1900, month, day, hour, min, millisec / 1000, millisec % 1000 * 1000000);
            } else {
                cal.clear();
                cal.set(year, month, day, hour, min, millisec / 1000);
                result = DBTechTranslator.CalendarUtil.getTimestampFromCalendar(cal, millisec % 1000 * 1000000);
            }
        }
        return result;
    }

    public Reader getCharacterStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        String asString = this.getString(controller, mem);
        if (asString == null) {
            return null;
        }
        StringReader result = new StringReader(asString);
        return result;
    }

    public InputStream getAsciiStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        String asString = this.getString(controller, mem);
        if (asString == null) {
            return null;
        }
        StringBufferInputStream result = new StringBufferInputStream(asString);
        return result;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Object transSpecificForInput(Object obj) throws SQLException {
        Object result = null;
        if (obj instanceof Timestamp) {
            result = this.transTimestampForInput((Timestamp)obj, Calendar.getInstance());
        } else if (obj instanceof Time) {
            result = this.transTimeForInput((Time)obj, Calendar.getInstance());
        } else if (obj instanceof Date) {
            result = this.transDateForInput((Date)obj, Calendar.getInstance());
        } else if (obj instanceof java.util.Date) {
            java.util.Date utilDate = (java.util.Date)obj;
            result = this.transDateForInput(new Date(utilDate.getTime()), Calendar.getInstance());
        } else if (obj instanceof String) {
            String utilString = (String)obj;
            result = this.transStringForInput(utilString);
        }
        return result;
    }

    public Object transStringForInput(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        try {
            Timestamp dateVal = Timestamp.valueOf(val);
            return this.transTimestampForInput(dateVal, Calendar.getInstance());
        }
        catch (IllegalArgumentException e) {
            return super.transStringForInput(val);
        }
    }

    public Object transCharacterStreamForInput(Reader stream, long length) throws SQLException {
        if (length <= 0L) {
            return null;
        }
        try {
            if (length > Integer.MAX_VALUE) {
                throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", "Streams that size is longer than Integer.MAX_VALUE are not supported");
            }
            char[] ba = new char[(int)length];
            int r = stream.read(ba);
            if ((long)r != length) {
                if (r == -1) {
                    r = 0;
                }
                char[] ba2 = ba;
                ba = new char[r];
                System.arraycopy(ba2, 0, ba, 0, r);
            }
            return this.transStringForInput(new String(ba));
        }
        catch (IOException ioex) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", ioex.getMessage());
        }
    }

    public Object transAsciiStreamForInput(InputStream stream, long length) throws SQLException {
        if (length <= 0L) {
            return null;
        }
        try {
            if (length > Integer.MAX_VALUE) {
                throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", "Streams that size is longer than Integer.MAX_VALUE are not supported");
            }
            byte[] ba = new byte[(int)length];
            int r = stream.read(ba);
            if ((long)r != length) {
                if (r == -1) {
                    r = 0;
                }
                byte[] ba2 = ba;
                ba = new byte[r];
                System.arraycopy(ba2, 0, ba, 0, r);
            }
            return this.transStringForInput(new String(ba));
        }
        catch (IOException ioex) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", ioex.getMessage());
        }
    }

    public int getPrecision() {
        return 23;
    }
}

