/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.AbstractProcedurePutval;
import com.sap.db.jdbc.translators.DBTechTranslator;
import com.sap.db.jdbc.translators.ReaderFilter;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class UnicodeProcedurePutval
extends AbstractProcedurePutval {
    private Reader reader;
    private boolean atBegin;
    private boolean marksupported;
    private long length;

    public UnicodeProcedurePutval(DBTechTranslator translator, char[] buffer) {
        this(translator, new CharArrayReader(buffer), -1L);
    }

    public UnicodeProcedurePutval(DBTechTranslator translator, Reader reader, long length) {
        super(translator);
        if (length <= 0L) {
            this.reader = reader;
            this.length = Integer.MAX_VALUE;
        } else {
            this.reader = new ReaderFilter(reader, length);
            this.length = length;
        }
        this.atBegin = true;
        this.marksupported = this.reader.markSupported();
    }

    public void transferStream(DataPart dataPart, short rowCount) throws SQLException {
        if (rowCount == -2) {
            if (!this.atBegin) {
                if (this.marksupported) {
                    try {
                        this.reader.reset();
                        this.atBegin = true;
                        if (this.length > Integer.MAX_VALUE) {
                            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", "Cannot mark stream since length is bigger than Integer.MAX_VALUE");
                        }
                        this.reader.mark((int)this.length);
                    }
                    catch (IOException ioEx) {
                        throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", ioEx.getMessage());
                    }
                } else {
                    throw SQLExceptionSapDB.generateSQLException("error.reset.stream");
                }
            }
            rowCount = Short.MAX_VALUE;
        } else if (this.atBegin && this.marksupported) {
            try {
                if (this.length > Integer.MAX_VALUE) {
                    throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", "Cannot mark stream since length is bigger than Integer.MAX_VALUE");
                }
                this.reader.mark((int)this.length);
            }
            catch (IOException ioex) {
                throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", ioex.getMessage());
            }
        }
        if (dataPart.fillWithProcedureReader(this.reader, rowCount)) {
            // empty if block
        }
        this.atBegin = false;
    }

    public void closeStream() throws SQLException {
        try {
            this.reader.close();
        }
        catch (IOException ioex) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", ioex.getMessage());
        }
    }
}

