/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbcext;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDBInterface;
import com.sap.db.jdbcext.ConnectionListenerBag;
import com.sap.db.jdbcext.wrapper.Connection;
import java.lang.ref.WeakReference;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.PooledConnection;

public class PooledConnectionSAP
extends ConnectionListenerBag
implements PooledConnection {
    java.sql.Connection physicalConnection;
    WeakReference lastClientConnection;

    protected PooledConnectionSAP(java.sql.Connection physicalConnection) {
        this.physicalConnection = physicalConnection;
        this.lastClientConnection = null;
    }

    private void sendErrorEvent(SQLException sqlEx) {
        super.sendErrorEvent(this, sqlEx);
    }

    private void sendErrorEvent(SQLException sqlEx, PreparedStatement ps) {
        super.sendErrorEvent(this, ps, sqlEx);
    }

    private void sendCloseEvent() {
        super.sendCloseEvent(this);
    }

    private void sendCloseEvent(PreparedStatement ps) {
        super.sendCloseEvent(this, ps);
    }

    private PooledConnectionSAP self() {
        return this;
    }

    public synchronized java.sql.Connection getConnection() throws SQLException {
        Object lastClient = null;
        if (this.lastClientConnection != null) {
            Object t = this.lastClientConnection.get();
            lastClient = t;
            if (t != null) {
                PooledClientConnectionSapDB pcc = lastClient;
                ConnectionSapDB c = null;
                try {
                    c = (ConnectionSapDB)this.physicalConnection;
                }
                catch (ClassCastException ccx) {
                    // empty catch block
                }
                int sz = pcc.statementContainer.size();
                for (int i = 0; i < sz; ++i) {
                    Statement st = (Statement)((WeakReference)pcc.statementContainer.get(i)).get();
                    if (st == null) continue;
                    st.close();
                }
                if (c != null) {
                    c.reinitialize();
                }
                pcc.closed = true;
            }
        }
        PooledClientConnectionSapDB result = new PooledClientConnectionSapDB();
        this.lastClientConnection = new WeakReference<PooledClientConnectionSapDB>(result);
        return result;
    }

    public synchronized void close() throws SQLException {
        this.physicalConnection.close();
    }

    private class PooledClientConnectionSapDB
    extends Connection {
        boolean closed = false;
        ArrayList statementContainer = new ArrayList();

        private PooledClientConnectionSapDB() {
        }

        public java.sql.Connection getPhysicalConnection() {
            return PooledConnectionSAP.this.physicalConnection;
        }

        public void exceptionOccurred(SQLException sqlEx) {
            if (sqlEx instanceof SQLExceptionSapDBInterface) {
                SQLExceptionSapDBInterface sapEx = (SQLExceptionSapDBInterface)((Object)sqlEx);
                if (sapEx.isConnectionReleasing()) {
                    PooledConnectionSAP.this.sendErrorEvent(sqlEx);
                }
            } else {
                PooledConnectionSAP.this.sendErrorEvent(sqlEx);
            }
        }

        public void exceptionOccurred(SQLException sqlEx, PreparedStatement ps) {
            if (sqlEx instanceof SQLExceptionSapDBInterface) {
                SQLExceptionSapDBInterface sapEx = (SQLExceptionSapDBInterface)((Object)sqlEx);
                if (sapEx.isConnectionReleasing()) {
                    PooledConnectionSAP.this.sendErrorEvent(sqlEx, ps);
                }
            } else {
                PooledConnectionSAP.this.sendErrorEvent(sqlEx, ps);
            }
        }

        private ConnectionSapDB getSapDBConnection(java.sql.Connection c) {
            ConnectionSapDB result = null;
            try {
                result = (ConnectionSapDB)PooledConnectionSAP.this.physicalConnection;
                return result;
            }
            catch (ClassCastException ccx) {
                try {
                    com.sap.db.jdbc.trace.log.Connection tc = (com.sap.db.jdbc.trace.log.Connection)PooledConnectionSAP.this.physicalConnection;
                    result = (ConnectionSapDB)tc.getInner();
                    return result;
                }
                catch (ClassCastException ccx2) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws SQLException {
            if (this.closed) {
                return;
            }
            PooledConnectionSAP pooledConnectionSAP = PooledConnectionSAP.this.self();
            synchronized (pooledConnectionSAP) {
                int sz = this.statementContainer.size();
                for (int i = 0; i < sz; ++i) {
                    Statement st = (Statement)((WeakReference)this.statementContainer.get(i)).get();
                    if (st == null) continue;
                    st.close();
                }
                ConnectionSapDB c = this.getSapDBConnection(PooledConnectionSAP.this.physicalConnection);
                if (c != null) {
                    c.reinitialize();
                }
                if (!this.getAutoCommit()) {
                    this.rollback();
                }
                this.closed = true;
                PooledConnectionSAP.this.sendCloseEvent();
            }
        }

        public boolean isClosed() throws SQLException {
            if (this.closed) {
                return true;
            }
            return super.isClosed();
        }

        public void finalize() {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add2StatementContainer(Object obj) {
            ArrayList arrayList = this.statementContainer;
            synchronized (arrayList) {
                this.statementContainer.add(new WeakReference<Object>(obj));
            }
        }

        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            PreparedStatement ps = super.prepareStatement(sql, autoGeneratedKeys);
            this.add2StatementContainer(ps);
            return ps;
        }

        public PreparedStatement prepareStatement(String parm1, int[] parm2) throws SQLException {
            PreparedStatement ps = super.prepareStatement(parm1, parm2);
            this.add2StatementContainer(ps);
            return ps;
        }

        public PreparedStatement prepareStatement(String sql) throws SQLException {
            PreparedStatement ps = super.prepareStatement(sql);
            this.add2StatementContainer(ps);
            return ps;
        }

        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            PreparedStatement ps = super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.add2StatementContainer(ps);
            return ps;
        }

        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            PreparedStatement ps = super.prepareStatement(sql, resultSetType, resultSetConcurrency);
            this.add2StatementContainer(ps);
            return ps;
        }

        public PreparedStatement prepareStatement(String parm1, String[] parm2) throws SQLException {
            PreparedStatement ps = super.prepareStatement(parm1, parm2);
            this.add2StatementContainer(ps);
            return ps;
        }

        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            CallableStatement ps = super.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.add2StatementContainer(ps);
            return ps;
        }

        public CallableStatement prepareCall(String sql) throws SQLException {
            CallableStatement ps = super.prepareCall(sql);
            this.add2StatementContainer(ps);
            return ps;
        }

        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            CallableStatement ps = super.prepareCall(sql, resultSetType, resultSetConcurrency);
            this.add2StatementContainer(ps);
            return ps;
        }

        public Statement createStatement() throws SQLException {
            Statement ps = super.createStatement();
            this.add2StatementContainer(ps);
            return ps;
        }

        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            Statement ps = super.createStatement(resultSetType, resultSetConcurrency);
            this.add2StatementContainer(ps);
            return ps;
        }

        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            Statement ps = super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            this.add2StatementContainer(ps);
            return ps;
        }

        public void sendStatementCloseEvent(PreparedStatement prepStatement) {
            if (Driver.isJDBC40) {
                PooledConnectionSAP.this.sendCloseEvent(prepStatement);
            }
        }
    }
}

