/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.util.StructuredBytes;
import com.sap.db.util.StructuredMem;

public class FullswapMem
extends StructuredBytes {
    public FullswapMem(byte[] data) {
        super(data);
    }

    public FullswapMem(byte[] data, int offset) {
        super(data, offset);
    }

    public FullswapMem(int size) {
        super(size);
    }

    public int getInt2(int offset) {
        int lowerByte = this.data[offset + this.ptrOffs];
        if (lowerByte < 0) {
            lowerByte += 256;
        }
        int result = this.data[offset + this.ptrOffs + 1] * 256 + lowerByte;
        return result;
    }

    public int getInt4(int offset) {
        byte[] d = this.data;
        int result = 0;
        int ofs = offset + this.ptrOffs;
        for (int i = 3; i >= 0; --i) {
            int oneByte = d[ofs + i];
            if (oneByte < 0) {
                oneByte += 256;
            }
            result = result * 256 + oneByte;
        }
        return result;
    }

    public long getInt8(int offset) {
        byte[] d = this.data;
        int ofs = offset + this.ptrOffs;
        long result = 0L;
        for (int i = 7; i >= 0; --i) {
            int oneByte = d[ofs + i];
            if (oneByte < 0) {
                oneByte += 256;
            }
            result = result * 256L + (long)oneByte;
        }
        return result;
    }

    public int putInt2(int value, int offset) {
        int ofs = offset + this.ptrOffs;
        if (this.data.length < ofs + 2) {
            return -1;
        }
        byte[] d = this.data;
        if (value == 0) {
            d[ofs + 1] = 0;
            d[ofs] = 0;
            return 2;
        }
        d[ofs + 1] = (byte)(value >> 8 & 0xFF);
        d[ofs] = (byte)(value & 0xFF);
        return 2;
    }

    public int putInt4(int value, int offset) {
        int ofs = offset + this.ptrOffs;
        if (this.data.length < ofs + 4) {
            return -1;
        }
        byte[] d = this.data;
        if (value == 0) {
            d[ofs + 3] = 0;
            d[ofs + 2] = 0;
            d[ofs + 1] = 0;
            d[ofs] = 0;
            return 4;
        }
        for (int i = 0; i <= 3; ++i) {
            d[ofs + i] = (byte)(value & 0xFF);
            value >>= 8;
        }
        return 4;
    }

    public int putInt8(long value, int offset) {
        int ofs = offset + this.ptrOffs;
        if (this.data.length < ofs + 8) {
            return -1;
        }
        byte[] d = this.data;
        if (value == 0L) {
            d[ofs + 7] = 0;
            d[ofs + 6] = 0;
            d[ofs + 5] = 0;
            d[ofs + 4] = 0;
            d[ofs + 3] = 0;
            d[ofs + 2] = 0;
            d[ofs + 1] = 0;
            d[ofs] = 0;
            return 8;
        }
        for (int i = 0; i <= 7; ++i) {
            d[ofs + i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return 8;
    }

    public StructuredMem getPointer(int offset) {
        return new FullswapMem(this.data, this.ptrOffs + offset);
    }
}

