/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class RawByteReader
extends Reader {
    private InputStream stream;
    private int characterSizeInByte = 1;

    public RawByteReader(InputStream stream, int characterSizeInByte) {
        this.stream = stream;
        this.characterSizeInByte = characterSizeInByte;
    }

    public RawByteReader(InputStream stream) {
        this.stream = stream;
        this.characterSizeInByte = 1;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        try {
            byte[] bbuf = new byte[len * this.characterSizeInByte];
            int result = this.stream.read(bbuf);
            if (result == -1) {
                return -1;
            }
            int readCharCount = result / this.characterSizeInByte;
            int off_i = off;
            if (this.characterSizeInByte == 1) {
                int i = 0;
                while (i < readCharCount) {
                    cbuf[off_i] = (char)bbuf[i];
                    ++i;
                    ++off_i;
                }
            } else {
                for (int i = 0; i < readCharCount; ++i) {
                    cbuf[off_i] = (char)bbuf[2 * i];
                    cbuf[off_i] = (char)(cbuf[off_i] << 8);
                    int n = off_i++;
                    cbuf[n] = (char)(cbuf[n] | bbuf[2 * i + 1] & 0xFF);
                }
            }
            return readCharCount;
        }
        catch (IOException ioEx) {
            throw ioEx;
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public long skip(long n) throws IOException {
        return this.stream.skip(n);
    }

    public boolean markSupported() {
        return this.stream.markSupported();
    }

    public void mark(int readAheadLimit) throws IOException {
        this.stream.mark(readAheadLimit);
    }

    public void reset() throws IOException {
        this.stream.reset();
    }

    public void close() throws IOException {
        this.stream.close();
    }
}

