/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

public class UnicodeUtil {
    public static final int CharWidthC = 2;

    private UnicodeUtil() {
    }

    public static char[] bigUnicode2Chars(byte[] b, int off, int len) {
        char[] result = new char[len / 2];
        int lenInChars = len / 2;
        for (int i = 0; i < lenInChars; ++i) {
            int low;
            int high = b[off + 2 * i];
            if (high < 0) {
                high += 256;
            }
            if ((low = b[off + (2 * i + 1)]) < 0) {
                low += 256;
            }
            int current = (high << 8) + low;
            result[i] = (char)current;
        }
        return result;
    }

    public static char[] bigUnicode2Chars(byte[] b) {
        return UnicodeUtil.bigUnicode2Chars(b, 0, b.length);
    }

    public static byte[] char2BigUnicode(char[] input) {
        byte[] result = new byte[input.length * 2];
        UnicodeUtil.charIntoBytes(input, result, 0);
        return result;
    }

    public static byte[] bytes2BigUnicode(byte[] input) {
        int byteCount = input.length;
        byte[] result = new byte[byteCount * 2];
        for (int i = 0; i < byteCount; ++i) {
            result[i * 2 + 1] = input[i];
        }
        return result;
    }

    public static void charIntoBytes(char[] input, byte[] output, int byteOffset) {
        int charCount = input.length;
        for (int i = 0; i < charCount; ++i) {
            char current = input[i];
            output[i * 2 + byteOffset] = (byte)(current / 256);
            output[i * 2 + byteOffset + 1] = (byte)(current % 256);
        }
    }
}

