/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.util.StructuredBytes;
import com.sap.db.util.Tracer;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class VDNNumber {
    private static final int zeroExponentValue_C = 128;
    private static final int tensComplement_C = 9;
    private static final int numberDigits_C = 38;
    private static final String zerostring = "0000000000000000000000000000000000000000000000000000000000000000";
    private static final int zeor10powindex = 64;
    private static final double[] double10pow = new double[]{1.0E-64, 1.0E-63, 1.0E-62, 1.0E-61, 1.0E-60, 1.0E-59, 1.0E-58, 1.0E-57, 1.0E-56, 1.0E-55, 1.0E-54, 1.0E-53, 1.0E-52, 1.0E-51, 1.0E-50, 1.0E-49, 1.0E-48, 1.0E-47, 1.0E-46, 1.0E-45, 1.0E-44, 1.0E-43, 1.0E-42, 1.0E-41, 1.0E-40, 1.0E-39, 1.0E-38, 1.0E-37, 1.0E-36, 1.0E-35, 1.0E-34, 1.0E-33, 1.0E-32, 1.0E-31, 1.0E-30, 1.0E-29, 1.0E-28, 1.0E-27, 1.0E-26, 1.0E-25, 1.0E-24, 1.0E-23, 1.0E-22, 1.0E-21, 1.0E-20, 1.0E-19, 1.0E-18, 1.0E-17, 1.0E-16, 1.0E-15, 1.0E-14, 1.0E-13, 1.0E-12, 1.0E-11, 1.0E-10, 1.0E-9, 1.0E-8, 1.0E-7, 1.0E-6, 1.0E-5, 1.0E-4, 0.001, 0.01, 0.1, 1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22, 1.0E23, 1.0E24, 1.0E25, 1.0E26, 1.0E27, 1.0E28, 1.0E29, 1.0E30, 1.0E31, 1.0E32, 1.0E33, 1.0E34, 1.0E35, 1.0E36, 1.0E37, 1.0E38, 1.0E39, 1.0E40, 1.0E41, 1.0E42, 1.0E43, 1.0E44, 1.0E45, 1.0E46, 1.0E47, 1.0E48, 1.0E49, 1.0E50, 1.0E51, 1.0E52, 1.0E53, 1.0E54, 1.0E55, 1.0E56, 1.0E57, 1.0E58, 1.0E59, 1.0E60, 1.0E61, 1.0E62, 1.0E63, 1.0E64};

    public static byte[] bigDecimal2number(BigDecimal decimal) {
        return VDNNumber.bigDecimal2number(decimal, 38);
    }

    public static String bigDecimal2PlainString(BigDecimal val) {
        String res;
        int scale = val.scale();
        if (scale < 0) {
            val = val.setScale(0);
            scale = 0;
        }
        if (scale == 0) {
            res = val.toBigInteger().toString();
        } else {
            String unsignedIntVal = val.unscaledValue().abs().toString();
            String prefix = val.signum() < 0 ? "-0." : "0.";
            int pointPos = unsignedIntVal.length() - scale;
            if (pointPos == 0) {
                res = prefix + unsignedIntVal;
            } else if (pointPos > 0) {
                StringBuffer buf = new StringBuffer(unsignedIntVal);
                buf.insert(pointPos, '.');
                if (val.signum() < 0) {
                    buf.insert(0, '-');
                }
                res = buf.toString();
            } else {
                StringBuffer buf = new StringBuffer(3 - pointPos + unsignedIntVal.length());
                buf.append(prefix);
                for (int i = 0; i < -pointPos; ++i) {
                    buf.append('0');
                }
                buf.append(unsignedIntVal);
                res = buf.toString();
            }
        }
        return res;
    }

    public static byte[] bigDecimal2number(BigDecimal decimal, int validDigits) {
        int firstDigit;
        boolean isNegative;
        String plain = VDNNumber.bigDecimal2PlainString(decimal);
        int scale = decimal.scale() < 0 ? 0 : decimal.scale();
        char[] chars = plain.toCharArray();
        int digitCount = chars.length;
        if (chars[0] == '-') {
            isNegative = true;
            firstDigit = 1;
        } else {
            isNegative = false;
            firstDigit = 0;
        }
        while ((chars[firstDigit] == '0' || chars[firstDigit] == '.') && firstDigit < digitCount - 1) {
            ++firstDigit;
        }
        int exponent = chars.length - firstDigit - scale;
        digitCount = chars.length - firstDigit;
        if (digitCount == 1 && chars[firstDigit] == '0') {
            return new byte[]{-128};
        }
        if (exponent > 0 && scale > 0) {
            --exponent;
            --digitCount;
            System.arraycopy(chars, chars.length - scale, chars, chars.length - scale - 1, scale);
        }
        if (digitCount > validDigits) {
            if (chars[firstDigit + validDigits] >= '5') {
                int n = firstDigit + validDigits;
                chars[n] = (char)(chars[n] + '\u0001');
            }
            digitCount = validDigits;
        }
        int i = firstDigit;
        while (i < digitCount + firstDigit) {
            int n = i++;
            chars[n] = (char)(chars[n] - 48);
        }
        byte[] number = new byte[(digitCount + 1) / 2 + 1];
        VDNNumber.packDigits(chars, firstDigit, digitCount, isNegative, number);
        exponent = isNegative ? 64 - exponent : (exponent += 192);
        number[0] = (byte)exponent;
        return number;
    }

    public static byte[] long2number(long value) {
        boolean isNegative = false;
        int negativeVal = 1;
        char[] scratch = new char[39];
        int scratchPos = 37;
        if (value == 0L) {
            return new byte[]{-128};
        }
        if (value < 0L) {
            negativeVal = -1;
            isNegative = true;
        }
        while (value != 0L) {
            char digit;
            scratch[scratchPos] = digit = (char)((long)negativeVal * (value % 10L));
            value /= 10L;
            --scratchPos;
        }
        int exponent = 38 - scratchPos - 1;
        byte[] number = new byte[(38 - ++scratchPos + 1) / 2 + 1];
        VDNNumber.packDigits(scratch, scratchPos, 38 - scratchPos, isNegative, number);
        exponent = isNegative ? 64 - exponent : (exponent += 192);
        number[0] = (byte)exponent;
        return number;
    }

    public static BigDecimal number2BigDecimal(byte[] rawNumber) throws SQLException {
        BigDecimal result = null;
        int digitCount = (rawNumber.length - 1) * 2;
        int lastSignificant = 2;
        try {
            int exponent;
            int characteristic = rawNumber[0] & 0xFF;
            if (characteristic == 128) {
                return BigDecimal.valueOf(0L);
            }
            byte[] digits = new byte[digitCount + 2];
            if (characteristic < 128) {
                exponent = -(characteristic - 64);
                digits[0] = 45;
                digits[1] = 46;
                for (int i = 1; i < rawNumber.length; ++i) {
                    int value = ((char)rawNumber[i] & 0xFF) >> 4;
                    if (value != 0) {
                        lastSignificant = i * 2;
                    }
                    digits[i * 2] = (byte)(9 - value + 48);
                    value = (char)rawNumber[i] & 0xF;
                    if (value != 0) {
                        lastSignificant = i * 2 + 1;
                    }
                    digits[i * 2 + 1] = (byte)(9 - value + 48);
                }
                int n = lastSignificant;
                digits[n] = (byte)(digits[n] + 1);
            } else {
                exponent = characteristic - 192;
                digits[0] = 48;
                digits[1] = 46;
                for (int i = 1; i < rawNumber.length; ++i) {
                    int value = ((char)rawNumber[i] & 0xFF) >> 4;
                    if (value != 0) {
                        lastSignificant = i * 2;
                    }
                    digits[i * 2] = (byte)(value + 48);
                    value = (char)rawNumber[i] & 0xF;
                    if (value != 0) {
                        lastSignificant = i * 2 + 1;
                    }
                    digits[i * 2 + 1] = (byte)(value + 48);
                }
            }
            String numberString = new String(digits, 0, lastSignificant + 1);
            result = new BigDecimal(numberString);
            result = result.movePointRight(exponent);
            return result;
        }
        catch (Exception ex) {
            throw SQLExceptionSapDB.generateSQLException("error.conversion.VDNnumber", Tracer.Hex2String(rawNumber));
        }
    }

    public static double shortnumber2Double(byte[] rawNumber) throws SQLException {
        try {
            int value;
            boolean isNegative;
            int exponent;
            long result = 0L;
            int characteristic = rawNumber[0] & 0xFF;
            if (characteristic == 128) {
                return 0.0;
            }
            if (characteristic < 128) {
                exponent = -(characteristic - 64);
                isNegative = true;
                int nullValCnt = 1;
                for (int i = 1; i < rawNumber.length; ++i) {
                    value = (rawNumber[i] & 0xFF) >> 4;
                    if (value == 9) {
                        ++nullValCnt;
                    } else {
                        result = (long)((double)result * double10pow[nullValCnt + 64]);
                        exponent -= nullValCnt;
                        nullValCnt = 1;
                        result += (long)(9 - value);
                    }
                    value = rawNumber[i] & 0xF;
                    if (value == 9) {
                        ++nullValCnt;
                        continue;
                    }
                    result = (long)((double)result * double10pow[nullValCnt + 64]);
                    exponent -= nullValCnt;
                    nullValCnt = 1;
                    result += (long)(9 - value);
                }
                ++result;
            } else {
                exponent = characteristic - 192;
                isNegative = false;
                int nullValCnt = 1;
                for (int i = 1; i < rawNumber.length; ++i) {
                    value = (rawNumber[i] & 0xF0) >>> 4;
                    if (value == 0) {
                        ++nullValCnt;
                    } else {
                        result = (long)((double)result * double10pow[nullValCnt + 64]);
                        exponent -= nullValCnt;
                        nullValCnt = 1;
                        result += (long)value;
                    }
                    value = rawNumber[i] & 0xF;
                    if (value == 0) {
                        ++nullValCnt;
                        continue;
                    }
                    result = (long)((double)result * double10pow[nullValCnt + 64]);
                    exponent -= nullValCnt;
                    nullValCnt = 1;
                    result += (long)value;
                }
            }
            double myresult = result;
            myresult *= double10pow[exponent + 64];
            if (isNegative) {
                myresult = -myresult;
            }
            return myresult;
        }
        catch (Exception ex) {
            throw SQLExceptionSapDB.generateSQLException("error.conversion.VDNnumber", Tracer.Hex2String(rawNumber));
        }
    }

    public static long number2long(byte[] rawNumber) throws SQLException {
        boolean isNegative;
        long result = 0L;
        int numberDigits = rawNumber.length * 2 - 2;
        int characteristic = rawNumber[0] & 0xFF;
        if (characteristic == 128) {
            return 0L;
        }
        if (characteristic < 128) {
            int exponent = -(characteristic - 64);
            if (exponent < 0 || exponent > numberDigits) {
                BigDecimal bigD = VDNNumber.number2BigDecimal(rawNumber);
                return bigD.longValue();
            }
            isNegative = true;
            for (int i = 0; i < exponent; ++i) {
                int value = rawNumber[i / 2 + 1];
                if (i % 2 == 0) {
                    value &= 0xF0;
                    value >>>= 4;
                } else {
                    value &= 0xF;
                }
                result *= 10L;
                result += (long)(9 - value);
            }
            ++result;
        } else {
            int exponent = characteristic - 192;
            if (exponent < 0 || exponent > numberDigits) {
                BigDecimal bigD = VDNNumber.number2BigDecimal(rawNumber);
                return bigD.longValue();
            }
            isNegative = false;
            for (int i = 0; i < exponent; ++i) {
                int value = rawNumber[i / 2 + 1];
                if (i % 2 == 0) {
                    value &= 0xF0;
                    value >>>= 4;
                } else {
                    value &= 0xF;
                }
                result *= 10L;
                result += (long)value;
            }
        }
        if (isNegative) {
            result = -result;
        }
        return result;
    }

    public static int number2int(byte[] rawBytes) throws SQLException {
        return (int)VDNNumber.number2long(rawBytes);
    }

    private static void packDigits(char[] digits, int start, int count, boolean isNegative, byte[] number) {
        int i;
        int lastDigit = start + count - 1;
        if (isNegative) {
            for (i = start; i < lastDigit; ++i) {
                digits[i] = (char)(9 - digits[i]);
            }
            digits[lastDigit] = (char)(10 - digits[lastDigit]);
            int digitPos = lastDigit;
            while (digits[digitPos] == '\n') {
                digits[digitPos] = '\u0000';
                int n = digitPos - 1;
                digits[n] = (char)(digits[n] + '\u0001');
                --digitPos;
            }
        }
        i = 1;
        while (start <= lastDigit) {
            byte highNibble = (byte)digits[start];
            byte lowNibble = start + 1 <= lastDigit ? (byte)digits[start + 1] : (byte)0;
            number[i] = (byte)(highNibble << 4 | lowNibble);
            ++i;
            start += 2;
        }
    }

    public static String number2string(byte[] number, boolean fixedtype, int logicalLength, int frac) throws SQLException {
        try {
            int v1;
            int i;
            int exponent;
            int characteristic = number[0] & 0xFF;
            if (characteristic == 128) {
                return "0";
            }
            char[] digits = new char[logicalLength];
            int lastsignificant = 0;
            boolean isnegative = false;
            if (characteristic < 128) {
                isnegative = true;
                exponent = -(characteristic - 64);
                for (i = 0; i < logicalLength; ++i) {
                    v1 = i % 2 == 0 ? (number[1 + i / 2] & 0xFF) >> 4 : number[1 + i / 2] & 0xF;
                    if (v1 != 0) {
                        lastsignificant = i;
                    }
                    digits[i] = (char)(9 - v1 + 48);
                }
                int n = lastsignificant;
                digits[n] = (char)(digits[n] + '\u0001');
            } else {
                exponent = characteristic - 192;
                for (i = 0; i < logicalLength; ++i) {
                    v1 = i % 2 == 0 ? (number[1 + i / 2] & 0xFF) >> 4 : number[1 + i / 2] & 0xF;
                    if (v1 != 0) {
                        lastsignificant = i;
                    }
                    digits[i] = (char)(v1 + 48);
                }
            }
            String sign = isnegative ? "-" : "";
            String numberstr = new String(digits, 0, lastsignificant + 1);
            if (fixedtype) {
                if (exponent > 0) {
                    if (numberstr.length() < logicalLength) {
                        numberstr = numberstr + zerostring.substring(0, logicalLength - numberstr.length());
                    }
                    if (frac != 0) {
                        return sign + numberstr.substring(0, exponent) + "." + numberstr.substring(exponent, exponent + frac);
                    }
                    return sign + numberstr.substring(0, exponent);
                }
                int zeroend = frac - -exponent - numberstr.length();
                if (zeroend < 0) {
                    zeroend = 0;
                }
                return sign + "0." + zerostring.substring(0, -exponent) + numberstr + zerostring.substring(0, zeroend);
            }
            if (exponent < -3 || exponent > 7) {
                return sign + "0." + numberstr + "E" + exponent;
            }
            switch (exponent) {
                case -3: {
                    return sign + "0.000" + numberstr;
                }
                case -2: {
                    return sign + "0.00" + numberstr;
                }
                case -1: {
                    return sign + "0.0" + numberstr;
                }
                case 0: {
                    return sign + "0." + numberstr;
                }
            }
            if (numberstr.length() <= exponent) {
                return sign + numberstr + zerostring.substring(0, exponent - numberstr.length());
            }
            return sign + numberstr.substring(0, exponent) + "." + numberstr.substring(exponent);
        }
        catch (Exception ex) {
            throw SQLExceptionSapDB.generateSQLException("error.conversion.VDNnumber", Tracer.Hex2String(number));
        }
    }

    public static void dumpVDN(String comment, byte[] number) {
        StructuredBytes struct = new StructuredBytes(number);
        System.out.println(comment);
        struct.traceOn(System.out);
    }
}

