/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.interfaces;

import com.sybase.util.ds.Utils;
import com.sybase.util.ds.interfaces.Service;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;

public abstract class InterfacesBaseParser {
    protected String _fileName;
    public static final String[] SERVICE_TYPES = new String[]{"master", "query", "win3_master", "win3_query", "dos_query", "console", "debug", "commit", "secmech", "$base"};

    protected final boolean probe(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        this._fileName = uRL.getFile();
        return this.probe(inputStream);
    }

    protected final boolean probe(String string) throws IOException {
        FileInputStream fileInputStream = Utils.getFileInputStream(string);
        this._fileName = string;
        return this.probe(fileInputStream);
    }

    protected final boolean probe(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        bufferedReader.mark(1);
        if (-1 == bufferedReader.read()) {
            bufferedReader.close();
            return true;
        }
        bufferedReader.reset();
        String string = null;
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            if (this.isCommentLine(string) || string.trim().isEmpty()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            bufferedReader.close();
            return true;
        }
        bufferedReader.reset();
        Vector<String> vector = this.nextSubject(bufferedReader);
        for (int i = 0; i < vector.size(); ++i) {
            string = vector.get(i);
            if (this.isAttributes(string)) continue;
            bufferedReader.close();
            return false;
        }
        bufferedReader.close();
        return vector.size() > 0;
    }

    protected abstract boolean createFile(String var1);

    protected abstract boolean isAttributes(String var1);

    protected abstract Service getService(String var1);

    protected final boolean isCommentLine(String string) {
        return this.isBlankLine(string) ? false : string.startsWith("#") || string.startsWith(";");
    }

    protected boolean isBlankLine(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().length() == 0;
    }

    protected abstract boolean isSubject(String var1);

    protected String[] getSubject(String string) {
        String[] stringArray = string.split("[\\s\\[\\]]");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2 == null || string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        String[] stringArray2 = new String[3];
        if (arrayList.size() > 0) {
            stringArray2[0] = ((String)arrayList.get(0)).toString();
            if (arrayList.size() > 1) {
                stringArray2[1] = ((String)arrayList.get(1)).toString();
                if (arrayList.size() > 2) {
                    stringArray2[2] = ((String)arrayList.get(2)).toString();
                }
            }
        }
        return stringArray2;
    }

    protected boolean isEndOfSubject(String string) {
        if (string == null) {
            return true;
        }
        if (this.isBlankLine(string)) {
            return true;
        }
        if (this.isCommentLine(string)) {
            return true;
        }
        return !this.startsWith(string, SERVICE_TYPES);
    }

    private Vector<String> nextSubject(BufferedReader bufferedReader) throws IOException {
        String string;
        Vector<String> vector = new Vector<String>();
        do {
            if ((string = bufferedReader.readLine()) == null) {
                return vector;
            }
            string = string.trim();
        } while (!this.isSubject(string));
        string = this.refineSubject(string);
        boolean bl = false;
        while (!bl) {
            string = bufferedReader.readLine();
            if (string != null) {
                string = string.trim();
            }
            if (!this.isEndOfSubject(string)) {
                if (this.isBlankLine(string) || this.isCommentLine(string)) continue;
                vector.addElement(string);
                continue;
            }
            bl = true;
        }
        return vector;
    }

    protected abstract boolean isTLIStyle(String var1);

    protected boolean hasIt(String string, String[] stringArray) {
        if (string != null && string.length() > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (string.toLowerCase().indexOf(stringArray[i]) < 0) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract String refineSubject(String var1);

    protected abstract boolean matchSubject(String var1, String var2);

    protected abstract boolean startsWith(String var1, String[] var2);

    protected abstract boolean TLI2TCP(String var1, String[] var2);

    protected abstract boolean TCP2TLI(String var1, String[] var2);
}

