/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.uaf;

import com.sybase.util.ds.Utils;
import com.sybase.util.ds.lang.DSResourceBase;
import com.sybase.util.ds.uaf.Subject;
import com.sybase.util.ds.uaf.SyUAFEntry;
import com.sybase.util.ds.uaf.Verb;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.prefs.Preferences;

public class DiscoveryFilter {
    public static final String ASE = "ASE";
    public static final String SYSAM = "SYSAM";
    public static final String DATE_FORMAT = "MM/dd/yy";
    protected static DSResourceBase _res = DSResourceBase.getBundle();
    private static final String DISCOVERY_FILTER_PATH_ROOT = "/com/sybase/util/ds/uaf/DiscoveryFilter";
    private static final String NODE_SUBJECT = "Subject";
    private static final String NODE_VERB = "Verb";
    private static final String NODE_NOUN = "Noun";
    private static final String KEY_NAME = "Name";
    private static final String KEY_TYPE = "Type";
    private static final String KEY_ENABLED = "Enabled";
    private static final String KEY_ALL = "All";
    public boolean enabled;
    public Subject subject;
    public Verb verb;
    public String noun;

    public DiscoveryFilter(boolean bl, Subject subject, Verb verb, String string) {
        this.enabled = bl;
        this.subject = subject;
        this.verb = verb;
        this.noun = string;
    }

    public DiscoveryFilter() {
        this.enabled = true;
        this.subject = new Subject();
        this.verb = new Verb();
        this.noun = "_";
    }

    private static Preferences getPreferenceRoot(String string) {
        Preferences preferences = Preferences.userRoot().node("/com/sybase/util/ds/uaf/DiscoveryFilter/" + string);
        return preferences;
    }

    public static boolean hasDiscoveryFilters() {
        return DiscoveryFilter.hasDiscoveryFilters(ASE);
    }

    public static boolean hasDiscoveryFilters(String string) {
        Preferences preferences = DiscoveryFilter.getPreferenceRoot(string);
        String[] stringArray = Utils.getChildrenNames(preferences);
        for (int i = 0; i < stringArray.length; ++i) {
            Preferences preferences2 = preferences.node(String.valueOf(i));
            boolean bl = preferences2.getBoolean(KEY_ENABLED, true);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public static boolean isMatchingAllFilters(String string) {
        Preferences preferences = DiscoveryFilter.getPreferenceRoot(string);
        return preferences.getBoolean(KEY_ALL, true);
    }

    public static List<DiscoveryFilter> getDiscoveryFilters() {
        return DiscoveryFilter.getDiscoveryFilters(ASE);
    }

    public static List<DiscoveryFilter> getDiscoveryFilters(String string) {
        Preferences preferences = DiscoveryFilter.getPreferenceRoot(string);
        String[] stringArray = Utils.getChildrenNames(preferences);
        ArrayList<DiscoveryFilter> arrayList = new ArrayList<DiscoveryFilter>();
        for (int i = 0; i < stringArray.length; ++i) {
            Preferences preferences2 = preferences.node(String.valueOf(i));
            boolean bl = preferences2.getBoolean(KEY_ENABLED, true);
            Preferences preferences3 = preferences2.node(NODE_SUBJECT);
            Subject subject = new Subject();
            String string2 = preferences3.get(KEY_NAME, subject.name);
            String string3 = preferences3.get(KEY_TYPE, subject.type);
            subject = new Subject(string2, string3);
            Verb verb = new Verb();
            Preferences preferences4 = preferences2.node(NODE_VERB);
            string2 = preferences4.get(KEY_NAME, verb.name);
            verb = new Verb(string2);
            Preferences preferences5 = preferences2.node(NODE_NOUN);
            string2 = preferences5.get(KEY_NAME, "_");
            DiscoveryFilter discoveryFilter = new DiscoveryFilter(bl, subject, verb, string2);
            arrayList.add(discoveryFilter);
        }
        return arrayList;
    }

    public static boolean passFilters(String string, Class<? extends SyUAFEntry> clazz, SyUAFEntry syUAFEntry) {
        boolean bl;
        List<DiscoveryFilter> list = DiscoveryFilter.getDiscoveryFilters(string);
        int n = 0;
        for (DiscoveryFilter discoveryFilter : list) {
            if (!discoveryFilter.enabled) continue;
            ++n;
        }
        boolean bl2 = bl = n < 2 || DiscoveryFilter.isMatchingAllFilters(string);
        for (DiscoveryFilter discoveryFilter : list) {
            if (!discoveryFilter.enabled) continue;
            boolean bl3 = discoveryFilter.pass(clazz, syUAFEntry);
            if (bl3 && !bl) {
                return true;
            }
            if (!bl3 && bl) {
                return false;
            }
            bl2 = bl ? bl2 && bl3 : bl2 || bl3;
        }
        return bl2;
    }

    private boolean pass(Class<? extends SyUAFEntry> clazz, SyUAFEntry syUAFEntry) {
        boolean bl = true;
        try {
            Method method = clazz.getMethod(this.subject.name, new Class[0]);
            Object object = method.invoke((Object)syUAFEntry, new Object[0]);
            if (this.subject.type.equals("D")) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy");
                Date date = simpleDateFormat.parse(object.toString());
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(date.getTime());
                if (this.verb.name.equals("IS_IN_THE_LAST") || this.verb.name.equals("IS_NOT_IN_THE_LAST")) {
                    String[] stringArray = this.noun.split(":");
                    String string = stringArray[0];
                    int n = Integer.parseInt(string);
                    String string2 = stringArray[1];
                    Calendar calendar2 = Calendar.getInstance();
                    if (string2.equals("DAYS")) {
                        calendar2.add(5, -n);
                    } else if (string2.equals("WEEKS")) {
                        calendar2.add(5, -(n * 7));
                    } else if (string2.equals("MONTHS")) {
                        calendar2.add(2, -n);
                    } else if (string2.equals("YEARS")) {
                        calendar2.add(1, -n);
                    }
                    bl = this.verb.name.equals("IS_IN_THE_LAST") && calendar.after(calendar2) || this.verb.name.equals("IS_NOT_IN_THE_LAST") && calendar.before(calendar2);
                } else {
                    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(DATE_FORMAT);
                    Date date2 = simpleDateFormat2.parse(this.noun);
                    Calendar calendar3 = Calendar.getInstance();
                    calendar3.setTimeInMillis(date2.getTime());
                    if (this.verb.name.equals("IS") || this.verb.name.equals("IS_NOT")) {
                        int n = calendar.get(2);
                        int n2 = calendar.get(5);
                        int n3 = calendar.get(1);
                        int n4 = calendar3.get(2);
                        int n5 = calendar3.get(5);
                        int n6 = calendar3.get(1);
                        bl = this.verb.name.equals("IS") && n == n4 && n2 == n5 && n3 == n6 || this.verb.name.equals("IS_NOT") && (n != n4 || n2 != n5 || n3 != n6);
                    } else if (this.verb.name.equals("IS_AFTER") || this.verb.name.equals("IS_BEFORE")) {
                        bl = this.verb.name.equals("IS_AFTER") && calendar.after(calendar3) || this.verb.name.equals("IS_BEFORE") && calendar.before(calendar3);
                    }
                }
            } else if (this.subject.type.equals("N")) {
                int n = Integer.valueOf(this.noun);
                int n7 = Integer.valueOf(object.toString());
                bl = this.verb.name.equals("IS") && n7 == n || this.verb.name.equals("IS_NOT") && n7 != n || this.verb.name.equals("IS_GREATER_THAN") && n7 > n || this.verb.name.equals("IS_LESS_THAN") && n7 < n;
            } else if (this.subject.type.equals("S")) {
                String string = object.toString();
                if (this.subject.name.equals("getReleaseType")) {
                    String string3 = string.startsWith("a") || string.startsWith("A") ? "ALPHA" : (string.startsWith("b") || string.startsWith("B") ? "BETA" : "PRODUCTION");
                    bl = this.verb.name.equals("IS") && string3.equals(this.noun) || this.verb.name.equals("IS_NOT") && !string3.equals(this.noun);
                } else {
                    bl = this.verb.name.equals("IS") && string.equalsIgnoreCase(this.noun) || this.verb.name.equals("IS_NOT") && !string.equalsIgnoreCase(this.noun) || this.verb.name.equals("STARTS_WITH") && string.toLowerCase().startsWith(this.noun.toLowerCase()) || this.verb.name.equals("ENDS_WITH") && string.toLowerCase().endsWith(this.noun.toLowerCase()) || this.verb.name.equals("CONTAINS") && string.toLowerCase().indexOf(this.noun.toLowerCase()) >= 0 || this.verb.name.equals("DOES_NOT_CONTAIN") && string.toLowerCase().indexOf(this.noun.toLowerCase()) < 0;
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return bl;
    }

    public static void saveDiscoveryFilters(String string, boolean bl, List<DiscoveryFilter> list) {
        Preferences preferences = DiscoveryFilter.getPreferenceRoot(string);
        if (preferences != null) {
            Utils.removeNode(preferences);
        }
        preferences = DiscoveryFilter.getPreferenceRoot(string);
        preferences.putBoolean(KEY_ALL, bl);
        for (int i = 0; i < list.size(); ++i) {
            DiscoveryFilter discoveryFilter = list.get(i);
            Preferences preferences2 = preferences.node(String.valueOf(i));
            preferences2.putBoolean(KEY_ENABLED, discoveryFilter.enabled);
            Preferences preferences3 = preferences2.node(NODE_SUBJECT);
            preferences3.put(KEY_NAME, discoveryFilter.subject.name);
            preferences3.put(KEY_TYPE, discoveryFilter.subject.type);
            Preferences preferences4 = preferences2.node(NODE_VERB);
            preferences4.put(KEY_NAME, discoveryFilter.verb.name);
            Preferences preferences5 = preferences2.node(NODE_NOUN);
            preferences5.put(KEY_NAME, discoveryFilter.noun);
        }
    }

    public String getCondition() {
        String string = this.verb.toString() + " ";
        if (this.verb.name.equals("IS_IN_THE_LAST") || this.verb.name.equals("IS_NOT_IN_THE_LAST")) {
            String[] stringArray = this.noun.split(":");
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            string = string + string2 + " " + _res.get(string3);
        } else {
            string = this.subject.name.equals("getReleaseType") || this.subject.name.equals("getStatus") ? string + _res.get(this.noun) : string + this.noun;
        }
        return string;
    }

    public String getText() {
        return this.enabled + " " + this.subject.toString() + " " + this.verb.toString() + " " + this.noun;
    }

    public String getDisplayString() {
        return this.subject.toString() + " " + this.getCondition();
    }

    public String toString() {
        return this.subject.toString();
    }
}

