/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.packet.RequestPacket;
import com.sap.db.jdbc.topology.System;
import com.sap.db.rte.comm.JdbcCommunication;
import com.sap.db.util.Tracer;
import com.sap.db.util.VolumeIDList;
import java.sql.SQLException;
import java.util.Iterator;

public class SessionPool {
    private VolumeIDList m_sessions = new VolumeIDList();
    private JdbcCommunication m_primarySession;
    private JdbcCommunication m_masterSession;
    private System system = null;
    private Tracer tracer;

    public SessionPool(Tracer tracer) {
        this.tracer = tracer;
    }

    public System getSystem() {
        return this.system;
    }

    public void addSession(JdbcCommunication session) throws SQLException {
        int volumeID = session.getLocation().getVolumeID();
        if (this.m_masterSession == null) {
            this.m_masterSession = session;
            if (this.tracer.isDistributionTraceOn()) {
                this.tracer.println("DISTRIBUTION: master  session changed to " + session.getSessionInfo());
            }
        }
        if (this.m_primarySession == null) {
            this.m_primarySession = session;
            if (this.tracer.isDistributionTraceOn()) {
                this.tracer.println("DISTRIBUTION: primary session changed to " + session.getSessionInfo());
            }
        } else if (this.m_primarySession.getLocation().getVolumeID() == volumeID) {
            this.m_primarySession = session;
            if (this.tracer.isDistributionTraceOn()) {
                this.tracer.println("DISTRIBUTION: primary session changed to " + session.getSessionInfo());
            }
        }
        this.m_sessions.add(volumeID, session);
        if (this.system == null) {
            this.system = session.getSystem();
        }
    }

    public JdbcCommunication getSession(int volumeID) {
        return (JdbcCommunication)this.m_sessions.get(volumeID);
    }

    public JdbcCommunication getPrimarySession() {
        return this.m_primarySession;
    }

    public void setPrimarySession(JdbcCommunication primarySession) {
        if (!this.m_primarySession.equals(primarySession)) {
            this.m_primarySession = primarySession;
            Iterator iter = this.getSessions();
            while (iter.hasNext()) {
                JdbcCommunication session = (JdbcCommunication)iter.next();
                session.setSendSessionContextInfo(true);
            }
            if (this.tracer.isDistributionTraceOn()) {
                this.tracer.println("DISTRIBUTION: primary session changed to " + primarySession.getSessionInfo());
            }
        }
    }

    public void releaseAll(ConnectionSapDB conn) {
        Iterator iter = this.getSessions();
        while (iter.hasNext()) {
            JdbcCommunication session = (JdbcCommunication)iter.next();
            try {
                if (session.isConnected()) {
                    RequestPacket requestPacket = conn.getRequestPacket(session);
                    requestPacket.initDisconnect();
                    conn.execute(requestPacket, conn, 1, session, true);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            session.release();
            iter.remove();
        }
        this.m_masterSession = null;
    }

    public JdbcCommunication getMasterSession() {
        return this.m_masterSession;
    }

    public Iterator getSessions() {
        return this.m_sessions.iterator();
    }

    public JdbcCommunication getSessionForTransactionHandling() {
        return this.m_primarySession;
    }
}

