/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.topology;

import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.MultiLineOptionsPart;
import com.sap.db.jdbc.topology.Host;
import com.sap.db.jdbc.topology.Location;
import com.sap.db.jdbc.trace.TraceControl;
import com.sap.db.rte.comm.JdbcCommFactory;
import com.sap.db.rte.comm.JdbcCommunication;
import com.sap.db.rte.comm.RTEException;
import com.sap.db.rte.comm.SecureCommunication;
import com.sap.db.rte.comm.SocketComm;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.Tracer;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class System {
    private boolean m_isAvailable;
    private Hashtable m_locations = new Hashtable();
    private int m_nextlocation = 0;
    private String m_sid;
    private int m_engineDistributionMode = -1;

    private Location getLocation(int volumeID) {
        Enumeration enu = this.m_locations.elements();
        while (enu.hasMoreElements()) {
            Location tmpLoc = (Location)enu.nextElement();
            if (tmpLoc.getVolumeID() != volumeID) continue;
            return tmpLoc;
        }
        return null;
    }

    public void updateSID(String sid) {
        this.m_sid = sid;
    }

    public String getSid() {
        return this.m_sid;
    }

    public System(String sid) {
        this.m_sid = sid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location updateLocations(MultiLineOptionsPart mo) throws SQLException {
        int serviceType = 3;
        Location ownLocation = null;
        try {
            Hashtable hashtable = this.m_locations;
            synchronized (hashtable) {
                do {
                    int m_volumeID = 0;
                    String m_hostName = null;
                    int m_portNumber = 0;
                    String m_tenantName = null;
                    double m_Loadfactor = 0.0;
                    boolean isMaster = false;
                    boolean isStandby = false;
                    boolean isOwn = false;
                    String ipAdresses = null;
                    String hostNames = null;
                    String networkDomain = null;
                    do {
                        switch (mo.getOptionName()) {
                            case 1: {
                                m_hostName = mo.getOptionStringValue();
                                break;
                            }
                            case 2: {
                                m_portNumber = mo.getOptionIntValue();
                                break;
                            }
                            case 3: {
                                m_tenantName = mo.getOptionStringValue();
                                break;
                            }
                            case 4: {
                                m_Loadfactor = mo.getOptionDoubleValue();
                                break;
                            }
                            case 5: {
                                m_volumeID = mo.getOptionIntValue();
                                break;
                            }
                            case 6: {
                                isMaster = mo.getOptionBoolValue();
                                break;
                            }
                            case 10: {
                                isStandby = mo.getOptionBoolValue();
                                break;
                            }
                            case 7: {
                                isOwn = mo.getOptionBoolValue();
                                break;
                            }
                            case 11: {
                                ipAdresses = mo.getOptionStringValue();
                                break;
                            }
                            case 12: {
                                hostNames = mo.getOptionStringValue();
                                break;
                            }
                            case 9: {
                                networkDomain = mo.getOptionStringValue();
                                break;
                            }
                            case 8: {
                                serviceType = mo.getOptionIntValue();
                                break;
                            }
                        }
                    } while (mo.nextOption());
                    if (m_volumeID == -1) {
                        throw SQLExceptionSapDB.generateSQLException("error.topology.missinginfo", "Volume id");
                    }
                    if (m_portNumber == 0) {
                        throw SQLExceptionSapDB.generateSQLException("error.topology.missinginfo", "Port number");
                    }
                    if (m_hostName == null) {
                        throw SQLExceptionSapDB.generateSQLException("error.topology.missinginfo", "Host name");
                    }
                    Host host = new Host(m_hostName, m_portNumber, ipAdresses, hostNames, networkDomain);
                    Location loc = (Location)this.m_locations.get(host);
                    if (null != loc) {
                        loc.setMaster(isMaster);
                        loc.setVolumeID(m_volumeID);
                        loc.setLoadfactor(m_Loadfactor);
                        loc.setTenantName(m_tenantName);
                    } else {
                        loc = this.addLocation(m_volumeID, host, m_tenantName, m_Loadfactor, isMaster, isStandby, serviceType);
                    }
                    if (!isOwn) continue;
                    ownLocation = loc;
                } while (mo.nextLine());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return ownLocation;
    }

    public Location addLocation_for_test_only(int m_volumeID, Host m_hostName, String m_tenantName, double m_Loadfactor, boolean isMaster, boolean isStandby, int serviceType) {
        return this.addLocation(m_volumeID, m_hostName, m_tenantName, m_Loadfactor, isMaster, isStandby, serviceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Location addLocation(int m_volumeID, Host m_host, String m_tenantName, double m_Loadfactor, boolean isMaster, boolean isStandby, int serviceType) {
        Location loc = new Location(m_volumeID, m_host, m_tenantName, m_Loadfactor, isMaster, isStandby, serviceType, this);
        Hashtable hashtable = this.m_locations;
        synchronized (hashtable) {
            this.m_locations.put(m_host, loc);
        }
        return loc;
    }

    public Location getLocation(Host hostNameAndPort) {
        return (Location)this.m_locations.get(hostNameAndPort);
    }

    public Enumeration getLocations() {
        return this.m_locations.elements();
    }

    public int hashCode() {
        return this.m_sid.hashCode();
    }

    public boolean equals(Object obj) {
        return this.m_sid.equals(((System)obj).getSid());
    }

    public synchronized JdbcCommunication getSession(ArrayList preferedHostList, Properties info, boolean connectionRoutingEnabled, TraceControl mytrc) throws RTEException {
        Location loc;
        JdbcCommFactory factory;
        String transport = Driver.getBooleanProperty(info, "encrypt", false) ? "secure" : info.getProperty("transport", "socket");
        if (transport.equals("socket")) {
            factory = SocketComm.factory;
        } else if (transport.equals("secure")) {
            factory = SecureCommunication.factory;
        } else {
            throw new RTEException(MessageTranslator.translate("error.invalid.transport", transport), -10899, mytrc.tracer, 1);
        }
        StringBuffer errorMsg = new StringBuffer();
        int tryCnt = 0;
        RTEException catchedRTE = null;
        ArrayList<Location> locations = new ArrayList<Location>();
        Iterator iter = preferedHostList.iterator();
        while (iter.hasNext()) {
            Host host = (Host)iter.next();
            loc = new Location(0, host, "", 0.0, false, false, 3, this);
            locations.add(loc);
        }
        this.getLocationsList(locations, connectionRoutingEnabled);
        iter = locations.iterator();
        while (iter.hasNext()) {
            loc = (Location)iter.next();
            try {
                return factory.open(loc, info, mytrc.tracer);
            }
            catch (UnsatisfiedLinkError linkErr) {
                throw new RTEException(MessageTranslator.translate("error.library.notloaded", "jniauthentication", linkErr.toString()), -10899, mytrc.tracer, 1);
            }
            catch (RTEException rteex) {
                if (tryCnt == 0) {
                    errorMsg.append(rteex.getMessage());
                } else {
                    errorMsg.append("host = ");
                    errorMsg.append(loc.getPrimaryHostName() + ":" + loc.getPortNumber());
                    errorMsg.append(" error = ");
                    errorMsg.append(rteex.getMessage());
                    errorMsg.append("; ");
                }
                loc.setAvailable(false);
                ++tryCnt;
                if (catchedRTE != null) continue;
                catchedRTE = rteex;
            }
            catch (Exception e) {
                if (tryCnt == 0) {
                    errorMsg.append(e.getMessage());
                } else {
                    errorMsg.append("host = ");
                    errorMsg.append(loc.getPrimaryHostName() + ":" + loc.getPortNumber());
                    errorMsg.append(" error = ");
                    errorMsg.append(e.getMessage());
                    errorMsg.append("; ");
                }
                loc.setAvailable(false);
                ++tryCnt;
            }
        }
        if (tryCnt > 1) {
            throw new RTEException("None of the hosts could be reached. [" + errorMsg + "]", mytrc.tracer, 1);
        }
        if (catchedRTE == null) {
            throw new RTEException(errorMsg.toString(), mytrc.tracer, 1);
        }
        throw catchedRTE;
    }

    public synchronized void reconnect(JdbcCommunication session, Tracer tracer, boolean connectionRoutingEnabled) throws RTEException {
        StringBuffer errorMsg = new StringBuffer();
        int tryCnt = 0;
        ArrayList locations = new ArrayList();
        this.getLocationsList(locations, connectionRoutingEnabled);
        Iterator iter = locations.iterator();
        while (iter.hasNext()) {
            Location loc = (Location)iter.next();
            try {
                session.setLocation(loc);
                session.reconnect();
                return;
            }
            catch (Exception e) {
                if (tryCnt == 0) {
                    errorMsg.append(e.getMessage());
                } else {
                    errorMsg.append("host = ");
                    errorMsg.append(loc.getPrimaryHostName() + ":" + loc.getPortNumber());
                    errorMsg.append(" error = ");
                    errorMsg.append(e.getMessage());
                    errorMsg.append("; ");
                }
                loc.setAvailable(false);
                ++tryCnt;
            }
        }
        if (tryCnt > 1) {
            throw new RTEException("None of the hosts could be reached. [" + errorMsg + "]", tracer, 1);
        }
        throw new RTEException(errorMsg.toString(), tracer, 1);
    }

    protected void getLocationsList(ArrayList hostList, boolean connectionRoutingEnabled) {
        boolean isStatisticServerConnect = false;
        if (connectionRoutingEnabled && !this.IsEngineConnectionRoutingOn()) {
            connectionRoutingEnabled = false;
        }
        Enumeration en = this.m_locations.elements();
        while (en.hasMoreElements()) {
            Location loc = (Location)en.nextElement();
            boolean isInList = false;
            for (int i = 0; i < hostList.size(); ++i) {
                Location location = (Location)hostList.get(i);
                if (!loc.getPrimarayHostPort().equals(location.getPrimarayHostPort()) && !loc.isSameTarget(location)) continue;
                hostList.set(i, loc);
                isInList = true;
                if (!loc.isStatisticServer()) break;
                isStatisticServerConnect = true;
                break;
            }
            if (isInList || !connectionRoutingEnabled && !loc.isMaster() && !loc.isStandby() || !loc.isIndexServer()) continue;
            hostList.add(loc);
        }
        if (connectionRoutingEnabled && !isStatisticServerConnect && hostList.size() > 1) {
            if (this.m_nextlocation >= hostList.size()) {
                this.m_nextlocation = 0;
            }
            for (int var = 0; var < this.m_nextlocation; ++var) {
                hostList.add(hostList.remove(0));
            }
            ++this.m_nextlocation;
        }
    }

    public synchronized JdbcCommunication getSession(int volumeID, Properties info, TraceControl mytrc) throws RTEException {
        JdbcCommFactory factory;
        String transport = Driver.getBooleanProperty(info, "encrypt", false) ? "secure" : info.getProperty("transport", "socket");
        if (transport.equals("socket")) {
            factory = SocketComm.factory;
        } else if (transport.equals("secure")) {
            factory = SecureCommunication.factory;
        } else {
            throw new RTEException(MessageTranslator.translate("error.invalid.transport", transport), -10899, mytrc.tracer, 1);
        }
        Location loc = this.getLocation(volumeID);
        if (loc == null) {
            return null;
        }
        try {
            return factory.open(loc, info, mytrc.tracer);
        }
        catch (UnsatisfiedLinkError linkErr) {
            throw new RTEException(MessageTranslator.translate("error.library.notloaded", "jniauthentication", linkErr.toString()), -10899, mytrc.tracer, 1);
        }
        catch (Exception e) {
            loc.setAvailable(false);
            throw new RTEException(e.getMessage(), mytrc.tracer, 1);
        }
    }

    public void dump(PrintStream out) {
        out.println("System=" + this.m_sid);
        Enumeration locList = this.getLocations();
        while (locList.hasMoreElements()) {
            Location loc = (Location)locList.nextElement();
            out.print("    ");
            loc.dump(out);
        }
    }

    public int getNumberOfLocations() {
        return this.m_locations.size();
    }

    public boolean IsEngineConnectionRoutingOn() {
        return this.m_engineDistributionMode == 0 || this.m_engineDistributionMode == 2;
    }

    public void setEngineDistributionMode(int m_engineDistributionMode) {
        this.m_engineDistributionMode = m_engineDistributionMode;
    }
}

