/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.Putval;
import com.sap.db.jdbc.translators.ReaderInputStream;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.jdbc.translators.StreamTranslator;
import com.sap.db.util.StringUtil;
import com.sap.db.util.StructuredMem;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public class AsciiStreamTranslator
extends StreamTranslator {
    protected AsciiStreamTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
        this.characterDatatypePostfix = " ASCII";
    }

    public InputStream getAsciiStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        return this.getStream(controller, mem, longData);
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        String result = this.getString(controller, mem);
        if (result == null) {
            result = null;
        }
        return result;
    }

    public Object transAsciiStreamForInput(InputStream stream, long length) throws SQLException {
        return this.transStreamForInput(stream, length, 2);
    }

    public Object transCharacterStreamForInput(Reader reader, long length) throws SQLException {
        if (reader == null) {
            return reader;
        }
        ReaderInputStream stream = new ReaderInputStream(reader, false);
        return this.transStreamForInput(stream, length, 3);
    }

    public Object transStringForInput(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        return new Putval(StringUtil.bytes_iso8859_1(val), this.bufpos_input, 2);
    }

    boolean isPackectEncodingUnicode() {
        return false;
    }
}

