/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.DBTechTranslator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DirectRecordInsertTranslator
extends DBTechTranslator {
    private int fraction;

    public DirectRecordInsertTranslator(int mode, int ioType, int dataType, int len, int frac, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
        this.fraction = frac;
    }

    public int getScale() {
        switch (this.dataType) {
            case 4: {
                return 0;
            }
            case 5: {
                return this.fraction == Short.MAX_VALUE ? 0 : this.fraction;
            }
        }
        return this.fraction;
    }

    public int getPrecision() {
        switch (this.dataType) {
            case 15: 
            case 64: {
                return 8;
            }
            case 14: 
            case 63: {
                return 10;
            }
            case 16: 
            case 61: 
            case 62: {
                return 23;
            }
        }
        return this.logicalLength;
    }

    protected int putSpecific(DataPart dataPart, Object data) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "putSpecific", "DirectRecordInsertTranslator");
    }

    public Object transSpecificForInput(Object obj) throws SQLException {
        Object result = null;
        if (obj instanceof Timestamp) {
            result = this.transTimestampForInput((Timestamp)obj, Calendar.getInstance());
        } else if (obj instanceof Time) {
            result = this.transTimeForInput((Time)obj, Calendar.getInstance());
        } else if (obj instanceof java.sql.Date) {
            result = this.transDateForInput((java.sql.Date)obj, Calendar.getInstance());
        } else if (obj instanceof Date) {
            Date utilDate = (Date)obj;
            result = this.transDateForInput(new java.sql.Date(utilDate.getTime()), Calendar.getInstance());
        } else if (obj instanceof String) {
            result = this.transStringForInput((String)obj);
        } else if (obj instanceof BigDecimal) {
            result = this.transBigDecimalForInput((BigDecimal)obj);
        } else if (obj instanceof byte[]) {
            throw this.newSetException("byte[]");
        }
        return result;
    }

    public Object transBooleanForInput(boolean val) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "transBooleanForInput", "DirectRecordInsertTranslator");
    }

    public Object transByteForInput(byte val) throws SQLException {
        byte[] value = null;
        switch (this.dataType) {
            case 1: {
                value = (byte[])this.transTinyIntForInput(val);
                break;
            }
            case 2: {
                value = (byte[])this.transShortForInput(val);
                break;
            }
            case 3: {
                value = (byte[])this.transIntForInput(val);
                break;
            }
            case 4: {
                value = (byte[])this.transLongForInput(val);
                break;
            }
            case 6: {
                value = (byte[])this.transFloatForInput(val);
                break;
            }
            case 7: {
                value = (byte[])this.transDoubleForInput(val);
                break;
            }
            case 5: {
                value = (byte[])this.transBigDecimalForInput(new BigDecimal(val));
                break;
            }
            case 12: 
            case 13: 
            case 33: {
                byte[] x = new byte[]{val};
                value = (byte[])this.transBStringForInput(x);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 29: 
            case 30: 
            case 35: {
                byte[] x = new byte[]{val};
                value = (byte[])this.transStringForInput(new String(x));
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", new Integer(this.dataType));
            }
        }
        return value;
    }

    public Object transBytesForInput(byte[] val) throws SQLException {
        if (val == null) {
            return null;
        }
        byte[] value = null;
        switch (this.dataType) {
            case 12: 
            case 13: 
            case 33: {
                value = (byte[])this.transBStringForInput(val);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 29: 
            case 30: 
            case 35: {
                value = (byte[])this.transStringForInput(new String(val));
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", new Integer(this.dataType));
            }
        }
        return value;
    }

    public Object transDoubleForInput(double val) throws SQLException {
        byte[] value = null;
        switch (this.dataType) {
            case 1: {
                value = (byte[])this.transTinyIntForInput((byte)val);
                break;
            }
            case 2: {
                value = (byte[])this.transShortForInput((short)val);
                break;
            }
            case 3: {
                value = (byte[])this.transIntForInput((int)val);
                break;
            }
            case 4: {
                value = (byte[])this.transLongForInput((long)val);
                break;
            }
            case 6: {
                value = (byte[])this.transFloatForInput((float)val);
                break;
            }
            case 5: {
                value = (byte[])this.transBigDecimalForInput(new BigDecimal(val));
                break;
            }
            case 7: {
                value = new byte[8];
                dataFormat.putDouble(value, val, 0);
                break;
            }
            case 12: 
            case 13: 
            case 33: {
                value = (byte[])this.transBStringForInput(Double.toString(val).getBytes());
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 29: 
            case 30: 
            case 35: {
                value = (byte[])this.transStringForInput(Double.toString(val));
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", new Integer(this.dataType));
            }
        }
        return value;
    }

    public Object transFloatForInput(float val) throws SQLException {
        byte[] value = null;
        switch (this.dataType) {
            case 1: {
                value = (byte[])this.transTinyIntForInput((byte)val);
                break;
            }
            case 2: {
                value = (byte[])this.transShortForInput((short)val);
                break;
            }
            case 3: {
                value = (byte[])this.transIntForInput((int)val);
                break;
            }
            case 4: {
                value = (byte[])this.transLongForInput((long)val);
                break;
            }
            case 7: {
                value = (byte[])this.transDoubleForInput(val);
                break;
            }
            case 5: {
                value = (byte[])this.transBigDecimalForInput(new BigDecimal(val));
                break;
            }
            case 6: {
                value = new byte[4];
                dataFormat.putFloat(value, val, 0);
                break;
            }
            case 12: 
            case 13: 
            case 33: {
                value = (byte[])this.transBStringForInput(Float.toString(val).getBytes());
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 29: 
            case 30: 
            case 35: {
                value = (byte[])this.transStringForInput(Float.toString(val));
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", new Integer(this.dataType));
            }
        }
        return value;
    }

    public Object transIntForInput(int val) throws SQLException {
        byte[] value = null;
        switch (this.dataType) {
            case 1: {
                value = (byte[])this.transTinyIntForInput((byte)val);
                break;
            }
            case 2: {
                value = (byte[])this.transShortForInput((short)val);
                break;
            }
            case 4: {
                value = (byte[])this.transLongForInput(val);
                break;
            }
            case 6: {
                value = (byte[])this.transFloatForInput(val);
                break;
            }
            case 7: {
                value = (byte[])this.transDoubleForInput(val);
                break;
            }
            case 5: {
                value = (byte[])this.transBigDecimalForInput(new BigDecimal(val));
                break;
            }
            case 3: {
                value = new byte[this.isNullable() == 1 ? 5 : 4];
                dataFormat.putInt4(value, val, 0);
                if (this.isNullable() != 1) break;
                dataFormat.putInt1(value, 1, 4);
                break;
            }
            case 12: 
            case 13: 
            case 33: {
                value = (byte[])this.transBStringForInput(Integer.toString(val).getBytes());
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 29: 
            case 30: 
            case 35: {
                value = (byte[])this.transStringForInput(Integer.toString(val));
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", new Integer(this.dataType));
            }
        }
        return value;
    }

    public Object transLongForInput(long val) throws SQLException {
        byte[] value = null;
        switch (this.dataType) {
            case 1: {
                value = (byte[])this.transTinyIntForInput((byte)val);
                break;
            }
            case 2: {
                value = (byte[])this.transShortForInput((short)val);
                break;
            }
            case 3: {
                value = (byte[])this.transIntForInput((int)val);
                break;
            }
            case 6: {
                value = (byte[])this.transFloatForInput(val);
                break;
            }
            case 7: {
                value = (byte[])this.transDoubleForInput(val);
                break;
            }
            case 5: {
                value = (byte[])this.transBigDecimalForInput(new BigDecimal(val));
                break;
            }
            case 4: {
                value = new byte[this.isNullable() == 1 ? 9 : 8];
                dataFormat.putInt8(value, val, 0);
                if (this.isNullable() != 1) break;
                dataFormat.putInt1(value, 1, 8);
                break;
            }
            case 12: 
            case 13: 
            case 33: {
                value = (byte[])this.transBStringForInput(Long.toString(val).getBytes());
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 29: 
            case 30: 
            case 35: {
                value = (byte[])this.transStringForInput(Long.toString(val));
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", new Integer(this.dataType));
            }
        }
        return value;
    }

    public Object transShortForInput(short val) throws SQLException {
        byte[] value = null;
        switch (this.dataType) {
            case 1: {
                value = (byte[])this.transTinyIntForInput((byte)val);
                break;
            }
            case 3: {
                value = (byte[])this.transIntForInput(val);
                break;
            }
            case 4: {
                value = (byte[])this.transLongForInput(val);
                break;
            }
            case 6: {
                value = (byte[])this.transFloatForInput(val);
                break;
            }
            case 7: {
                value = (byte[])this.transDoubleForInput(val);
                break;
            }
            case 5: {
                value = (byte[])this.transBigDecimalForInput(new BigDecimal(val));
                break;
            }
            case 2: {
                value = new byte[this.isNullable() == 1 ? 3 : 2];
                dataFormat.putInt2(value, val, 0);
                if (this.isNullable() != 1) break;
                dataFormat.putInt1(value, 1, 2);
                break;
            }
            case 12: 
            case 13: 
            case 33: {
                value = (byte[])this.transBStringForInput(Short.toString(val).getBytes());
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 29: 
            case 30: 
            case 35: {
                value = (byte[])this.transStringForInput(Short.toString(val));
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", new Integer(this.dataType));
            }
        }
        return value;
    }

    public Object transTinyIntForInput(byte val) throws SQLException {
        byte[] value = null;
        switch (this.dataType) {
            case 3: {
                value = (byte[])this.transIntForInput(val);
                break;
            }
            case 2: {
                value = (byte[])this.transShortForInput(val);
                break;
            }
            case 4: {
                value = (byte[])this.transLongForInput(val);
                break;
            }
            case 6: {
                value = (byte[])this.transFloatForInput(val);
                break;
            }
            case 7: {
                value = (byte[])this.transDoubleForInput(val);
                break;
            }
            case 5: {
                value = (byte[])this.transBigDecimalForInput(new BigDecimal(val));
                break;
            }
            case 1: {
                value = new byte[this.isNullable() == 1 ? 2 : 1];
                dataFormat.putInt1(value, val, 0);
                if (this.isNullable() != 1) break;
                dataFormat.putInt1(value, 1, 1);
                break;
            }
            case 12: 
            case 13: 
            case 33: {
                value = (byte[])this.transBStringForInput(Byte.toString(val).getBytes());
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 29: 
            case 30: 
            case 35: {
                value = (byte[])this.transStringForInput(Byte.toString(val));
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", new Integer(this.dataType));
            }
        }
        return value;
    }

    public Object transBStringForInput(byte[] val) throws SQLException {
        if (val == null) {
            return null;
        }
        byte[] value = null;
        switch (this.dataType) {
            case 12: {
                int ORD_F = 3;
                int byteLen = val.length;
                value = new byte[byteLen + 2];
                value[0] = 0;
                value[1] = 0;
                value[0] = (byte)(value[0] | 3);
                value[0] = (byte)(value[0] | (byte)(byteLen & 0x1F) << 3);
                value[1] = (byte)(value[1] | (byte)(byteLen >> 8 & 0xFF));
                System.arraycopy(val, 0, value, 2, byteLen);
                break;
            }
            case 13: 
            case 33: {
                value = val;
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", new Integer(this.dataType));
            }
        }
        return value;
    }

    public Object transStringForInput(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        byte[] value = null;
        switch (this.dataType) {
            case 1: {
                Byte x = new Byte(val);
                value = (byte[])this.transTinyIntForInput(x);
                break;
            }
            case 2: {
                Short x = new Short(val);
                value = (byte[])this.transShortForInput(x);
                break;
            }
            case 3: {
                Integer x = new Integer(val);
                value = (byte[])this.transIntForInput(x);
                break;
            }
            case 4: {
                Long x = new Long(val);
                value = (byte[])this.transLongForInput(x);
                break;
            }
            case 6: {
                Float x = new Float(val);
                value = (byte[])this.transFloatForInput(x.floatValue());
                break;
            }
            case 7: {
                Double x = new Double(val);
                value = (byte[])this.transDoubleForInput(x);
                break;
            }
            case 5: {
                BigDecimal x = new BigDecimal(val);
                value = (byte[])this.transBigDecimalForInput(x);
                break;
            }
            case 12: 
            case 13: 
            case 33: {
                value = (byte[])this.transBStringForInput(val.getBytes());
                break;
            }
            case 8: 
            case 10: {
                char c;
                int ORD_F = 3;
                char[] ca = val.toCharArray();
                int byteLen = 0;
                int len = ca.length;
                for (int i = 0; i < len; ++i) {
                    c = ca[i];
                    if (c >= '\u0001' && c <= '\u007f') {
                        ++byteLen;
                        continue;
                    }
                    if (c > '\u07ff') {
                        byteLen += 3;
                        continue;
                    }
                    byteLen += 2;
                }
                byte[] destBuf = new byte[byteLen + 2];
                destBuf[0] = 0;
                destBuf[1] = 0;
                destBuf[0] = (byte)(destBuf[0] | 3);
                destBuf[0] = (byte)(destBuf[0] | (byte)(byteLen & 0x1F) << 3);
                destBuf[1] = (byte)(destBuf[1] | (byte)(byteLen >> 8 & 0xFF));
                int count = 2;
                for (int i = 0; i < len; ++i) {
                    c = ca[i];
                    if (c >= '\u0001' && c <= '\u007f') {
                        destBuf[count++] = (byte)c;
                        continue;
                    }
                    if (c > '\u07ff') {
                        destBuf[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                        destBuf[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                        destBuf[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                        continue;
                    }
                    destBuf[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                    destBuf[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                }
                value = destBuf;
                break;
            }
            case 9: 
            case 11: 
            case 29: 
            case 30: 
            case 35: {
                char c;
                char[] ca = val.toCharArray();
                int byteLen = 0;
                int len = ca.length;
                for (int i = 0; i < len; ++i) {
                    c = ca[i];
                    if (c >= '\u0001' && c <= '\u007f') {
                        ++byteLen;
                        continue;
                    }
                    if (c > '\u07ff') {
                        byteLen += 3;
                        continue;
                    }
                    byteLen += 2;
                }
                int count = 0;
                byte[] destBuf = new byte[byteLen];
                for (int i = 0; i < len; ++i) {
                    c = ca[i];
                    if (c >= '\u0001' && c <= '\u007f') {
                        destBuf[count++] = (byte)c;
                        continue;
                    }
                    if (c > '\u07ff') {
                        destBuf[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                        destBuf[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                        destBuf[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                        continue;
                    }
                    destBuf[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                    destBuf[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                }
                value = destBuf;
                break;
            }
            case 16: 
            case 61: 
            case 62: {
                try {
                    Timestamp timestampVal = Timestamp.valueOf(val);
                    value = (byte[])this.transTimestampForInput(timestampVal, Calendar.getInstance());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", val);
                }
            }
            case 15: 
            case 64: {
                try {
                    Time timeVal = Time.valueOf(val);
                    value = (byte[])this.transTimeForInput(timeVal, Calendar.getInstance());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", val);
                }
            }
            case 14: 
            case 63: {
                try {
                    java.sql.Date dateVal = java.sql.Date.valueOf(val);
                    value = (byte[])this.transDateForInput(dateVal, Calendar.getInstance());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", val);
                }
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", new Integer(this.dataType));
            }
        }
        return value;
    }

    public Object transBigDecimalForInput(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            return null;
        }
        byte[] value = null;
        if (this.getScale() == 0) {
            value = new byte[16];
            byte[] target = new byte[15];
            int scale = bigDecimal.scale();
            int sign = bigDecimal.signum();
            bigDecimal = bigDecimal.movePointRight(scale);
            bigDecimal = bigDecimal.abs();
            BigInteger bi = bigDecimal.toBigInteger();
            BigInteger ten = null;
            while (bi.bitLength() > 113) {
                if (ten == null) {
                    ten = new BigInteger("10", 10);
                }
                bi = bi.divide(ten);
                --scale;
            }
            byte[] dval = bi.toByteArray();
            int dvalSize = dval.length;
            int exp = 6176 - scale;
            byte e1 = sign < 0 ? (byte)(0xFFFFFF80 | (byte)(exp >> 7)) : (byte)(0 | (byte)(exp >> 7));
            byte e2 = (byte)(exp << 1 & 0xFE);
            for (int i = 0; i < 15; ++i) {
                target[i] = 15 > dvalSize + i ? (byte)0 : dval[(dvalSize + i) % 15];
            }
            e2 = (byte)(e2 | (byte)(target[0] & 1));
            value[7] = target[7];
            value[6] = target[8];
            value[5] = target[9];
            value[4] = target[10];
            value[3] = target[11];
            value[2] = target[12];
            value[1] = target[13];
            value[0] = target[14];
            value[15] = e1;
            value[14] = e2;
            value[13] = target[1];
            value[12] = target[2];
            value[11] = target[3];
            value[10] = target[4];
            value[9] = target[5];
            value[8] = target[6];
        } else {
            int[] ceilTable = new int[]{0, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11, 12, 12, 13, 13, 13, 14, 14, 15, 15, 15, 16, 16, 17, 17};
            int ORD_F = 3;
            boolean PLUS = false;
            boolean MINUS = true;
            int precision = this.getPrecision();
            int length = ceilTable[precision];
            int scale = this.getScale();
            int sign = bigDecimal.signum() >= 0 ? 0 : 1;
            int flag = 3;
            value = new byte[length + 1];
            value[0] = 0;
            value[0] = (byte)(value[0] | length & 0xF);
            value[0] = (byte)(value[0] | (flag & 7) << 4);
            value[0] = (byte)(value[0] | (sign & 1) << 7);
            bigDecimal.setScale(scale);
            bigDecimal = bigDecimal.movePointRight(scale);
            bigDecimal = bigDecimal.abs();
            BigInteger bi = bigDecimal.toBigInteger();
            BigInteger ten = null;
            while (bi.bitLength() > 113) {
                if (ten == null) {
                    ten = new BigInteger("10", 10);
                }
                bi = bi.divide(ten);
                --scale;
            }
            byte[] dval = bi.toByteArray();
            for (int i = 0; i < dval.length; ++i) {
                value[i + 1] = dval[dval.length - i - 1];
            }
        }
        return value;
    }

    public Object transDateForInput(java.sql.Date val, Calendar cal) throws SQLException {
        if (val == null) {
            return null;
        }
        byte[] value = null;
        switch (this.dataType) {
            case 16: 
            case 61: 
            case 62: {
                Timestamp timestampVal = new Timestamp(val.getTime());
                value = (byte[])this.transTimestampForInput(timestampVal, cal);
                break;
            }
            case 15: 
            case 64: {
                Time timeVal = new Time(val.getTime());
                value = (byte[])this.transTimeForInput(timeVal, cal);
                break;
            }
            case 14: 
            case 63: {
                value = new byte[4];
                cal.setTime(val);
                TimeZone tz = cal.getTimeZone();
                long timeInMillis = cal.getTimeInMillis();
                int offset = tz.getOffset(timeInMillis);
                long ts = (timeInMillis + 62135769600000L + (long)offset) / 86400000L + 1L;
                dataFormat.putInt4(value, (int)ts, 0);
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", new Integer(this.dataType));
            }
        }
        return value;
    }

    public Object transTimeForInput(Time val, Calendar cal) throws SQLException {
        if (val == null) {
            return null;
        }
        byte[] value = null;
        switch (this.dataType) {
            case 15: 
            case 64: {
                value = new byte[4];
                cal.setTime(val);
                int hour = cal.get(11);
                int minute = cal.get(12);
                int second = cal.get(13);
                dataFormat.putInt4(value, hour * 60 * 60 + minute * 60 + second + 1, 0);
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", new Integer(this.dataType));
            }
        }
        return value;
    }

    public Object transTimestampForInput(Timestamp val, Calendar cal) throws SQLException {
        if (val == null) {
            return null;
        }
        byte[] value = null;
        switch (this.dataType) {
            case 14: 
            case 63: {
                java.sql.Date dateVal = new java.sql.Date(val.getTime());
                value = (byte[])this.transDateForInput(dateVal, cal);
                break;
            }
            case 15: 
            case 64: {
                Time timeVal = new Time(val.getTime());
                value = (byte[])this.transTimeForInput(timeVal, cal);
                break;
            }
            case 62: {
                value = new byte[8];
                cal.setTime(val);
                TimeZone tz = cal.getTimeZone();
                long timeInMillis = cal.getTimeInMillis();
                int offset = tz.getOffset(timeInMillis);
                long ts = (timeInMillis + 62135769600000L + (long)offset) / 1000L + 1L;
                dataFormat.putInt8(value, ts, 0);
                break;
            }
            case 16: 
            case 61: {
                value = new byte[8];
                cal.setTime(val);
                TimeZone tz = cal.getTimeZone();
                long timeInMillis = cal.getTimeInMillis();
                int offset = tz.getOffset(timeInMillis);
                int nanos = val.getNanos() / 100;
                long ts = (timeInMillis + 62135769600000L + (long)offset) / 1000L * 10000000L + (long)nanos + 1L;
                dataFormat.putInt8(value, ts, 0);
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", new Integer(this.dataType));
            }
        }
        return value;
    }
}

