/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.rte.comm;

import com.sap.db.jdbc.topology.Location;
import com.sap.db.jdbc.topology.System;
import com.sap.db.jdbc.topology.Topology;
import com.sap.db.rte.comm.RTEException;
import com.sap.db.util.StructuredMem;
import com.sap.db.util.UniqueID;
import java.sql.SQLException;

public abstract class JdbcCommunication {
    private static UniqueID m_globalSessionContextCount = new UniqueID();
    protected int m_connectionID = 0;
    protected long m_sessionContextCount = 0L;
    protected boolean m_isPartOfDistributedTransaction = false;
    protected boolean m_isPartOfTransaction = false;
    private boolean m_sendSessionContextInfo = false;
    protected Location m_location;

    public boolean sendSessionContextInfo() {
        return this.m_sendSessionContextInfo;
    }

    public void setSendSessionContextInfo(boolean m_sendSessionContext) {
        this.m_sendSessionContextInfo = m_sendSessionContext;
    }

    public long getSessionContextCount() {
        return this.m_sessionContextCount;
    }

    public void setLocation(Location location) {
        this.m_location = location;
    }

    public Location getLocation() {
        return this.m_location;
    }

    public int getVolumeID() {
        return this.m_location.getVolumeID();
    }

    public System getSystem() {
        return this.m_location.getSystem();
    }

    public System setSystemID(String sid) {
        System sys = this.m_location.getSystem();
        if (sys == null) {
            sys = Topology.addSystem(sid);
        }
        this.m_location.setSystem(sys);
        return sys;
    }

    public JdbcCommunication(Location location) {
        this.m_location = location;
        this.m_sessionContextCount = m_globalSessionContextCount.getNextID();
    }

    public abstract void cancel() throws SQLException;

    public StructuredMem execute(StructuredMem[] packetVec, int[] lenthVec) throws RTEException {
        this.request(packetVec, lenthVec);
        return this.receive();
    }

    public StructuredMem execute(StructuredMem userPacket, int len) throws RTEException {
        this.request(userPacket, len);
        return this.receive();
    }

    public abstract StructuredMem getRequestPacket(int var1) throws RTEException;

    public abstract boolean isConnected();

    public abstract StructuredMem receive() throws RTEException;

    public abstract void release();

    public abstract void request(StructuredMem[] var1, int[] var2) throws RTEException;

    public abstract void request(StructuredMem var1, int var2) throws RTEException;

    public abstract int getKernelTaskID();

    public abstract long getSessionID();

    public abstract int getMajorDBVersion();

    public abstract int getMinorDBVersion();

    public void setConnectionID(int m_connectionID) {
        this.m_connectionID = m_connectionID;
    }

    public int getConnectionID() {
        return this.m_connectionID;
    }

    public void reconnect() throws RTEException {
        this.reconnectInner();
        this.m_sessionContextCount = m_globalSessionContextCount.getNextID();
    }

    public abstract void reconnectInner() throws RTEException;

    public boolean isPartOfDistributedTransaction() {
        return this.m_isPartOfDistributedTransaction;
    }

    public void joinDistributedTransaction() {
        this.m_isPartOfDistributedTransaction = true;
        this.m_isPartOfTransaction = true;
    }

    public boolean isPartOfTransaction() {
        return this.m_isPartOfTransaction;
    }

    public void joinTransaction() {
        this.m_isPartOfTransaction = true;
    }

    public void leaveTransaction() {
        this.m_isPartOfDistributedTransaction = false;
        this.m_isPartOfTransaction = false;
    }

    public String getSessionInfo() {
        Location location = this.getLocation();
        return "Session@" + this.hashCode() + " ConnID:" + this.m_connectionID + " SessionID:" + this.getSessionID() + " VolumeID:" + location.getVolumeID() + " Host " + location.getPrimaryHostName() + ":" + location.getPortNumber();
    }
}

