/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.rte.comm;

import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.topology.Location;
import com.sap.db.rte.comm.BasicSocketComm;
import com.sap.db.rte.comm.JdbcCommFactory;
import com.sap.db.rte.comm.JdbcCommunication;
import com.sap.db.rte.comm.RTEException;
import com.sap.db.rte.comm.RteC;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.Tracer;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Properties;

public class SocketComm
extends BasicSocketComm {
    public static final JdbcCommFactory factory = new JdbcCommFactory(){

        public JdbcCommunication open(Location location, Properties properties, Tracer tracer) throws RTEException {
            SocketComm sc = new SocketComm(location, properties, tracer);
            sc.connectDB();
            return sc;
        }
    };

    protected SocketComm(Location location, Properties properties, Tracer tracer) throws RTEException {
        super(location, properties, tracer);
        this.openSocket();
    }

    protected void openSocket() throws RTEException {
        String host;
        RTEException exc = null;
        Iterator hosts = this.m_location.getHostNames();
        int port = this.lookupPort();
        if (this.m_tracer.isEnabled()) {
            this.m_tracer.print("HOSTLIST: [");
            while (hosts.hasNext()) {
                host = (String)hosts.next();
                this.m_tracer.print(host + ":" + port + ",");
            }
            this.m_tracer.println("]");
            hosts = this.m_location.getHostNames();
        }
        while (hosts.hasNext()) {
            host = (String)hosts.next();
            if (Driver.computername != null && (Driver.computername.equalsIgnoreCase(host) || Driver.fullcomputername.equalsIgnoreCase(host))) {
                host = "localhost";
            }
            try {
                this.socket = new Socket(host, port);
                try {
                    this.socket.setSoTimeout(this.socketTimeOut);
                    this.socket.setTcpNoDelay(true);
                    this.socket.setSendBufferSize(36864);
                    this.socket.setKeepAlive(true);
                }
                catch (SocketException socketEx) {
                    // empty catch block
                }
                this.instream = this.socket.getInputStream();
                this.outstream = this.socket.getOutputStream();
                exc = null;
                break;
            }
            catch (UnknownHostException uhexc) {
                if (exc != null) continue;
                exc = new RTEException(MessageTranslator.translate("error.unknown.host", host + ":" + this.lookupPort(), uhexc.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[13])), RteC.CommunicationErrorCodeMap_C[13], this.m_tracer, 13);
            }
            catch (IOException ioexc) {
                if (exc != null) continue;
                exc = new RTEException(MessageTranslator.translate("error.host.connect", host + ":" + this.lookupPort(), ioexc.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5);
            }
        }
        if (exc != null) {
            throw exc;
        }
        try {
            this.socket.setSoLinger(true, 15);
        }
        catch (SocketException soExc) {
            // empty catch block
        }
    }

    protected boolean supportsInfoRequest() {
        return true;
    }
}

