/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.RequestPacket;
import com.sap.db.jdbc.translators.DBTechTranslator;
import com.sap.db.rte.comm.DbPacketLayout;
import com.sap.db.rte.comm.RteSocketPacket;
import com.sap.db.util.DataFormatFullSwap;
import com.sap.db.util.StructuredBytes;
import com.sap.db.util.StructuredMem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;

public class RecordGenerator {
    private RequestPacket packetHeader;
    private DataFormatFullSwap dataFormat = new DataFormatFullSwap();
    private DbPacketLayout packetLayout;
    private ArrayList records = new ArrayList();
    private int recordCount;
    private int packetCount;
    private int packetHeaderSize;
    private int dataPartSize;
    private boolean hasColumnStoreAccess;
    static final int DEFAULT_HEADER_BUFFER_SIZE = 1000;
    static final int DEFAULT_FIXED_SLOT_BUFFER_SIZE = 5000;
    static final int DEFAULT_VAR_SLOT_BUFFER_SIZE = 5000;

    public RecordGenerator() {
        this.packetLayout = new DbPacketLayout();
        this.init();
    }

    public void init() {
        this.dataPartSize = 0;
        this.packetHeaderSize = 0;
        this.recordCount = 0;
        this.packetCount = 0;
    }

    public void init(RequestPacket requestPacket, boolean hasColumnStoreAccess) {
        this.init();
        this.packetHeaderSize = requestPacket.getDataPartOffset();
        this.packetHeader = requestPacket;
        ++this.packetCount;
        this.hasColumnStoreAccess = hasColumnStoreAccess;
    }

    public boolean close() {
        boolean VF_NUL = false;
        int VF_EMB = 16384;
        int VF_EXT = 49152;
        int varSlotOffsetSize = 8;
        Record record = this.getCurrentRecord();
        record.sort();
        int varGroupCount = record.getVarGroupCount();
        int headerSize = record.getHeaderSize();
        int fixedSlotSize = record.getFixedSlotSize();
        int varSlotSize = record.getVarSlotSize();
        int recordSize = fixedSlotSize + varSlotSize;
        if (this.dataPartSize + this.packetHeaderSize + headerSize + fixedSlotSize + varSlotSize > this.packetLayout.maxDataLength()) {
            return false;
        }
        record.header.putInt1(-92, record.headerSize);
        record.headerSize += 1;
        record.header.putInt4(recordSize, record.headerSize);
        record.headerSize += 4;
        record.header.putInt4(varGroupCount, record.headerSize);
        record.headerSize += 4;
        for (int i = 0; i < record.varGroupCount; ++i) {
            VarGroup varGroup = record.getVarGroupByIndex(i);
            if (varGroup.varSlotSize <= 7) continue;
            record.header.putInt2(varGroup.fieldOffset, record.headerSize);
            record.headerSize += 2;
        }
        if (record.varGroupCount > 0) {
            int varSlotOffset = 0;
            for (int i = 0; i < record.varGroupCount; ++i) {
                VarGroup varGroup = record.getVarGroupByIndex(i);
                record.fixedSlotSize = varGroup.fieldOffset;
                if (varGroup.varSlotSize > 7) {
                    record.fixedSlot.putInt8(fixedSlotSize + varSlotOffset, record.fixedSlotSize);
                    record.fixedSlotSize += 8;
                    varSlotOffset += varGroup.varSlotSize;
                    int fieldLen = 0;
                    for (int j = 0; j < varGroup.varSlotInfoCount; ++j) {
                        VarGroup.VarSlotInfo varSlotInfo = varGroup.getVarSlotInfo(j);
                        fieldLen += varSlotInfo.fieldLen;
                        if (varSlotInfo.fieldLen > 0) {
                            record.fixedSlot.putInt2(fieldLen + 49152, record.fixedSlotSize);
                        } else if (varSlotInfo.isNull) {
                            record.fixedSlot.putInt2(fieldLen + 0, record.fixedSlotSize);
                        } else {
                            record.fixedSlot.putInt2(fieldLen + 16384, record.fixedSlotSize);
                        }
                        record.fixedSlotSize += 2;
                    }
                    continue;
                }
                record.fixedSlot.putInt1(1, record.fixedSlotSize);
                record.fixedSlotSize += 1;
                StructuredBytes rawVarSlot = (StructuredBytes)varGroup.varSlot.getPointer(0);
                record.fixedSlot.putBytes(rawVarSlot.bytes(), record.fixedSlotSize, 7);
                record.fixedSlotSize += 7;
                int fieldLen = 0;
                for (int j = 0; j < varGroup.varSlotInfoCount; ++j) {
                    VarGroup.VarSlotInfo varSlotInfo = varGroup.getVarSlotInfo(j);
                    fieldLen += varSlotInfo.fieldLen;
                    if (varSlotInfo.isNull) {
                        record.fixedSlot.putInt2(fieldLen + 0, record.fixedSlotSize);
                    } else {
                        record.fixedSlot.putInt2(fieldLen + 49152, record.fixedSlotSize);
                    }
                    record.fixedSlotSize += 2;
                }
            }
        }
        if (record.fixedSlotSize % 2 != 0) {
            record.fixedSlotSize += 2 - record.fixedSlotSize % 2;
        }
        this.dataPartSize += headerSize;
        this.dataPartSize += fixedSlotSize;
        this.dataPartSize += varSlotSize;
        this.packetCount += varGroupCount + 2;
        ++this.recordCount;
        if (this.recordCount > this.records.size()) {
            this.records.add(new Record());
        } else {
            this.getRecord(this.recordCount - 1).init();
        }
        return true;
    }

    public boolean moveRecordBase() {
        return this.close();
    }

    public void resetCurrentRecord() {
        this.getCurrentRecord().init();
    }

    public Record getCurrentRecord() {
        if (this.recordCount == 0) {
            ++this.recordCount;
            if (this.recordCount > this.records.size()) {
                this.records.add(new Record());
            } else {
                this.getRecord(0).init();
            }
        }
        return this.getRecord(this.recordCount - 1);
    }

    public Record getRecord(int index) {
        return (Record)this.records.get(index);
    }

    public StructuredMem[] getPacketVec() {
        StructuredMem[] packetVec = new StructuredMem[this.packetCount];
        packetVec[0] = this.packetHeader.getBase();
        int count = 1;
        for (int i = 0; i < this.recordCount - 1; ++i) {
            Record record = this.getRecord(i);
            packetVec[count++] = record.header;
            packetVec[count++] = record.fixedSlot;
            for (int j = 0; j < record.varGroupCount; ++j) {
                VarGroup varGroup = record.getVarGroupByIndex(j);
                if (varGroup.varSlotSize <= 7) continue;
                packetVec[count++] = varGroup.varSlot;
            }
        }
        return packetVec;
    }

    public int[] getLengthVec() {
        int[] lengthVec = new int[this.packetCount];
        int count = 1;
        lengthVec[0] = this.packetHeaderSize;
        for (int i = 0; i < this.recordCount - 1; ++i) {
            Record record = this.getRecord(i);
            lengthVec[count++] = record.headerSize;
            lengthVec[count++] = record.fixedSlotSize;
            for (int j = 0; j < record.varGroupCount; ++j) {
                VarGroup varGroup = record.getVarGroupByIndex(j);
                int varSlotSize = varGroup.varSlotSize;
                if (varSlotSize <= 7) continue;
                lengthVec[count++] = varSlotSize;
            }
        }
        int align = this.packetHeader.length() - (this.dataPartSize + this.packetHeaderSize);
        if (align > 0) {
            int n = this.packetCount - 1;
            lengthVec[n] = lengthVec[n] + align;
        }
        return lengthVec;
    }

    public byte[] getDataPart() {
        byte[] packet = new byte[this.dataPartSize];
        int offset = 0;
        for (int i = 0; i < this.recordCount - 1; ++i) {
            Record record = this.getRecord(i);
            StructuredBytes part1 = (StructuredBytes)record.header.getPointer(0);
            System.arraycopy(part1.bytes(), 0, packet, offset, record.headerSize);
            StructuredBytes part2 = (StructuredBytes)record.fixedSlot.getPointer(0);
            System.arraycopy(part2.bytes(), 0, packet, offset += record.headerSize, record.fixedSlotSize);
            offset += record.fixedSlotSize;
            for (int j = 0; j < record.varGroupCount; ++j) {
                VarGroup varGroup = record.getVarGroupByIndex(j);
                if (varGroup.varSlotSize <= 7) continue;
                StructuredBytes part3 = (StructuredBytes)varGroup.varSlot.getPointer(0);
                System.arraycopy(part3.bytes(), 0, packet, offset, varGroup.varSlotSize);
                offset += varGroup.varSlotSize;
            }
        }
        return packet;
    }

    public int getDataPartSize() {
        return this.dataPartSize;
    }

    private boolean isFixedColumn(int dataType) {
        switch (dataType) {
            case 9: 
            case 11: 
            case 13: 
            case 29: 
            case 30: 
            case 33: 
            case 35: {
                return false;
            }
        }
        return true;
    }

    public boolean insert(DBTechTranslator paramInfo, Object parameter) throws SQLException {
        if (this.hasColumnStoreAccess) {
            throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "insert", "RecordGenerator");
        }
        if (this.isFixedColumn(paramInfo.getDataTypeCode())) {
            return this.insertFixedColumn(paramInfo, parameter);
        }
        return this.insertVarColumn(paramInfo, parameter);
    }

    private boolean insertFixedColumn(DBTechTranslator paramInfo, Object parameter) throws SQLException {
        int fieldOffset = paramInfo.getFieldOffset();
        byte[] value = null;
        int length = 0;
        if (parameter != null) {
            value = (byte[])parameter;
            length = value.length;
        } else {
            value = this.transNullForInput(paramInfo);
            length = value.length;
        }
        return this.getCurrentRecord().insertFixedColumn(value, length, fieldOffset);
    }

    private boolean insertVarColumn(DBTechTranslator paramInfo, Object parameter) {
        int fieldOffset = paramInfo.getFieldOffset();
        int idxInGroup = paramInfo.getIdxInGroup();
        byte[] value = null;
        int length = 0;
        if (parameter != null) {
            value = (byte[])parameter;
            length = value.length;
        }
        return this.getCurrentRecord().insertVarColumn(value, length, fieldOffset, idxInGroup);
    }

    private byte[] transNullForInput(DBTechTranslator paramInfo) throws SQLException {
        if (paramInfo.isNullable() != 1) {
            String state = "HY000";
            int rc = 287;
            boolean errorPos = false;
            boolean errorLevel = true;
            int[] updCnt = null;
            String errmsg = "cannot insert NULL or update to NULL";
            throw SQLExceptionSapDB.generateDatabaseException("error.databaseexception.woerrpos", "HY000", 287, 0, 0, updCnt, Integer.toString(287), "cannot insert NULL or update to NULL");
        }
        boolean NUL_F = true;
        boolean PLUS = false;
        byte[] value = null;
        int dataType = paramInfo.getDataTypeCode();
        switch (dataType) {
            case 1: {
                value = new byte[2];
                this.dataFormat.putInt1(value, 255, 0);
                this.dataFormat.putInt1(value, 0, 1);
                break;
            }
            case 2: {
                value = new byte[3];
                this.dataFormat.putInt2(value, Short.MAX_VALUE, 0);
                this.dataFormat.putInt1(value, 0, 2);
                break;
            }
            case 3: {
                value = new byte[5];
                this.dataFormat.putInt4(value, Integer.MAX_VALUE, 0);
                this.dataFormat.putInt1(value, 0, 4);
                break;
            }
            case 4: {
                value = new byte[9];
                this.dataFormat.putInt8(value, Long.MAX_VALUE, 0);
                this.dataFormat.putInt1(value, 0, 8);
                break;
            }
            case 6: {
                value = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    value[i] = -1;
                }
                break;
            }
            case 7: {
                value = new byte[8];
                for (int i = 0; i < 8; ++i) {
                    value[i] = -1;
                }
                break;
            }
            case 15: 
            case 64: {
                value = new byte[4];
                this.dataFormat.putInt4(value, 86402, 0);
                break;
            }
            case 14: 
            case 63: {
                value = new byte[4];
                this.dataFormat.putInt4(value, 3652062, 0);
                break;
            }
            case 62: {
                value = new byte[8];
                this.dataFormat.putInt8(value, 315538070401L, 0);
                break;
            }
            case 16: 
            case 61: {
                value = new byte[8];
                this.dataFormat.putInt8(value, 3155380704000000001L, 0);
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                value = new byte[]{0, 0};
                value[0] = (byte)(value[0] | 1);
                break;
            }
            case 5: {
                if (paramInfo.getScale() == 0) {
                    value = new byte[16];
                    value[15] = 112;
                    break;
                }
                int[] ceilTable = new int[]{0, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11, 12, 12, 13, 13, 13, 14, 14, 15, 15, 15, 16, 16, 17, 17};
                int precision = paramInfo.getPrecision();
                int length = ceilTable[precision];
                value = new byte[length + 1];
                value[0] = 0;
                value[0] = (byte)(value[0] | length & 0xF);
                value[0] = (byte)(value[0] | 0x10);
                value[0] = (byte)(value[0] | 0);
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", new Integer(dataType));
            }
        }
        return value;
    }

    private class Record {
        private int headerSize;
        private int fixedSlotSize;
        private int varGroupCount;
        private int currentVarGroup;
        private boolean isSorted;
        private RteSocketPacket header = new RteSocketPacket(1000);
        private RteSocketPacket fixedSlot = new RteSocketPacket(5000);
        private ArrayList varGroups = new ArrayList();

        public Record() {
            this.init();
        }

        public void init() {
            this.headerSize = 0;
            this.fixedSlotSize = 0;
            this.varGroupCount = 0;
            this.currentVarGroup = -1;
            this.isSorted = true;
        }

        public void sort() {
            if (!this.isSorted) {
                Collections.sort(this.varGroups.subList(0, this.varGroupCount));
                this.isSorted = true;
            }
            for (int i = 0; i < this.varGroupCount; ++i) {
                VarGroup varGroup = this.getVarGroupByIndex(i);
                if (varGroup.isSorted) continue;
                varGroup.sort();
            }
        }

        public int getVarGroupCount() {
            int result = 0;
            for (int i = 0; i < this.varGroupCount; ++i) {
                if (this.getVarGroupByIndex(i).varSlotSize <= 7) continue;
                ++result;
            }
            return result;
        }

        public int getHeaderSize() {
            return 9 + 2 * this.getVarGroupCount();
        }

        public int getFixedSlotSize() {
            int varSlotOffsetSize = 8;
            int varColumnOffsetSize = 2;
            int result = this.fixedSlotSize;
            for (int i = 0; i < this.varGroupCount; ++i) {
                VarGroup varGroup = this.getVarGroupByIndex(i);
                result = varGroup.fieldOffset;
                result += 8;
                result += 2 * varGroup.varSlotInfoCount;
            }
            if (result % 2 != 0) {
                result += 2 - result % 2;
            }
            return result;
        }

        public int getVarSlotSize() {
            int result = 0;
            for (int i = 0; i < this.varGroupCount; ++i) {
                VarGroup varGroup = this.getVarGroupByIndex(i);
                if (varGroup.varSlotSize <= 7) continue;
                result += varGroup.varSlotSize;
            }
            return result;
        }

        public VarGroup getVarGroupByIndex(int index) {
            return (VarGroup)this.varGroups.get(index);
        }

        public VarGroup getVarGroupByFieldOffset(int fieldOffset) {
            if (this.varGroupCount == 0) {
                ++this.varGroupCount;
                if (this.varGroupCount > this.varGroups.size()) {
                    this.varGroups.add(new VarGroup());
                } else {
                    this.getVarGroupByIndex(0).init();
                }
                VarGroup varGroup = this.getVarGroupByIndex(0);
                varGroup.fieldOffset = fieldOffset;
                this.currentVarGroup = 0;
                return varGroup;
            }
            if (this.getVarGroupByIndex(this.currentVarGroup).fieldOffset != fieldOffset) {
                boolean isAllocRequired = false;
                if (this.isSorted && this.getVarGroupByIndex(this.varGroupCount - 1).fieldOffset < fieldOffset) {
                    isAllocRequired = true;
                } else {
                    int varGroupIdx;
                    for (varGroupIdx = 0; varGroupIdx < this.varGroupCount && this.getVarGroupByIndex(varGroupIdx).fieldOffset != fieldOffset; ++varGroupIdx) {
                    }
                    if (varGroupIdx == this.varGroupCount) {
                        this.isSorted = false;
                        isAllocRequired = true;
                    } else {
                        this.currentVarGroup = varGroupIdx;
                    }
                }
                if (isAllocRequired) {
                    ++this.varGroupCount;
                    if (this.varGroupCount > this.varGroups.size()) {
                        this.varGroups.add(new VarGroup());
                    } else {
                        this.getVarGroupByIndex(this.varGroupCount - 1).init();
                    }
                    this.currentVarGroup = this.varGroupCount - 1;
                    this.getVarGroupByIndex(this.currentVarGroup).fieldOffset = fieldOffset;
                }
            }
            return this.getVarGroupByIndex(this.currentVarGroup);
        }

        public boolean insertFixedColumn(byte[] value, int length, int fieldOffset) {
            if (this.fixedSlotSize == 0) {
                this.fixedSlot.putInt1(0, this.fixedSlotSize);
                ++this.fixedSlotSize;
            }
            if (fieldOffset > this.fixedSlotSize) {
                this.fixedSlotSize = fieldOffset;
            }
            if (this.fixedSlot.putBytes(value, fieldOffset, length) == -1) {
                return false;
            }
            this.fixedSlotSize += length;
            return true;
        }

        public boolean insertVarColumn(byte[] value, int length, int fieldOffset, int idxInGroup) {
            return this.getVarGroupByFieldOffset(fieldOffset).insertVarColumn(value, length, idxInGroup);
        }
    }

    private class VarGroup
    implements Comparable {
        private int fieldOffset;
        private int varSlotSize;
        private int varSlotInfoCount;
        private int nextIdxInGroup;
        private boolean isSorted;
        private RteSocketPacket varSlot = new RteSocketPacket(5000);
        private ArrayList varSlotInfos = new ArrayList();

        public VarGroup() {
            this.init();
        }

        public int compareTo(Object o) {
            if (this.fieldOffset == ((VarGroup)o).fieldOffset) {
                return 0;
            }
            return this.fieldOffset > ((VarGroup)o).fieldOffset ? 1 : -1;
        }

        public void init() {
            this.fieldOffset = 0;
            this.varSlotSize = 0;
            this.varSlotInfoCount = 0;
            this.nextIdxInGroup = 0;
            this.isSorted = true;
        }

        public void sort() {
            if (!this.isSorted) {
                Collections.sort(this.varSlotInfos.subList(0, this.varSlotInfoCount));
                this.isSorted = true;
            }
        }

        public VarSlotInfo getVarSlotInfo(int index) {
            return (VarSlotInfo)this.varSlotInfos.get(index);
        }

        public boolean insertVarColumn(byte[] value, int length, int idxInGroup) {
            if (this.nextIdxInGroup == idxInGroup) {
                if (length > 0) {
                    if (this.varSlot.putBytes(value, this.varSlotSize, length) == -1) {
                        return false;
                    }
                    this.varSlotSize += length;
                }
            } else {
                if (length > 0) {
                    int startOffset = 0;
                    int moveLength = 0;
                    for (int i = 0; i < this.varSlotInfoCount; ++i) {
                        VarSlotInfo varSlotInfo = this.getVarSlotInfo(i);
                        if (varSlotInfo.idxInGroup <= idxInGroup) {
                            startOffset += varSlotInfo.fieldLen;
                            continue;
                        }
                        moveLength += varSlotInfo.fieldLen;
                    }
                    StructuredBytes rawVarSlot = (StructuredBytes)this.varSlot.getPointer(0);
                    if (this.varSlotSize + length > rawVarSlot.size()) {
                        return false;
                    }
                    if (moveLength > 0) {
                        System.arraycopy(rawVarSlot.bytes(), startOffset, rawVarSlot.bytes(), startOffset + length, moveLength);
                    }
                    if (this.varSlot.putBytes(value, startOffset, length) == -1) {
                        return false;
                    }
                    this.varSlotSize += length;
                }
                this.isSorted = false;
            }
            ++this.varSlotInfoCount;
            if (this.varSlotInfoCount > this.varSlotInfos.size()) {
                this.varSlotInfos.add(new VarSlotInfo());
            }
            VarSlotInfo varSlotInfo = this.getVarSlotInfo(this.varSlotInfoCount - 1);
            varSlotInfo.fieldLen = length;
            varSlotInfo.idxInGroup = idxInGroup;
            boolean bl = varSlotInfo.isNull = value == null;
            if (this.nextIdxInGroup < idxInGroup + 1) {
                this.nextIdxInGroup = idxInGroup + 1;
            }
            return true;
        }

        public class VarSlotInfo
        implements Comparable {
            public int fieldLen;
            public int idxInGroup;
            public boolean isNull;

            public int compareTo(Object o) {
                if (this.idxInGroup == ((VarSlotInfo)o).idxInGroup) {
                    return 0;
                }
                return this.idxInGroup > ((VarSlotInfo)o).idxInGroup ? 1 : -1;
            }
        }
    }
}

