/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class VersionInfo {
    private int majorVersion;
    private int minorVersion;
    private int patchLevel;
    private String changelist;
    private String packagePrefix;
    private String githash;

    public VersionInfo() {
        this.majorVersion = 1;
        this.minorVersion = 0;
        this.patchLevel = 0;
        this.changelist = "000000";
        this.packagePrefix = "";
        this.githash = "";
    }

    public VersionInfo(String databaseVersion) {
        this.majorVersion = 1;
        this.minorVersion = 0;
        this.patchLevel = 0;
        this.changelist = "000000";
        this.packagePrefix = "";
        this.githash = "";
        this.parseDatabaseVersion(databaseVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public VersionInfo(String packageName, String defaultString) {
        block14: {
            this.majorVersion = 1;
            this.minorVersion = 0;
            this.patchLevel = 0;
            this.changelist = "000000";
            this.packagePrefix = "";
            this.githash = "";
            InputStream in = null;
            Class<?> cls = this.getClass();
            String clazz = cls.getResource("/com/sap/db/util/VersionInfo.class").toString();
            clazz = clazz.substring(0, clazz.indexOf("com/sap/db/util/VersionInfo.class")) + "META-INF/MANIFEST.MF";
            in = new URL(clazz).openStream();
            Manifest mani = new Manifest(in);
            Attributes attr = mani.getMainAttributes();
            this.githash = attr.getValue("Commit-Hash");
            attr = mani.getAttributes("com/sap/db/jdbc/");
            StringBuffer result = new StringBuffer();
            result.append("package com.sap.db.jdbc");
            result.append(", ");
            result.append(attr.getValue("Implementation-Title"));
            result.append(", ");
            result.append(attr.getValue("Implementation-Vendor"));
            result.append(", ");
            this.packagePrefix = result.toString();
            this.parseOldVersion(attr.getValue("Implementation-Version"));
            Object var10_13 = null;
            try {
                if (in != null) {
                    in.close();
                }
                break block14;
            }
            catch (IOException e2) {}
            break block14;
            {
                catch (Exception e) {
                    StringBuffer result2 = new StringBuffer();
                    try {
                        Package p = Package.getPackage(packageName);
                        if (p != null) {
                            result2.append("package ");
                            result2.append(p.getName());
                            result2.append(", ");
                            result2.append(p.getImplementationTitle());
                            result2.append(", ");
                            result2.append(p.getImplementationVendor());
                            result2.append(", ");
                            this.packagePrefix = result2.toString();
                            this.parseOldVersion(p.getImplementationVersion());
                        }
                    }
                    catch (Exception exc) {
                        this.packagePrefix = defaultString;
                    }
                    Object var10_14 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block14;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void parseOldVersion(String VersionString) {
        int startpos = 0;
        int endpos = 0;
        int curpos = 0;
        while (Character.isSpaceChar(VersionString.charAt(curpos))) {
            ++curpos;
        }
        startpos = curpos;
        while (VersionString.charAt(curpos) != '.') {
            ++curpos;
        }
        endpos = curpos++;
        this.majorVersion = Integer.parseInt(VersionString.substring(startpos, endpos));
        startpos = curpos;
        while (VersionString.charAt(curpos) != '.') {
            ++curpos;
        }
        endpos = curpos++;
        this.minorVersion = Integer.parseInt(VersionString.substring(startpos, endpos));
        startpos = curpos;
        while (!Character.isSpaceChar(VersionString.charAt(curpos))) {
            ++curpos;
        }
        endpos = curpos;
        this.patchLevel = Integer.parseInt(VersionString.substring(startpos, endpos));
        while (Character.isSpaceChar(VersionString.charAt(curpos))) {
            ++curpos;
        }
        this.changelist = VersionString.substring(curpos);
    }

    private void parseDatabaseVersion(String databaseVersion) {
        this.majorVersion = 1;
        this.minorVersion = 0;
        this.patchLevel = 0;
        this.changelist = "000000";
        try {
            int startpos = 0;
            int endpos = 0;
            int curpos = 0;
            while (Character.isSpaceChar(databaseVersion.charAt(curpos))) {
                ++curpos;
            }
            startpos = curpos;
            while (databaseVersion.charAt(curpos) != '.') {
                ++curpos;
            }
            endpos = curpos++;
            this.majorVersion = Integer.parseInt(databaseVersion.substring(startpos, endpos));
            startpos = curpos;
            while (databaseVersion.charAt(curpos) != '.') {
                ++curpos;
            }
            endpos = curpos++;
            this.minorVersion = Integer.parseInt(databaseVersion.substring(startpos, endpos));
            startpos = curpos;
            while (databaseVersion.charAt(curpos) != '.') {
                ++curpos;
            }
            endpos = curpos++;
            this.patchLevel = Integer.parseInt(databaseVersion.substring(startpos, endpos));
            this.changelist = databaseVersion.substring(curpos);
        }
        catch (NumberFormatException ignored) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMinorMinorVersion() {
        return this.patchLevel;
    }

    public String getVersionName() {
        return this.changelist;
    }

    public String getPackagePrefix() {
        return this.packagePrefix;
    }

    public String toShortVersionNumberString() {
        StringBuffer result = new StringBuffer();
        result.append(this.majorVersion);
        result.append('.');
        if (this.minorVersion < 10) {
            result.append("0");
        }
        result.append(this.minorVersion);
        result.append('.');
        if (this.patchLevel < 10) {
            result.append('0');
        }
        result.append(this.patchLevel);
        result.append(".");
        result.append(this.changelist);
        return result.toString();
    }

    public String toShortString() {
        StringBuffer result = new StringBuffer();
        result.append(this.packagePrefix);
        result.append(this.majorVersion);
        result.append('.');
        if (this.minorVersion < 10) {
            result.append("0");
        }
        result.append(this.minorVersion);
        result.append('.');
        if (this.patchLevel < 10) {
            result.append('0');
        }
        result.append(this.patchLevel);
        result.append(".");
        result.append(this.changelist);
        return result.toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.packagePrefix);
        result.append(this.majorVersion);
        result.append('.');
        if (this.minorVersion < 10) {
            result.append("0");
        }
        result.append(this.minorVersion);
        result.append('.');
        if (this.patchLevel < 10) {
            result.append('0');
        }
        result.append(this.patchLevel);
        result.append(".");
        result.append(this.changelist);
        result.append(" (Commit-Hash: ");
        result.append(this.githash);
        result.append(")");
        return result.toString();
    }
}

