/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.printf;

import com.sap.db.util.MessageTranslator;
import com.sap.db.util.StringUtil;
import com.sap.db.util.printf.FormatException;
import com.sap.db.util.printf.Formatter;
import com.sap.db.util.printf.OArrayEnumeration;
import com.sap.db.util.printf.PrintfArgumentMismatch;

abstract class DataFormatter
extends Formatter {
    protected char kind;
    protected int width = -1;
    protected int precision = -1;
    protected boolean alignRight = false;
    protected char padChar = (char)32;
    protected static final int defaultValue_C = -1;
    protected static final int dynamicValue_C = -2;

    protected DataFormatter(String format) throws FormatException {
        this.parseFormatString(format);
    }

    String format(OArrayEnumeration objects) throws PrintfArgumentMismatch {
        Object obj;
        int actualWidth = this.width;
        int actualPrecision = this.precision;
        try {
            Number argValue;
            if (this.width == -2) {
                argValue = (Number)objects.nextElement();
                actualWidth = argValue.intValue();
            }
            if (this.precision == -2) {
                argValue = (Number)objects.nextElement();
                actualPrecision = argValue.intValue();
            }
            obj = objects.nextElement();
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            throw new PrintfArgumentMismatch(MessageTranslator.translate("error.format.toofewargs"));
        }
        String result = this.formatObject(obj, this.kind, actualWidth, actualPrecision, this.alignRight, this.padChar);
        return result;
    }

    protected abstract String formatObject(Object var1, int var2, int var3, int var4, boolean var5, char var6) throws PrintfArgumentMismatch;

    protected String formatString(String str, int kind, int width, int precision, boolean alignRight, char padChar) {
        if (width > str.length()) {
            str = alignRight ? StringUtil.padLeft(str, width, padChar) : StringUtil.padRight(str, width, padChar);
        } else if (precision >= 0 && precision < str.length()) {
            str = str.substring(0, precision);
        }
        return str;
    }

    private void parseFormatString(String format) throws FormatException {
        int intval;
        boolean inFlags = true;
        int current = 1;
        int pos = 0;
        if (format.charAt(0) != '%') {
            throw new FormatException(MessageTranslator.translate("error.format.percent"));
        }
        block7: while (inFlags) {
            current = format.charAt(++pos);
            switch (current) {
                case 45: {
                    this.alignRight = true;
                    continue block7;
                }
                case 43: {
                    continue block7;
                }
                case 32: {
                    continue block7;
                }
                case 35: {
                    continue block7;
                }
                case 48: {
                    this.padChar = (char)48;
                    continue block7;
                }
            }
            inFlags = false;
        }
        if (current == 42) {
            this.width = -2;
            current = format.charAt(++pos);
        } else {
            intval = 0;
            while (48 <= current && current <= 57) {
                intval *= 10;
                intval += current - 48;
                current = format.charAt(++pos);
            }
            if (intval != 0) {
                this.width = intval;
            }
        }
        if (current == 46) {
            if ((current = (int)format.charAt(++pos)) == 42) {
                this.width = -2;
                current = format.charAt(++pos);
            } else {
                intval = 0;
                while (48 <= current && current <= 57) {
                    intval *= 10;
                    intval += current - 48;
                    current = format.charAt(++pos);
                }
                if (intval != 0) {
                    this.precision = intval;
                }
            }
        }
        this.kind = (char)current;
    }
}

