/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPartAuthentication;
import com.sap.db.util.FullswapMem;
import com.sap.db.util.StructuredBytes;
import com.sap.db.util.StructuredMem;
import com.sap.db.util.Tracer;
import com.sap.db.util.security.SCRAMMD5;
import com.sap.db.util.security.ScrammMD5Authentication;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;

public class ScrammSHA256Authentication
extends ScrammMD5Authentication {
    public static final String algorithmname = "SCRAMSHA256";
    private ArrayList salt = new ArrayList();

    private static byte[] preprocessPassword(String pwd, boolean isUnicode) throws SQLException {
        try {
            return pwd.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", "UnsupportedEncodingException - character set \"UTF-8\" not supported by the java vm");
        }
    }

    protected byte[] getClientProof(String pass, boolean isUnicode) throws SQLException {
        try {
            byte[] passwdByte = ScrammSHA256Authentication.preprocessPassword(pass, isUnicode);
            internalseed += System.currentTimeMillis();
            byte[] erg = new byte[2 + 33 * this.salt.size()];
            erg[0] = 0;
            erg[1] = (byte)this.salt.size();
            for (int j = 0; j < this.salt.size(); ++j) {
                byte[] clientproof = SCRAMMD5.scrammSHA256((byte[])this.salt.get(j), passwdByte, this.getClientchallenge(), this.serverchallenge);
                erg[2 + j * 33] = 32;
                System.arraycopy(clientproof, 0, erg, 2 + (j + 1) * 1 + j * 32, clientproof.length);
            }
            return erg;
        }
        catch (NoSuchAlgorithmException ex) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", "NoSuchAlgorithmException - algorithm \"SHA-256\" not supported by the java vm");
        }
    }

    public void parseServerChallenge(byte[] vData) throws SQLException {
        internalseed += System.currentTimeMillis();
        DataPartAuthentication vd = new DataPartAuthentication((StructuredMem)new StructuredBytes(vData), 1);
        if (!vd.nextField()) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", Tracer.Hex2String(vData));
        }
        byte[] salt = vd.getBase().getBytes(vd.getCurrentOffset(), vd.getCurrentFieldLen());
        this.salt.add(salt);
        if (!vd.nextField()) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", Tracer.Hex2String(vData));
        }
        while (true) {
            salt = vd.getBase().getBytes(vd.getCurrentOffset(), vd.getCurrentFieldLen());
            if (!vd.nextField()) break;
            this.salt.add(salt);
        }
        this.serverchallenge = salt;
        internalseed += System.currentTimeMillis();
    }

    public int getMaxPasswordLength() {
        return -1;
    }

    String getMethodName() {
        return algorithmname;
    }

    byte[] evaluateAuthReply(DataPartAuthentication vData, Tracer tracer) throws SQLException {
        internalseed += System.currentTimeMillis();
        DataPartAuthentication vd = new DataPartAuthentication((StructuredMem)new FullswapMem(vData.getBase().getBytes(vData.getCurrentOffset(), vData.getCurrentFieldLen())), 1);
        if (!vd.nextField()) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", Tracer.Hex2String(vData.getBase().getBytes(0, vData.size())));
        }
        byte[] salt = vd.getBase().getBytes(vd.getCurrentOffset(), vd.getCurrentFieldLen());
        this.salt.add(salt);
        if (!vd.nextField()) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived", Tracer.Hex2String(vData.getBase().getBytes(0, vData.size())));
        }
        while (true) {
            salt = vd.getBase().getBytes(vd.getCurrentOffset(), vd.getCurrentFieldLen());
            if (!vd.nextField()) break;
            this.salt.add(salt);
        }
        this.serverchallenge = salt;
        internalseed += System.currentTimeMillis();
        return null;
    }

    boolean supportsMultipleFinalData() throws SQLException {
        return true;
    }
}

