/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.LatencySession;
import com.sap.db.jdbc.Location;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionFactory;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.MessageTranslator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import javax.xml.bind.DatatypeConverter;

@NotThreadSafe
public class BasicSession
extends Session {
    static final SessionFactory SESSION_FACTORY = new SessionFactory(){

        @Override
        public Session newInstance(Tracer tracer, Location location, ConnectionProperties connectionProperties, boolean doConnectExchange) throws RTEException {
            BasicSession initialSession = connectionProperties.hasProperty(ConnectionProperty.LATENCY) ? new LatencySession(tracer, location, connectionProperties) : new BasicSession(tracer, location, connectionProperties);
            initialSession._doInfoExchange();
            Session returnedSession = doConnectExchange ? initialSession._doConnectExchange(SESSION_FACTORY, connectionProperties.getProperty(ConnectionProperty.DATABASE_NAME)) : initialSession;
            return returnedSession;
        }
    };
    private static final Charset CHARSET_ASCII = Charset.forName("ASCII");
    private static final Charset CHARSET_UTF_8 = Charset.forName("UTF-8");
    @GuardedBy(value="ConnectionSapDB (implicit)")
    private final Socket _socket;
    @GuardedBy(value="ConnectionSapDB (implicit)")
    private final InputStream _inputStream;
    @GuardedBy(value="ConnectionSapDB (implicit)")
    private final OutputStream _outputStream;

    BasicSession(Tracer tracer, Location location, ConnectionProperties connectionProperties) throws RTEException {
        super(tracer, location, connectionProperties);
        String hostName = location.getHostName();
        int portNumber = location.getPortNumber();
        try {
            this._socket = this._openSocket(tracer, hostName, portNumber, connectionProperties);
            this._inputStream = this._socket.getInputStream();
            this._outputStream = this._socket.getOutputStream();
        }
        catch (IOException e) {
            this.destroy();
            throw new RTEException(tracer, MessageTranslator.translate("error.host.connect", hostName + ":" + portNumber, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
        }
    }

    @Override
    protected Socket _getSocket() {
        return this._socket;
    }

    @Override
    protected InputStream _getInputStream() {
        return this._inputStream;
    }

    @Override
    protected OutputStream _getOutputStream() {
        return this._outputStream;
    }

    private Socket _openSocket(Tracer tracer, String hostName, int portNumber, ConnectionProperties connectionProperties) throws RTEException {
        Socket socket = null;
        String proxyHostName = connectionProperties.getProperty(ConnectionProperty.PROXY_HOST_NAME);
        if (tracer.on()) {
            tracer.printMessage("HOSTLIST: [" + hostName + ":" + portNumber + "]");
        }
        if (hostName.equals(Driver.getComputerName()) || hostName.equals(Driver.getFullComputerName())) {
            hostName = "localhost";
        }
        try {
            if (!proxyHostName.isEmpty()) {
                String proxyUserName;
                int proxyPort = connectionProperties.getIntProperty(ConnectionProperty.PROXY_PORT);
                char[] proxyPassword = connectionProperties.getProperty(ConnectionProperty.PROXY_PASSWD).toCharArray();
                String proxyScpAccount = connectionProperties.getProperty(ConnectionProperty.PROXY_SCP_ACCOUNT);
                if (!proxyScpAccount.isEmpty()) {
                    int idx = proxyScpAccount.indexOf(46);
                    if (idx != -1) {
                        byte[] leftPart = proxyScpAccount.substring(0, idx - 1).getBytes(CHARSET_ASCII);
                        byte[] rightPart = proxyScpAccount.substring(idx + 1).getBytes(CHARSET_ASCII);
                        proxyUserName = "1." + DatatypeConverter.printBase64Binary((byte[])leftPart) + '.' + DatatypeConverter.printBase64Binary((byte[])rightPart);
                    } else {
                        proxyUserName = "1." + DatatypeConverter.printBase64Binary((byte[])proxyScpAccount.getBytes(CHARSET_UTF_8));
                    }
                } else {
                    proxyUserName = connectionProperties.getProperty(ConnectionProperty.PROXY_USER_NAME);
                }
                socket = new Socket(new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(proxyHostName, proxyPort)));
                final String f_proxyUserName = proxyUserName;
                final char[] f_proxyPassword = proxyPassword;
                Authenticator authenticator = new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(f_proxyUserName, f_proxyPassword);
                    }
                };
                Authenticator.setDefault(authenticator);
                socket.connect(new InetSocketAddress(hostName, portNumber));
            } else {
                socket = new Socket(hostName, portNumber);
            }
            this._setSocketOptions(socket);
        }
        catch (UnknownHostException e) {
            this._throwRTEException(MessageTranslator.translate("error.unknown.host", hostName + ":" + portNumber, e.getMessage(), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN);
        }
        catch (IOException e) {
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName + ":" + portNumber, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
        }
        return socket;
    }
}

