/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionProperty;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

@ThreadSafe
public class ConnectionProperties {
    private static final String[] TRUE_STRINGS = new String[]{"true", "yes", "on"};
    private final Map<ConnectionProperty, String> _map = new ConcurrentHashMap<ConnectionProperty, String>();

    public ConnectionProperties() {
    }

    public ConnectionProperties(ConnectionProperties other) {
        this._map.putAll(other._map);
    }

    public ConnectionProperties(Properties info) {
        if (info == null) {
            return;
        }
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            ConnectionProperty connectionProperty = ConnectionProperty.getConnectionProperty(key.toString());
            if (connectionProperty == null) continue;
            this._map.put(connectionProperty, value.toString());
        }
    }

    public Map<ConnectionProperty, String> getProperties() {
        return Collections.unmodifiableMap(this._map);
    }

    public boolean hasProperty(ConnectionProperty connectionProperty) {
        return this._map.containsKey((Object)connectionProperty);
    }

    public boolean getBooleanProperty(ConnectionProperty connectionProperty) {
        return this.getBooleanProperty(connectionProperty, ConnectionProperties._isTrueString(connectionProperty.getDefaultValue()));
    }

    public boolean getBooleanProperty(ConnectionProperty connectionProperty, boolean defaultValue) {
        boolean result = defaultValue;
        String value = this._map.get((Object)connectionProperty);
        if (value != null) {
            result = ConnectionProperties._isTrueString(value);
        }
        return result;
    }

    public int getIntProperty(ConnectionProperty connectionProperty) {
        return this.getIntProperty(connectionProperty, Integer.parseInt(connectionProperty.getDefaultValue()));
    }

    public int getIntProperty(ConnectionProperty connectionProperty, int defaultValue) {
        int result = defaultValue;
        String value = this._map.get((Object)connectionProperty);
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public long getLongProperty(ConnectionProperty connectionProperty) {
        return this.getLongProperty(connectionProperty, Long.parseLong(connectionProperty.getDefaultValue()));
    }

    public long getLongProperty(ConnectionProperty connectionProperty, long defaultValue) {
        long result = defaultValue;
        String value = this._map.get((Object)connectionProperty);
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public String getProperty(ConnectionProperty connectionProperty) {
        return this.getProperty(connectionProperty, connectionProperty.getDefaultValue());
    }

    public String getProperty(ConnectionProperty connectionProperty, String defaultValue) {
        String result = defaultValue;
        String value = this._map.get((Object)connectionProperty);
        if (value != null) {
            result = value;
        }
        return result;
    }

    public void setProperty(ConnectionProperty connectionProperty, String value) {
        if (connectionProperty == null || value == null) {
            return;
        }
        this._map.put(connectionProperty, value);
    }

    public Properties toProperties() {
        Properties info = new Properties();
        for (Map.Entry<ConnectionProperty, String> entry : this._map.entrySet()) {
            info.setProperty(entry.getKey().getName(), entry.getValue());
        }
        return info;
    }

    private static boolean _isTrueString(String value) {
        if (value == null) {
            return false;
        }
        for (String s : TRUE_STRINGS) {
            if (!value.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }
}

