/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.PartitionParameterInfo;
import com.sap.db.jdbc.packet.PartitionMethod;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Immutable
public final class HashPartitionInfo {
    private final PartitionMethod _partitionMethod;
    private final List<PartitionParameterInfo> _partitionParameterInfoList;
    private final Map<Integer, Integer> _partitionAssignmentMap;
    private final int _rangeCount;
    private final int _parameterCount;
    private final int _partitionCount;

    public HashPartitionInfo(PartitionMethod partitionMethod, List<PartitionParameterInfo> partitionParameterInfoList, Map<Integer, Integer> partitionAssignmentMap, int rangeCount, int parameterCount, int partitionCount) {
        this._partitionMethod = partitionMethod;
        this._partitionParameterInfoList = Collections.unmodifiableList(partitionParameterInfoList);
        this._partitionAssignmentMap = Collections.unmodifiableMap(partitionAssignmentMap);
        this._rangeCount = rangeCount;
        this._parameterCount = parameterCount;
        this._partitionCount = partitionCount;
    }

    public PartitionMethod getPartitionMethod() {
        return this._partitionMethod;
    }

    public List<PartitionParameterInfo> getPartitionParameterInfoList() {
        return this._partitionParameterInfoList;
    }

    public Map<Integer, Integer> getPartitionAssignmentMap() {
        return this._partitionAssignmentMap;
    }

    public int getRangeCount() {
        return this._rangeCount;
    }

    public int getParameterCount() {
        return this._parameterCount;
    }

    public int getPartitionCount() {
        return this._partitionCount;
    }
}

