/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Set;

@ThreadSafe
abstract class AbstractNumericConverter
extends AbstractConverter {
    protected final int _fraction;

    protected AbstractNumericConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, schemaName, tableName, columnName, columnLabel);
        this._fraction = fraction;
    }

    @Override
    public int getScale() {
        return this._fraction;
    }

    @Override
    public Object setObject(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return this.setBoolean((Boolean)value);
        }
        if (value instanceof Byte) {
            return this.setByte((Byte)value);
        }
        if (value instanceof Short) {
            return this.setShort((Short)value);
        }
        if (value instanceof Integer) {
            return this.setInt((Integer)value);
        }
        if (value instanceof Long) {
            return this.setLong((Long)value);
        }
        if (value instanceof Float) {
            return this.setFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return this.setDouble((Double)value);
        }
        if (value instanceof BigDecimal) {
            return this.setBigDecimal((BigDecimal)value);
        }
        if (value instanceof String) {
            return this.setString((String)value);
        }
        return this._defaultSetObject(value);
    }
}

