/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbcext.wrapper;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbcext.wrapper.Connection;
import com.sap.db.jdbcext.wrapper.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;

@ThreadSafe
public class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    private final java.sql.DatabaseMetaData _inner;
    private final Object _creator;
    private final Connection _clientConnection;

    public static DatabaseMetaData newInstance(java.sql.DatabaseMetaData inner, Object creator, Connection clientConnection) {
        return new DatabaseMetaData(inner, creator, clientConnection);
    }

    private DatabaseMetaData(java.sql.DatabaseMetaData inner, Object creator, Connection clientConnection) {
        this._inner = inner;
        this._creator = creator;
        this._clientConnection = clientConnection;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        try {
            return this._inner.allProceduresAreCallable();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        try {
            return this._inner.allTablesAreSelectable();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getURL() throws SQLException {
        try {
            return this._inner.getURL();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getUserName() throws SQLException {
        try {
            return this._inner.getUserName();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this._inner.isReadOnly();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        try {
            return this._inner.nullsAreSortedHigh();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        try {
            return this._inner.nullsAreSortedLow();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        try {
            return this._inner.nullsAreSortedAtStart();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        try {
            return this._inner.nullsAreSortedAtEnd();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        try {
            return this._inner.getDatabaseProductName();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        try {
            return this._inner.getDatabaseProductVersion();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getDriverName() throws SQLException {
        try {
            return this._inner.getDriverName();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getDriverVersion() throws SQLException {
        try {
            return this._inner.getDriverVersion();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getDriverMajorVersion() {
        return this._inner.getDriverMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return this._inner.getDriverMinorVersion();
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        try {
            return this._inner.usesLocalFiles();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        try {
            return this._inner.usesLocalFilePerTable();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        try {
            return this._inner.supportsMixedCaseIdentifiers();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        try {
            return this._inner.storesUpperCaseIdentifiers();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        try {
            return this._inner.storesLowerCaseIdentifiers();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        try {
            return this._inner.storesMixedCaseIdentifiers();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            return this._inner.supportsMixedCaseQuotedIdentifiers();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        try {
            return this._inner.storesUpperCaseQuotedIdentifiers();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        try {
            return this._inner.storesLowerCaseQuotedIdentifiers();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            return this._inner.storesMixedCaseQuotedIdentifiers();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        try {
            return this._inner.getIdentifierQuoteString();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        try {
            return this._inner.getSQLKeywords();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        try {
            return this._inner.getNumericFunctions();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getStringFunctions() throws SQLException {
        try {
            return this._inner.getStringFunctions();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        try {
            return this._inner.getSystemFunctions();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        try {
            return this._inner.getTimeDateFunctions();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        try {
            return this._inner.getSearchStringEscape();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        try {
            return this._inner.getExtraNameCharacters();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        try {
            return this._inner.supportsAlterTableWithAddColumn();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        try {
            return this._inner.supportsAlterTableWithDropColumn();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        try {
            return this._inner.supportsColumnAliasing();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        try {
            return this._inner.nullPlusNonNullIsNull();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        try {
            return this._inner.supportsConvert();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        try {
            return this._inner.supportsConvert(fromType, toType);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        try {
            return this._inner.supportsTableCorrelationNames();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        try {
            return this._inner.supportsDifferentTableCorrelationNames();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        try {
            return this._inner.supportsExpressionsInOrderBy();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        try {
            return this._inner.supportsOrderByUnrelated();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        try {
            return this._inner.supportsGroupBy();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        try {
            return this._inner.supportsGroupByUnrelated();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        try {
            return this._inner.supportsGroupByBeyondSelect();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        try {
            return this._inner.supportsLikeEscapeClause();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        try {
            return this._inner.supportsMultipleResultSets();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        try {
            return this._inner.supportsMultipleTransactions();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        try {
            return this._inner.supportsNonNullableColumns();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        try {
            return this._inner.supportsMinimumSQLGrammar();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        try {
            return this._inner.supportsCoreSQLGrammar();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        try {
            return this._inner.supportsExtendedSQLGrammar();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        try {
            return this._inner.supportsANSI92EntryLevelSQL();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        try {
            return this._inner.supportsANSI92IntermediateSQL();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        try {
            return this._inner.supportsANSI92FullSQL();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        try {
            return this._inner.supportsIntegrityEnhancementFacility();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        try {
            return this._inner.supportsOuterJoins();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        try {
            return this._inner.supportsFullOuterJoins();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        try {
            return this._inner.supportsLimitedOuterJoins();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        try {
            return this._inner.getSchemaTerm();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        try {
            return this._inner.getProcedureTerm();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        try {
            return this._inner.getCatalogTerm();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        try {
            return this._inner.isCatalogAtStart();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        try {
            return this._inner.getCatalogSeparator();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        try {
            return this._inner.supportsSchemasInDataManipulation();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        try {
            return this._inner.supportsSchemasInProcedureCalls();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        try {
            return this._inner.supportsSchemasInTableDefinitions();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        try {
            return this._inner.supportsSchemasInIndexDefinitions();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        try {
            return this._inner.supportsSchemasInPrivilegeDefinitions();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        try {
            return this._inner.supportsCatalogsInDataManipulation();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        try {
            return this._inner.supportsCatalogsInProcedureCalls();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        try {
            return this._inner.supportsCatalogsInTableDefinitions();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        try {
            return this._inner.supportsCatalogsInIndexDefinitions();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        try {
            return this._inner.supportsCatalogsInPrivilegeDefinitions();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        try {
            return this._inner.supportsPositionedDelete();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        try {
            return this._inner.supportsPositionedUpdate();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        try {
            return this._inner.supportsSelectForUpdate();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        try {
            return this._inner.supportsStoredProcedures();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        try {
            return this._inner.supportsSubqueriesInComparisons();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        try {
            return this._inner.supportsSubqueriesInExists();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        try {
            return this._inner.supportsSubqueriesInIns();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        try {
            return this._inner.supportsSubqueriesInQuantifieds();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        try {
            return this._inner.supportsCorrelatedSubqueries();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        try {
            return this._inner.supportsUnion();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        try {
            return this._inner.supportsUnionAll();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        try {
            return this._inner.supportsOpenCursorsAcrossCommit();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        try {
            return this._inner.supportsOpenCursorsAcrossRollback();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        try {
            return this._inner.supportsOpenStatementsAcrossCommit();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        try {
            return this._inner.supportsOpenStatementsAcrossRollback();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        try {
            return this._inner.getMaxBinaryLiteralLength();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        try {
            return this._inner.getMaxCharLiteralLength();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        try {
            return this._inner.getMaxColumnNameLength();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        try {
            return this._inner.getMaxColumnsInGroupBy();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        try {
            return this._inner.getMaxColumnsInIndex();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        try {
            return this._inner.getMaxColumnsInOrderBy();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        try {
            return this._inner.getMaxColumnsInSelect();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        try {
            return this._inner.getMaxColumnsInTable();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxConnections() throws SQLException {
        try {
            return this._inner.getMaxConnections();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        try {
            return this._inner.getMaxCursorNameLength();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        try {
            return this._inner.getMaxIndexLength();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        try {
            return this._inner.getMaxSchemaNameLength();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        try {
            return this._inner.getMaxProcedureNameLength();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        try {
            return this._inner.getMaxCatalogNameLength();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        try {
            return this._inner.getMaxRowSize();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        try {
            return this._inner.doesMaxRowSizeIncludeBlobs();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        try {
            return this._inner.getMaxStatementLength();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxStatements() throws SQLException {
        try {
            return this._inner.getMaxStatements();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        try {
            return this._inner.getMaxTableNameLength();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        try {
            return this._inner.getMaxTablesInSelect();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        try {
            return this._inner.getMaxUserNameLength();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        try {
            return this._inner.getDefaultTransactionIsolation();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        try {
            return this._inner.supportsTransactions();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        try {
            return this._inner.supportsTransactionIsolationLevel(level);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        try {
            return this._inner.supportsDataDefinitionAndDataManipulationTransactions();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        try {
            return this._inner.supportsDataManipulationTransactionsOnly();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        try {
            return this._inner.dataDefinitionCausesTransactionCommit();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        try {
            return this._inner.dataDefinitionIgnoredInTransactions();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getProcedures(catalog, schemaPattern, procedureNamePattern);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getTables(catalog, schemaPattern, tableNamePattern, types);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getSchemas() throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getSchemas();
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getCatalogs() throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getCatalogs();
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getTableTypes() throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getTableTypes();
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getColumnPrivileges(catalog, schema, table, columnNamePattern);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getTablePrivileges(catalog, schemaPattern, tableNamePattern);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getBestRowIdentifier(catalog, schema, table, scope, nullable);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getVersionColumns(catalog, schema, table);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getPrimaryKeys(catalog, schema, table);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getImportedKeys(catalog, schema, table);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getExportedKeys(catalog, schema, table);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getCrossReference(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getTypeInfo() throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getTypeInfo();
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getIndexInfo(catalog, schema, table, unique, approximate);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        try {
            return this._inner.supportsResultSetType(type);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        try {
            return this._inner.supportsResultSetConcurrency(type, concurrency);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        try {
            return this._inner.ownUpdatesAreVisible(type);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        try {
            return this._inner.ownDeletesAreVisible(type);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        try {
            return this._inner.ownInsertsAreVisible(type);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        try {
            return this._inner.othersUpdatesAreVisible(type);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        try {
            return this._inner.othersDeletesAreVisible(type);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        try {
            return this._inner.othersInsertsAreVisible(type);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        try {
            return this._inner.updatesAreDetected(type);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        try {
            return this._inner.deletesAreDetected(type);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        try {
            return this._inner.insertsAreDetected(type);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        try {
            return this._inner.supportsBatchUpdates();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getUDTs(catalog, schemaPattern, typeNamePattern, types);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        return (java.sql.Connection)this._creator;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        try {
            return this._inner.supportsSavepoints();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        try {
            return this._inner.supportsNamedParameters();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        try {
            return this._inner.supportsMultipleOpenResults();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        try {
            return this._inner.supportsGetGeneratedKeys();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getSuperTypes(catalog, schemaPattern, typeNamePattern);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getSuperTables(catalog, schemaPattern, tableNamePattern);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        try {
            return this._inner.supportsResultSetHoldability(holdability);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this._inner.getResultSetHoldability();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        try {
            return this._inner.getDatabaseMajorVersion();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        try {
            return this._inner.getDatabaseMinorVersion();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        try {
            return this._inner.getJDBCMajorVersion();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        try {
            return this._inner.getJDBCMinorVersion();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getSQLStateType() throws SQLException {
        try {
            return this._inner.getSQLStateType();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        try {
            return this._inner.locatorsUpdateCopy();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        try {
            return this._inner.supportsStatementPooling();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        try {
            return this._inner.getRowIdLifetime();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getSchemas(catalog, schemaPattern);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        try {
            return this._inner.supportsStoredFunctionsUsingCallSyntax();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        try {
            return this._inner.autoCommitFailureClosesAllResultSets();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getClientInfoProperties() throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getClientInfoProperties();
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getFunctions(catalog, schemaPattern, functionNamePattern);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getFunctionColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getPseudoColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        try {
            return this._inner.generatedKeyAlwaysReturned();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public long getMaxLogicalLobSize() throws SQLException {
        try {
            return this._inner.getMaxLogicalLobSize();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean supportsRefCursors() throws SQLException {
        try {
            return this._inner.supportsRefCursors();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return this._inner.unwrap(iface);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            return this._inner.isWrapperFor(iface);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }
}

