/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import com.sap.db.util.MessageTranslator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

@Immutable
public final class DriverVersionInfo {
    private final int _majorVersion;
    private final int _minorVersion;
    private final int _patchLevel;
    private final String _gitHash;
    private final String _packagePrefix;

    public static DriverVersionInfo newInstance(String packageName) {
        String version;
        try {
            version = MessageTranslator.translate("driver.version", new Object[0]);
        }
        catch (IllegalArgumentException e) {
            version = "1.500.0";
        }
        return new DriverVersionInfo(packageName, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DriverVersionInfo(String packageName, String version) {
        int majorVersion = 0;
        int minorVersion = 0;
        int patchLevel = 0;
        String gitHash = "";
        String packagePrefix = "";
        InputStream is = null;
        String[] components = version.split("[.-]");
        int n = components.length;
        if (n >= 3 && n <= 5) {
            try {
                majorVersion = Integer.parseInt(components[0]);
                minorVersion = Integer.parseInt(components[1]);
                patchLevel = Integer.parseInt(components[2]);
                if (n >= 4) {
                    gitHash = components[n - 1];
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this._majorVersion = majorVersion;
        this._minorVersion = minorVersion;
        this._patchLevel = patchLevel;
        this._gitHash = gitHash;
        try {
            String clas = this.getClass().getResource("/com/sap/db/util/VersionInfo.class").toString();
            clas = clas.substring(0, clas.indexOf("com/sap/db/util/VersionInfo.class")) + "META-INF/MANIFEST.MF";
            is = new URL(clas).openStream();
            Manifest manifest = new Manifest(is);
            Attributes attr = manifest.getMainAttributes();
            packagePrefix = packageName + ", " + attr.getValue("Implementation-Title") + ", " + attr.getValue("Implementation-Vendor") + ", ";
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        this._packagePrefix = packagePrefix;
    }

    public String toString() {
        return this._packagePrefix + this.toShortVersionNumberString();
    }

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public int getPatchLevel() {
        return this._patchLevel;
    }

    public String getGitHash() {
        return this._gitHash;
    }

    public String getPackagePrefix() {
        return this._packagePrefix;
    }

    public String toShortVersionNumberString() {
        return this._majorVersion + "." + this._minorVersion + "." + this._patchLevel + "-" + this._gitHash;
    }
}

