/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.Driver;
import com.sap.db.util.StringUtils;
import com.sap.db.util.WindowsRegistryUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;

@ThreadSafe
public final class PlatformUtils {
    private static final boolean IS_WINDOWS;
    private static final boolean IS_LINUX;
    private static final boolean IS_AIX;
    private static final boolean IS_HPUX;
    private static final boolean IS_MACOS;
    private static final boolean IS_SUNOS;
    private static final int DEFAULT_TIMEOUT = 10;
    private static final TimeUnit DEFAULT_TIMEOUT_UNITS;
    @GuardedBy(value="PlatformUtils.class")
    private static String _windowsSystemRoot;

    private PlatformUtils() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean isLinux() {
        return IS_LINUX;
    }

    public static boolean isAIX() {
        return IS_AIX;
    }

    public static boolean isHPUX() {
        return IS_HPUX;
    }

    public static boolean isMacOS() {
        return IS_MACOS;
    }

    public static boolean isSunOS() {
        return IS_SUNOS;
    }

    public static Process exec(String command, String errorMessage) {
        return PlatformUtils._exec(command, errorMessage, 10, DEFAULT_TIMEOUT_UNITS);
    }

    public static Process exec(String command, String errorMessage, int timeout, TimeUnit timeoutUnits) {
        return PlatformUtils._exec(command, errorMessage, timeout, timeoutUnits);
    }

    public static Process execWindowsSystemExecutable(String executableName, String arguments, String errorMessage) {
        return PlatformUtils._execWindowsSystemExecutable(executableName, arguments, errorMessage, 10, DEFAULT_TIMEOUT_UNITS);
    }

    public static Process execWindowsSystemExecutable(String executableName, String arguments, String errorMessage, int timeout, TimeUnit timeoutUnits) {
        return PlatformUtils._execWindowsSystemExecutable(executableName, arguments, errorMessage, timeout, timeoutUnits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getWindowsSID() {
        String errorMessage = "Can't get user SID";
        BufferedReader reader = null;
        try {
            String sid;
            Process process = PlatformUtils.execWindowsSystemExecutable("whoami.exe", "/user /fo csv /nh", errorMessage);
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine();
            if (line == null) {
                String string = null;
                return string;
            }
            String[] values = line.split(",");
            if (values.length < 2) {
                String string = null;
                return string;
            }
            String string = sid = StringUtils.unquote(values[1], '\"', '\u0000', true, false);
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Process _exec(String command, String errorMessage, int timeout, TimeUnit timeoutUnits) {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(command);
            if (Driver.getJavaVersion() >= 8) {
                boolean wasCompleted = process.waitFor(timeout, timeoutUnits);
                if (!wasCompleted) {
                    return process;
                }
            } else {
                process.waitFor();
            }
            if (process.exitValue() == 0) return process;
        }
        catch (IOException iOException) {
            return process;
        }
        catch (SecurityException securityException) {
            return process;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return process;
    }

    private static Process _execWindowsSystemExecutable(String executableName, String arguments, String errorMessage, int timeout, TimeUnit timeoutUnits) {
        String systemRoot = PlatformUtils._getWindowsSystemRoot();
        String command = "\"" + (systemRoot != null && !systemRoot.isEmpty() ? systemRoot + "\\System32\\" : "") + executableName + "\" " + arguments;
        return PlatformUtils._exec(command, errorMessage, timeout, timeoutUnits);
    }

    private static synchronized String _getWindowsSystemRoot() {
        if (_windowsSystemRoot != null) {
            return _windowsSystemRoot;
        }
        if (Driver.getJavaVersion() <= 8) {
            _windowsSystemRoot = WindowsRegistryUtils.readString(-2147483646, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", "SystemRoot");
            if (_windowsSystemRoot == null || _windowsSystemRoot.isEmpty()) {
                _windowsSystemRoot = System.getenv("SystemRoot");
            }
        } else {
            _windowsSystemRoot = System.getenv("SystemRoot");
        }
        if (_windowsSystemRoot == null) {
            _windowsSystemRoot = "";
        }
        return _windowsSystemRoot;
    }

    static {
        String osName = System.getProperty("os.name");
        IS_WINDOWS = osName.contains("Windows");
        IS_LINUX = osName.contains("Linux");
        IS_AIX = osName.contains("AIX");
        IS_HPUX = osName.contains("HP");
        IS_MACOS = osName.contains("Mac");
        IS_SUNOS = osName.contains("SunOS");
        DEFAULT_TIMEOUT_UNITS = TimeUnit.SECONDS;
    }
}

