/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.annotations.Immutable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

@Immutable
final class ScramSHA256 {
    private ScramSHA256() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    static byte[] scrammSHA256(byte[] salt, byte[] passwd, byte[] clientKey, byte[] serverKey) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"SHA-256 not implemented");
        }
        int saltLen = salt.length;
        int clientKeyLen = clientKey.length;
        int serverKeyLen = serverKey.length;
        byte[] salted_pass = ScramSHA256._hmac(salt, passwd, digest);
        byte[] client_key = digest.digest(salted_pass);
        byte[] client_verifier = digest.digest(client_key);
        byte[] content = new byte[saltLen + clientKeyLen + serverKeyLen];
        System.arraycopy(salt, 0, content, 0, saltLen);
        System.arraycopy(serverKey, 0, content, saltLen, serverKeyLen);
        System.arraycopy(clientKey, 0, content, saltLen + serverKeyLen, clientKeyLen);
        byte[] sharedKey = ScramSHA256._hmac(content, client_verifier, digest);
        byte[] clientProof = new byte[sharedKey.length];
        for (int i = sharedKey.length - 1; i >= 0; --i) {
            clientProof[i] = (byte)(sharedKey[i] ^ client_key[i]);
        }
        return clientProof;
    }

    private static byte[] _hmac(byte[] data, byte[] key, MessageDigest digest) {
        int i;
        if (key.length > 64) {
            digest.update(key);
            key = digest.digest();
        }
        byte[] ipad = new byte[64];
        byte[] opad = new byte[64];
        for (i = 0; i < 64; ++i) {
            ipad[i] = 54;
            opad[i] = 92;
        }
        for (i = key.length - 1; i >= 0; --i) {
            int n = i;
            ipad[n] = (byte)(ipad[n] ^ key[i]);
            int n2 = i;
            opad[n2] = (byte)(opad[n2] ^ key[i]);
        }
        byte[] content = new byte[data.length + 64];
        System.arraycopy(ipad, 0, content, 0, 64);
        System.arraycopy(data, 0, content, 64, data.length);
        data = digest.digest(content);
        content = new byte[data.length + 64];
        System.arraycopy(opad, 0, content, 0, 64);
        System.arraycopy(data, 0, content, 64, data.length);
        return digest.digest(content);
    }
}

