/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.Location;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionFactory;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.SSLUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

@NotThreadSafe
public class SecureSession
extends Session {
    static final SessionFactory SECURE_SESSION_FACTORY = new SessionFactory(){

        @Override
        public Session newInstance(Tracer tracer, Location location, ConnectionProperties connectionProperties, boolean doConnectExchange) throws RTEException {
            SecureSession initialSession = new SecureSession(tracer, location, connectionProperties);
            initialSession._doInfoExchange();
            Session returnedSession = doConnectExchange ? initialSession._doConnectExchange(SECURE_SESSION_FACTORY, connectionProperties.getProperty(ConnectionProperty.DATABASE_NAME)) : initialSession;
            return returnedSession;
        }
    };
    private final boolean _validateCertificate;
    private final String _hostNameInCertificate;
    private final String _keyStore;
    private final String _keyStoreType;
    private final String _keyStorePasswd;
    private final String _trustStore;
    private final String _trustStoreType;
    private final String _trustStorePasswd;
    private final String _sniHostname;
    @GuardedBy(value="ConnectionSapDB (implicit)")
    private final Socket _socket;
    @GuardedBy(value="ConnectionSapDB (implicit)")
    private final InputStream _inputStream;
    @GuardedBy(value="ConnectionSapDB (implicit)")
    private final OutputStream _outputStream;

    SecureSession(Tracer tracer, Location location, ConnectionProperties connectionProperties) throws RTEException {
        super(tracer, location, connectionProperties);
        this._validateCertificate = connectionProperties.getBooleanProperty(ConnectionProperty.VALIDATE_CERTIFICATE);
        this._hostNameInCertificate = connectionProperties.getProperty(ConnectionProperty.HOST_NAME_IN_CERTIFICATE);
        this._keyStore = connectionProperties.getProperty(ConnectionProperty.KEY_STORE);
        this._keyStoreType = connectionProperties.getProperty(ConnectionProperty.KEY_STORE_TYPE);
        this._keyStorePasswd = connectionProperties.getProperty(ConnectionProperty.KEY_STORE_PASSWD);
        this._trustStore = connectionProperties.getProperty(ConnectionProperty.TRUST_STORE);
        this._trustStoreType = connectionProperties.getProperty(ConnectionProperty.TRUST_STORE_TYPE);
        this._trustStorePasswd = connectionProperties.getProperty(ConnectionProperty.TRUST_STORE_PASSWD);
        this._sniHostname = connectionProperties.getProperty(ConnectionProperty.SNI_HOSTNAME);
        String hostName = location.getHostName();
        int portNumber = location.getPortNumber();
        try {
            this._socket = this._openSocket(tracer, hostName, portNumber);
            this._inputStream = this._socket.getInputStream();
            this._outputStream = this._socket.getOutputStream();
        }
        catch (IOException e) {
            this.destroy();
            throw new RTEException(tracer, MessageTranslator.translate("error.host.connect", hostName + ":" + portNumber, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
        }
    }

    @Override
    protected Socket _getSocket() {
        return this._socket;
    }

    @Override
    protected InputStream _getInputStream() {
        return this._inputStream;
    }

    @Override
    protected OutputStream _getOutputStream() {
        return this._outputStream;
    }

    private Socket _openSocket(Tracer tracer, String hostName, int portNumber) throws RTEException {
        Socket socket = null;
        if (tracer.on()) {
            tracer.printMessage("HOSTLIST: [" + hostName + ":" + portNumber + "]");
        }
        try {
            SSLSocketFactory factory;
            SSLContext sc;
            if (!this._validateCertificate) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                sc = SSLContext.getInstance("TLS");
                sc.init(null, trustAllCerts, new SecureRandom());
                factory = sc.getSocketFactory();
            } else if (this._isSystemDefaultUsed()) {
                factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            } else {
                KeyManagerFactory kmf = this._getKeyManagerFactory(hostName);
                TrustManagerFactory tmf = this._getTrustManagerFactory(hostName);
                Object[] km = null;
                TrustManager[] tm = null;
                if (kmf != null) {
                    km = kmf.getKeyManagers();
                }
                if (tmf != null) {
                    tm = tmf.getTrustManagers();
                }
                sc = SSLContext.getInstance("TLS");
                sc.init((KeyManager[])km, tm, new SecureRandom());
                factory = sc.getSocketFactory();
            }
            socket = factory.createSocket(hostName, portNumber);
            SSLSocket sslsocket = (SSLSocket)socket;
            sslsocket.setUseClientMode(true);
            ArrayList<Object> protocols = new ArrayList<Object>();
            String[] supportedProtocols = sslsocket.getSupportedProtocols();
            for (String protocol : supportedProtocols) {
                if (!protocol.startsWith("TLS")) continue;
                protocols.add(protocol);
            }
            sslsocket.setEnabledProtocols(protocols.toArray(new String[protocols.size()]));
            if (Driver.getJavaVersion() >= 8) {
                SNIHostName serverName = new SNIHostName(this._sniHostname == null ? hostName : this._sniHostname);
                ArrayList<SNIServerName> serverNames = new ArrayList<SNIServerName>(1);
                serverNames.add(serverName);
                SSLParameters params = sslsocket.getSSLParameters();
                params.setServerNames(serverNames);
                sslsocket.setSSLParameters(params);
            }
            sslsocket.startHandshake();
            if (!"*".equals(this._hostNameInCertificate) && this._validateCertificate) {
                SQLException sqlex;
                Certificate[] certs;
                try {
                    certs = sslsocket.getSession().getPeerCertificates();
                }
                catch (SSLPeerUnverifiedException e) {
                    certs = new Certificate[]{};
                }
                if (certs.length == 0) {
                    sqlex = SQLExceptionSapDB.newInstance("error.ssl.nocertificatefound", new String[0]);
                    this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, sqlex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
                }
                try {
                    X509Certificate x509cert = (X509Certificate)certs[0];
                    X500Principal principal = x509cert.getSubjectX500Principal();
                    String rfc2253name = principal.getName("RFC2253");
                    Collection<List<?>> alternativenames = x509cert.getSubjectAlternativeNames();
                    if (!SSLUtils.validateHostName(rfc2253name, alternativenames, this._hostNameInCertificate == null ? hostName : this._hostNameInCertificate)) {
                        sqlex = SQLExceptionSapDB.newInstance("error.ssl.hostnameverificationfailed", rfc2253name, this._hostNameInCertificate == null ? hostName : this._hostNameInCertificate);
                        this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, sqlex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
                    }
                }
                catch (ClassCastException e) {
                    sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.nox509certificate", new String[0]);
                    this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, sqlex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
                }
                catch (CertificateParsingException e) {
                    sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.nox509certificate", new String[0]);
                    this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, sqlex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
                }
            }
            this._setSocketOptions(socket);
        }
        catch (NoSuchAlgorithmException e) {
            SQLException sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.nosuchalgorithm", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        catch (KeyManagementException e) {
            SQLException sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keymanagementexception", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        catch (UnknownHostException e) {
            this._throwRTEException(MessageTranslator.translate("error.unknown.host", hostName, e.getMessage(), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN);
        }
        catch (SSLHandshakeException e) {
            SQLException sqlex = e.getMessage().contains("PKIX path building failed") ? SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.certificatepath", e.getMessage()) : SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.handshake", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName + ":" + portNumber, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN, RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode(), sqlex);
        }
        catch (SSLException e) {
            SQLException sqlex = e.getMessage().contains("Received fatal alert: internal_error") ? SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.nosslsupport", e.getMessage()) : SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.handshake", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName + ":" + portNumber, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN, RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode(), sqlex);
        }
        catch (IOException e) {
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName + ":" + portNumber, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN, RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode());
        }
        return socket;
    }

    private boolean _isSystemDefaultUsed() {
        return this._keyStore == null && this._keyStoreType == null && this._keyStorePasswd == null && this._trustStore == null && this._trustStorePasswd == null && this._trustStoreType == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyManagerFactory _getKeyManagerFactory(String hostName) throws RTEException {
        SQLException sqlex;
        String keyStoreFileName = this._getKeyStoreFileName();
        if (keyStoreFileName == null) {
            return null;
        }
        KeyManagerFactory kmf = null;
        KeyStore ks = null;
        FileInputStream fis = null;
        try {
            kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keymanagerfactorynodefault", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        try {
            ks = KeyStore.getInstance(this._getKeyStoreType());
        }
        catch (KeyStoreException e) {
            sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keystore.create", this._getKeyStoreType(), e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        try {
            fis = new FileInputStream(keyStoreFileName);
            try {
                ks.load(fis, this._getKeyStorePasswd().toCharArray());
            }
            catch (NoSuchAlgorithmException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keystoreloadfailed.nosuchalgorithm", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (CertificateException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keystoreloadfailed.certificate", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (IOException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keystoreloadfailed.ioexception", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            try {
                kmf.init(ks, this._getKeyStorePasswd().toCharArray());
            }
            catch (KeyStoreException e) {
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, "Key manager initialization failed: " + e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
            }
            catch (UnrecoverableKeyException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keymanagerfactory.unrecoverablekey", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (NoSuchAlgorithmException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keymanagerfactory.nosuchalgorithm", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
        }
        catch (FileNotFoundException e) {
            sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keystorefilenotfound", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return kmf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrustManagerFactory _getTrustManagerFactory(String hostName) throws RTEException {
        SQLException sqlex;
        String trustStoreFileName = this._getTrustStoreFileName();
        if (trustStoreFileName == null) {
            return null;
        }
        TrustManagerFactory tmf = null;
        KeyStore ks = null;
        FileInputStream fis = null;
        try {
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.trustmanagerfactorynodefault", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        try {
            ks = KeyStore.getInstance(this._getTrustStoreType());
        }
        catch (KeyStoreException e) {
            sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststore.create", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        try {
            fis = new FileInputStream(trustStoreFileName);
            try {
                String tspass = this._getTrustStorePasswd();
                ks.load(fis, tspass == null ? null : tspass.toCharArray());
            }
            catch (NoSuchAlgorithmException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststoreloadfailed.nosuchalgorithm", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (CertificateException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststoreloadfailed.certificate", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (IOException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststoreloadfailed.ioexception", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            try {
                tmf.init(ks);
            }
            catch (KeyStoreException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.trustmanagerfactory.keystore", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
        }
        catch (FileNotFoundException e) {
            sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststorefilenotfound", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return tmf;
    }

    private String _getKeyStoreFileName() {
        if (this._keyStore == null) {
            return System.getProperty("javax.net.ssl.keyStore");
        }
        return this._keyStore;
    }

    private String _getKeyStoreType() {
        if (this._keyStoreType == null) {
            return "jks";
        }
        return this._keyStoreType;
    }

    private String _getKeyStorePasswd() {
        if (this._keyStorePasswd != null) {
            return this._keyStorePasswd;
        }
        String syspasswd = System.getProperty("javax.net.ssl.keyStorePassword");
        if (syspasswd != null) {
            return syspasswd;
        }
        return "";
    }

    private String _getTrustStoreFileName() {
        if (this._trustStore == null) {
            return System.getProperty("javax.net.ssl.trustStore");
        }
        return this._trustStore;
    }

    private String _getTrustStoreType() {
        if (this._trustStoreType == null) {
            return "jks";
        }
        return this._trustStoreType;
    }

    private String _getTrustStorePasswd() {
        if (this._trustStorePasswd != null) {
            return this._trustStorePasswd;
        }
        String syspasswd = System.getProperty("javax.net.ssl.trustStorePassword");
        return syspasswd;
    }
}

