/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.CharacterConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.Cesu8Utils;
import java.sql.SQLException;
import java.util.Set;

@ThreadSafe
class AlphanumConverter
extends CharacterConverter {
    private static final int ALPHANUM_LENGTH_MASK = 127;
    private static final int ALPHANUM_PURELY_NUMERIC = 128;

    protected AlphanumConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    public int getEstimatedColumnSize() {
        int dataLen = this._length + 1;
        int dataLengthIndicatorLen = HDataPart.getDataLengthIndicatorLength(dataLen);
        return dataLen + dataLengthIndicatorLen;
    }

    @Override
    protected int _putNullInputArg(HDataPart dataPart) {
        return dataPart.putNull(DataType.CHAR);
    }

    @Override
    protected String _getValueAsString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        int valueLength;
        int alphanumLength;
        if (dataPart.isNull(controller)) {
            return null;
        }
        String prefix = "";
        byte[] buffer = dataPart.getRawPacketArray();
        int offset = dataPart.getNonNullDataOffset();
        int length = dataPart.getNonNullDataLength();
        int flags = buffer[offset] & 0xFF;
        String value = Cesu8Utils.getString(buffer, offset + 1, length - 1);
        if ((flags & 0x80) > 0 && (alphanumLength = flags & 0x7F) > (valueLength = value.length())) {
            int prefixLength = alphanumLength - valueLength;
            prefix = String.format("%0" + prefixLength + "d", 0);
        }
        return prefix + value;
    }
}

