/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.DecimalConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Set;

@ThreadSafe
class FixedDecimalConverter
extends DecimalConverter {
    protected FixedDecimalConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    public int getEstimatedColumnSize() {
        byte fixedByteCount = this._dataType.getFixedByteCount();
        return fixedByteCount + 1;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof BigDecimal)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        byte fixedByteCount = this._dataType.getFixedByteCount();
        return fixedByteCount + 1;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof BigDecimal)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        return dataPart.putBigDecimalAsFixedDecimal((BigDecimal)data, this._fraction, this._dataType);
    }

    @Override
    public BigDecimal setString(String value) throws SQLException {
        if (value == null) {
            return null;
        }
        try {
            return new BigDecimal(value.trim());
        }
        catch (NumberFormatException e) {
            throw this._newSetConversionException(value, "BigDecimal");
        }
    }

    @Override
    protected BigDecimal _getValueAsBigDecimal(SQLParamController controller, HDataPart dataPart, boolean doNullCheck) throws SQLException {
        if (doNullCheck && dataPart.isNull(controller)) {
            return null;
        }
        return dataPart.getFixedDecimalAsBigDecimal(this._fraction, this._dataType);
    }
}

