/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.converters.AbstractPutval;
import com.sap.db.jdbc.converters.ReaderFilter;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;

@NotThreadSafe
class PutvalClob
extends AbstractPutval {
    private Reader _reader;
    private String _sourceString;

    protected PutvalClob(Reader reader, long length, int inputFieldPos) {
        super(inputFieldPos);
        this._reader = length >= 0L ? new ReaderFilter(reader, length) : reader;
    }

    protected PutvalClob(String sourceString, int inputFieldPos, HDataPart dataPart, int descriptorOffset) {
        super(inputFieldPos, dataPart, descriptorOffset);
        this._reader = new StringReader(sourceString);
        this._sourceString = sourceString;
    }

    @Override
    public DataType getDataType() {
        return DataType.NCLOB;
    }

    @Override
    public AbstractPutval cloneForBatch() {
        return this._sourceString == null ? this : new PutvalClob(this._sourceString, this._inputFieldPos, this._dataPart, this._descriptorOffset);
    }

    @Override
    public boolean atEnd() {
        return this._reader == null;
    }

    @Override
    public void transferStream(HDataPart dataPart) throws SQLException {
        boolean isStreamExhaused = dataPart.fillWithReader(this._reader, this._descriptorOffset, this._state == AbstractPutval.State.EXECUTE);
        if (isStreamExhaused) {
            this._closeReader();
        }
    }

    @Override
    public void closeStream() {
        this._closeReader();
    }

    public String toString() {
        return "PutValClob:" + this._reader;
    }

    private void _closeReader() {
        try {
            this._reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._reader = null;
    }
}

